/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class FieldElement
implements Serializable {
    private final BigInteger data;
    private final BigInteger modulus;

    public FieldElement(BigInteger data, BigInteger modulus) {
        this.data = data;
        this.modulus = modulus;
    }

    public abstract FieldElement add(FieldElement var1);

    public FieldElement subtract(FieldElement f) {
        f = f.addInv();
        return this.add(f);
    }

    public abstract FieldElement mult(FieldElement var1);

    public FieldElement divide(FieldElement f) {
        f = f.multInv();
        return this.mult(f);
    }

    public abstract FieldElement addInv();

    public abstract FieldElement multInv();

    public BigInteger getData() {
        return this.data;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.data);
        hash = 89 * hash + Objects.hashCode(this.modulus);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldElement other = (FieldElement)obj;
        if (!Objects.equals(this.data, other.data)) {
            return false;
        }
        return Objects.equals(this.modulus, other.modulus);
    }

    public String toString() {
        return this.getData().toString() + " mod " + this.getModulus().toString();
    }
}

