
ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's kites and darts

	Kites_and_darts(n)	=> attr (delta, 360/10) Wf+Xf+Wf+Xf+Wf+Xf+Wf+Xf+Wf+X, n;
	W	=> [F][++ attr (distance, distance*01.618033989) F][++f--- attr (distance, distance*0.618033989) f|X-Y|f|W];
	X	=> [F+++ attr (distance, distance*01.618033989) F][++ attr (distance, distance*0.618033989) fZ|X|-f|W];
	Y	=> [+F][ attr (distance, distance*01.618033989) F][+f attr (distance, distance*0.618033989) |Y+X];
	Z	=> [-F][ attr (distance, distance*01.618033989) F][ attr (distance, distance*0.618033989) f--Wf|+Z];
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's kites and darts

	Kites_and_darts_color(n)	=> attr (delta, 360/10) Wf+Xf+Wf+Xf+Wf+Xf+Wf+Xf+Wf+X, n;
	W	=> [F][++ attr (distance, distance*01.618033989) F][++f--- attr (distance, distance*0.618033989) f|X-Y|f|W];
	X	=> [F+++ attr (distance, distance*01.618033989) F][++ attr (distance, distance*0.618033989) fZ|X|-f|W];
	Y	=> [+F][ attr (distance, distance*01.618033989) F][+f attr (distance, distance*0.618033989) |Y+X];
	Z	=> [-F][ attr (distance, distance*01.618033989) F][ attr (distance, distance*0.618033989) f--Wf|+Z];
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses

	Penrose(n)	=> attr (delta, 360/10) +WF--XF---YF--ZF, n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses
	// Uses color to show similar lines

	Penrose_color(n)	=> attr (delta, 360/10) +WF--XF---YF--ZF, n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses
	// Uses color to show the edge matching rules to force nonperiodicy

	Penrose_forced(n)	=> attr (delta, 360/10) +WFF--XFF---YFF--ZFF, n;
	W	=> YFF++ZFF----XFF[-YFF----WFF]++;
	X	=> +YFF--ZFF[---WFF--XFF]+;
	Y	=> -WFF++XFF[+++YFF++ZFF]-;
	Z	=> --YFF++++WFF[+ZFF++++XFF]--XFF;
	F	=> ;
	C	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses

	Penrose1(n)	=> attr (delta, 360/10) ++ZF----XF-YF----WF, n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses

	Penrose2(n)	=> attr (delta, 360/10) [X]++[X]++[X]++[X]++[X], n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses

	Penrose3(n)	=> attr (delta, 360/10) [Y]++[Y]++[Y]++[Y]++[Y], n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// This is Penrose3 and Penrose4 superimposed

	Penrose_double(n)	=> attr (delta, 360/10) [X][Y]++[X][Y]++[X][Y]++[X][Y]++[X][Y], n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (
	// Manual construction by Roger Penrose as a prelude to his development of
	// the famous Penrose tiles (the kites and darts) that tile the plane
	// only non-periodically.
	// Translated first to a "dragon curve" and finally to an L-system
	// by Joe Saverino.

	Penta_plexity(n)	=> attr (delta, 360/10) F++F++F++F++F, n;
	F	=> F++F++F|F-F++F;
)

	// old PentaPlexity:
	// Angle 10
	// Axiom F++F++F++F++Fabxjeabxykabxyelbxyeahxyeabiye
	// F=
	// a=Fabxjea
	// b=++F--bxykab
	// x=++++F----xyelbx
	// y=----F++++yeahxy
	// e=--F++eabiye
	// h=+++++F-----hijxlh
	// i=---F+++ijkyhi
	// j=-F+jkleij
	// k=+F-klhajk
	// l=+++F---lhibkl













)

ruleset (
	// by Philippe Hurbain
	// Penrose's rhombuses, generated by decomposition rules
	// x generate the fat rhombus, y the thin one
	// Individualization of rhombuses allows easy coloring
	// 0.618034 is (SQRT(5)-1)/2

	Losanges(n)	=> attr (delta, 360/10) x, n;
	x	=>  attr (distance, distance*0.618034) +F[|y]--F[|x][|+ attr (distance, distance*0.618034) f attr (distance, distance/0.618034) x]---[x]F--[y]F;
	y	=>  attr (distance, distance*0.618034) ++[x]F|+F[|y]-[y]F|+F[|x];
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Simple coloring of Penrose's rhombuses, showing pentagons

	Penta_color(n)	=> attr (delta, 360/20) [x]++++[x]++++[x]++++[x]++++[x], n;
	x	=>  attr (distance, distance*0.618034) ++F[ attr (distance, distance*01.1755) -------F][|y]----F[|x];
	x	=> [|++ attr (distance, distance*0.618034) f attr (distance, distance/0.618034) x]------[x]F----[y]F;
	y	=>  attr (distance, distance*0.618034) ++++[x]F|++F[|y]--[y]F|++F[|x];
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Same as PentaColor, but showing only the coloring

	Penta(n)	=> attr (delta, 360/20) [x]++++[x]++++[x]++++[x]++++[x], n;
	x	=>  attr (distance, distance*0.618034) ++f[ attr (distance, distance*01.1755) -------F][|y]----f[|x];
	x	=> [|++ attr (distance, distance*0.618034) f attr (distance, distance/0.618034) x]------[x]f----[y]f;
	y	=>  attr (distance, distance*0.618034) ++++[x]f|++f[|y]--[y]f|++f[|x];
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Penrose's kites and darts
	// k generates the kite, a generates the dart

	Kites_darts(n)	=> attr (delta, 360/10) k, n;
	k	=> +[ attr (distance, distance*0.618034) a]F attr (distance, distance*0.618034) ---[-k]F-F---[-k] attr (distance, distance/0.618034) F[ attr (distance, distance*0.618034) |a];
	a	=> [ attr (distance, distance*0.618034) k]+F attr (distance, distance*0.618034) [|a]----F+F----[a] attr (distance, distance/0.618034) F;
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Penrose's kites and darts, with kites seed

	Kites_darts1(n)	=> attr (delta, 360/10) [k]++[k]++[k]++[k]++[k], n;
	k	=> +[ attr (distance, distance*0.618034) a]F attr (distance, distance*0.618034) ---[-k]F-F---[-k] attr (distance, distance/0.618034) F[ attr (distance, distance*0.618034) |a];
	a	=> [ attr (distance, distance*0.618034) k]+F attr (distance, distance*0.618034) [|a]----F+F----[a] attr (distance, distance/0.618034) F;
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Penrose's kites and darts, with darts seed

	Kites_darts2(n)	=> attr (delta, 360/10) [a]++[a]++[a]++[a]++[a], n;
	k	=> +[ attr (distance, distance*0.618034) a]F attr (distance, distance*0.618034) ---[-k]F-F---[-k] attr (distance, distance/0.618034) F[ attr (distance, distance*0.618034) |a];
	a	=> [ attr (distance, distance*0.618034) k]+F attr (distance, distance*0.618034) [|a]----F+F----[a] attr (distance, distance/0.618034) F;
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Penrose's kites and darts, with serpentine coloring

	Kites_darts_color(n)	=> attr (delta, 360/10) [k]++[k]++[k]++[k]++[k], n;
	k	=> +[ attr (distance, distance*0.618034) a[f--- attr (distance, distance*0.618) F][--f+++ attr (distance, distance*0.618) F]];
	k	=> F attr (distance, distance*0.618034) ---[-k]F-F---[-k] attr (distance, distance/0.618034) F[ attr (distance, distance*0.618034) |a];
	a	=> [ attr (distance, distance*0.618034) k]+F attr (distance, distance*0.618034) [|a][|f++ attr (distance, distance*0.382) F]----F+;
	a	=> F----[a][f-- attr (distance, distance*0.382) F] attr (distance, distance/0.618034) F;
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Ammann's coloring of Penrose's rhombuses, giving an
	// aperiodic tiling of 2 pentagons and 1 hexagon

	Ammann_poly_color(n)	=> attr (delta, 360/10) x, n;
	x	=>  attr (distance, distance*0.618034) +(36) [ -(9) attr (distance, distance*0.66) F]F[ +(196.5) attr (distance, distance*0.363) F][ +(180) y] -(72) F[ +(180) x];
	x	=> [ -(144) attr (distance, distance*0.618034) f attr (distance, distance/0.618034) x] -(108) [ -(36) attr (distance, distance*0.509) F attr (distance, distance*01.18) -(30) F][x]F[ -(153) attr (distance, distance*0.66) F] -(72) [y]F;
	y	=>  attr (distance, distance*0.618034) +(72) [x][ -(36) attr (distance, distance*0.509) F]F -(144) [ -(9) attr (distance, distance*0.66) F]F[ +(180) y][ +(196.5) attr (distance, distance*0.363) F];
	y	=>  -(36) [y]F -(144) F[ +(180) x];
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Same as AmmanPolyColor, showing only the
	// pentagon/hexagon tiling

	Ammann_poly(n)	=> attr (delta, 360/10) x, n;
	x	=>  attr (distance, distance*0.618034) +(36) [ -(9) attr (distance, distance*0.66) F]f[ +(196.5) attr (distance, distance*0.363) F][ +(180) y] -(72) f[ +(180) x];
	x	=> [ -(144) attr (distance, distance*0.618034) f attr (distance, distance/0.618034) x] -(108) [ -(36) attr (distance, distance*0.509) F attr (distance, distance*01.18) -(30) F][x]f[ -(153) attr (distance, distance*0.66) F] -(72) [y]f;
	y	=>  attr (distance, distance*0.618034) +(72) [x][ -(36) attr (distance, distance*0.509) F]f -(144) [ -(9) attr (distance, distance*0.66) F]f[ +(180) y][ +(196.5) attr (distance, distance*0.363) F];
	y	=>  -(36) [y]f -(144) f[ +(180) x];
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Penrose's stars and pentagon tiling, generated as
	// a coloring of kites and darts

	Stars_pentas_color(n)	=> attr (delta, 360/20) k, n;
	k	=> ++[ attr (distance, distance*0.618034) [f- attr (distance, distance*0.5878) [F]------F F++++F]a]F attr (distance, distance*0.618034) ------;
	k	=> [--k]F--F------[--k] attr (distance, distance/0.618034) F[ attr (distance, distance*0.618034) |a];
	a	=> [ attr (distance, distance*0.618034) k]++F attr (distance, distance*0.618034) [|[f attr (distance, distance*0.5878) +++++++F]a]--------F;
	a	=> ++F--------[f attr (distance, distance*0.5878) -------F][a] attr (distance, distance/0.618034) F;
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Same as Stars&PentasColor, showing only coloring

	Stars_pentas(n)	=> attr (delta, 360/20) [k]++++[k]++++[k]++++[k]++++[k], n;
	k	=> ++[ attr (distance, distance*0.618034) [f- attr (distance, distance*0.5878) [F]------F F++++F]a]f attr (distance, distance*0.618034) ------;
	k	=> [--k]f--f------[--k] attr (distance, distance/0.618034) f[ attr (distance, distance*0.618034) |a];
	a	=> [ attr (distance, distance*0.618034) k]++f attr (distance, distance*0.618034) [|[f attr (distance, distance*0.5878) +++++++F]a]--------f;
	a	=> ++f--------[f attr (distance, distance*0.5878) -------F][a] attr (distance, distance/0.618034) f;
	F	=> f;
)

ruleset (
	// by Philippe Hurbain
	// Penrose's stars and pentagons, generated from
	// decomposition rules
	// u is the star, v is the boat, w is the thin rhombus
	// x, y and z are the pentagons

	Stars_pentas1(n)	=> attr (delta, 360/10) u, n;
	u	=>  attr (distance, distance*0.381966) [v]F[|y][-u]++F|+[v]F[|y]++F|+[v]F[|y]++F|+;
	u	=> [v]F[|y]++F|+[v]F[|y]++F;
	v	=>  attr (distance, distance*0.381966) [v]F[|y]++F|+[v]F[|y]-[u]F-F|+[v]F[|y]++F;
	w	=>  attr (distance, distance*0.381966) f++[u]F|+F-F|+[v]F[|y];
	y	=>  attr (distance, distance*0.381966) [x][y][w]F[|!y]++F++[y][w]F[|!y]++F++[z]F;
	x	=>  attr (distance, distance*0.381966) f++f++[!x][!z]F--[!z]F--[!z]F--[!z]F--[!z]F;
	z	=>  attr (distance, distance*0.381966) [z][x]F++[z]F++[w][y]F[|!y]++F++[z]F;
	F	=> f;
)

