/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto.x25519;

import java.util.Arrays;

public final class Curve25519 {
    private static final int NUM_LIMBS_255BIT = 10;
    private static final int NUM_LIMBS_510BIT = 20;
    private final int[] x_1 = new int[10];
    private final int[] x_2 = new int[10];
    private final int[] x_3 = new int[10];
    private final int[] z_2 = new int[10];
    private final int[] z_3 = new int[10];
    private final int[] A = new int[10];
    private final int[] B = new int[10];
    private final int[] C = new int[10];
    private final int[] D = new int[10];
    private final int[] E = new int[10];
    private final int[] AA = new int[10];
    private final int[] BB = new int[10];
    private final int[] DA = new int[10];
    private final int[] CB = new int[10];
    private final long[] t1 = new long[20];
    private final int[] t2 = new int[20];

    private Curve25519() {
    }

    private void destroy() {
        Arrays.fill(this.x_1, 0);
        Arrays.fill(this.x_2, 0);
        Arrays.fill(this.x_3, 0);
        Arrays.fill(this.z_2, 0);
        Arrays.fill(this.z_3, 0);
        Arrays.fill(this.A, 0);
        Arrays.fill(this.B, 0);
        Arrays.fill(this.C, 0);
        Arrays.fill(this.D, 0);
        Arrays.fill(this.E, 0);
        Arrays.fill(this.AA, 0);
        Arrays.fill(this.BB, 0);
        Arrays.fill(this.DA, 0);
        Arrays.fill(this.CB, 0);
        Arrays.fill(this.t1, 0L);
        Arrays.fill(this.t2, 0);
    }

    private void reduceQuick(int[] x) {
        int index;
        int carry = 19;
        for (index = 0; index < 10; ++index) {
            this.t2[index] = (carry += x[index]) & 0x3FFFFFF;
            carry >>= 26;
        }
        int mask = -(this.t2[9] >> 21 & 1);
        int nmask = ~mask;
        this.t2[9] = this.t2[9] & 0x1FFFFF;
        for (index = 0; index < 10; ++index) {
            x[index] = x[index] & nmask | this.t2[index] & mask;
        }
    }

    private void reduce(int[] result, int[] x, int size) {
        int index;
        int carry = 0;
        int limb = x[9] >> 21;
        x[9] = x[9] & 0x1FFFFF;
        for (index = 0; index < size; ++index) {
            x[index] = (carry += ((limb += x[10 + index] << 5) & 0x3FFFFFF) * 19 + x[index]) & 0x3FFFFFF;
            limb >>= 26;
            carry >>= 26;
        }
        if (size < 10) {
            for (index = size; index < 10; ++index) {
                x[index] = (carry += x[index]) & 0x3FFFFFF;
                carry >>= 26;
            }
        }
        carry = (x[9] >> 21) * 19;
        x[9] = x[9] & 0x1FFFFF;
        for (index = 0; index < 10; ++index) {
            result[index] = (carry += x[index]) & 0x3FFFFFF;
            carry >>= 26;
        }
        this.reduceQuick(result);
    }

    private void mul(int[] result, int[] x, int[] y) {
        int i;
        long v = x[0];
        for (i = 0; i < 10; ++i) {
            this.t1[i] = v * (long)y[i];
        }
        for (i = 1; i < 10; ++i) {
            v = x[i];
            for (int j = 0; j < 9; ++j) {
                int n = i + j;
                this.t1[n] = this.t1[n] + v * (long)y[j];
            }
            this.t1[i + 10 - 1] = v * (long)y[9];
        }
        v = this.t1[0];
        this.t2[0] = (int)v & 0x3FFFFFF;
        for (i = 1; i < 20; ++i) {
            v = (v >> 26) + this.t1[i];
            this.t2[i] = (int)v & 0x3FFFFFF;
        }
        this.reduce(result, this.t2, 10);
    }

    private void square(int[] result, int[] x) {
        this.mul(result, x, x);
    }

    private void mulA24(int[] result, int[] x) {
        long a24 = 121665L;
        long carry = 0L;
        for (int index = 0; index < 10; ++index) {
            this.t2[index] = (int)(carry += a24 * (long)x[index]) & 0x3FFFFFF;
            carry >>= 26;
        }
        this.t2[10] = (int)carry & 0x3FFFFFF;
        this.reduce(result, this.t2, 1);
    }

    private void add(int[] result, int[] x, int[] y) {
        int carry = x[0] + y[0];
        result[0] = carry & 0x3FFFFFF;
        for (int index = 1; index < 10; ++index) {
            carry = (carry >> 26) + x[index] + y[index];
            result[index] = carry & 0x3FFFFFF;
        }
        this.reduceQuick(result);
    }

    private static void sub(int[] result, int[] x, int[] y) {
        int index;
        int borrow = 0;
        for (index = 0; index < 10; ++index) {
            borrow = x[index] - y[index] - (borrow >> 26 & 1);
            result[index] = borrow & 0x3FFFFFF;
        }
        borrow = result[0] - (-(borrow >> 26 & 1) & 0x13);
        result[0] = borrow & 0x3FFFFFF;
        for (index = 1; index < 10; ++index) {
            borrow = result[index] - (borrow >> 26 & 1);
            result[index] = borrow & 0x3FFFFFF;
        }
        result[9] = result[9] & 0x1FFFFF;
    }

    private static void cswap(int select, int[] x, int[] y) {
        select = -select;
        int index = 0;
        while (index < 10) {
            int dummy = select & (x[index] ^ y[index]);
            int n = index;
            x[n] = x[n] ^ dummy;
            int n2 = index++;
            y[n2] = y[n2] ^ dummy;
        }
    }

    private void pow250(int[] result, int[] x) {
        int j;
        this.square(this.A, x);
        for (j = 0; j < 9; ++j) {
            this.square(this.A, this.A);
        }
        this.mul(result, this.A, x);
        for (int i = 0; i < 23; ++i) {
            for (j = 0; j < 10; ++j) {
                this.square(this.A, this.A);
            }
            this.mul(result, result, this.A);
        }
        this.square(this.A, result);
        this.mul(result, result, this.A);
        for (j = 0; j < 8; ++j) {
            this.square(this.A, this.A);
            this.mul(result, result, this.A);
        }
    }

    private void recip(int[] result, int[] x) {
        this.pow250(result, x);
        this.square(result, result);
        this.square(result, result);
        this.mul(result, result, x);
        this.square(result, result);
        this.square(result, result);
        this.mul(result, result, x);
        this.square(result, result);
        this.mul(result, result, x);
    }

    private void evalCurve(byte[] s) {
        int sposn = 31;
        int sbit = 6;
        int svalue = s[sposn] | 0x40;
        int swap = 0;
        while (true) {
            int select = svalue >> sbit & 1;
            Curve25519.cswap(swap ^= select, this.x_2, this.x_3);
            Curve25519.cswap(swap, this.z_2, this.z_3);
            swap = select;
            this.add(this.A, this.x_2, this.z_2);
            this.square(this.AA, this.A);
            Curve25519.sub(this.B, this.x_2, this.z_2);
            this.square(this.BB, this.B);
            Curve25519.sub(this.E, this.AA, this.BB);
            this.add(this.C, this.x_3, this.z_3);
            Curve25519.sub(this.D, this.x_3, this.z_3);
            this.mul(this.DA, this.D, this.A);
            this.mul(this.CB, this.C, this.B);
            this.add(this.x_3, this.DA, this.CB);
            this.square(this.x_3, this.x_3);
            Curve25519.sub(this.z_3, this.DA, this.CB);
            this.square(this.z_3, this.z_3);
            this.mul(this.z_3, this.z_3, this.x_1);
            this.mul(this.x_2, this.AA, this.BB);
            this.mulA24(this.z_2, this.E);
            this.add(this.z_2, this.z_2, this.AA);
            this.mul(this.z_2, this.z_2, this.E);
            if (sbit > 0) {
                --sbit;
                continue;
            }
            if (sposn == 0) break;
            if (sposn == 1) {
                svalue = s[--sposn] & 0xF8;
                sbit = 7;
                continue;
            }
            svalue = s[--sposn];
            sbit = 7;
        }
        Curve25519.cswap(swap, this.x_2, this.x_3);
        Curve25519.cswap(swap, this.z_2, this.z_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void eval(byte[] result, int offset, byte[] privateKey, byte[] publicKey) {
        Curve25519 state = new Curve25519();
        try {
            int word;
            int bit;
            int index;
            if (publicKey != null) {
                for (index = 0; index < 32; ++index) {
                    bit = index * 8 % 26;
                    word = index * 8 / 26;
                    int value = publicKey[index] & 0xFF;
                    if (bit <= 18) {
                        int n = word;
                        state.x_1[n] = state.x_1[n] | value << bit;
                        continue;
                    }
                    int n = word;
                    state.x_1[n] = state.x_1[n] | value << bit;
                    int n2 = word;
                    state.x_1[n2] = state.x_1[n2] & 0x3FFFFFF;
                    int n3 = word + 1;
                    state.x_1[n3] = state.x_1[n3] | value >> 26 - bit;
                }
                state.reduceQuick(state.x_1);
                state.reduceQuick(state.x_1);
            } else {
                state.x_1[0] = 9;
            }
            state.x_2[0] = 1;
            System.arraycopy(state.x_1, 0, state.x_3, 0, state.x_1.length);
            state.z_3[0] = 1;
            state.evalCurve(privateKey);
            state.recip(state.z_3, state.z_2);
            state.mul(state.x_2, state.x_2, state.z_3);
            for (index = 0; index < 32; ++index) {
                bit = index * 8 % 26;
                word = index * 8 / 26;
                result[offset + index] = bit <= 18 ? (byte)(state.x_2[word] >> bit) : (byte)(state.x_2[word] >> bit | state.x_2[word + 1] << 26 - bit);
            }
        }
        finally {
            state.destroy();
        }
    }
}

