/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class URLEditor
extends PropertyEditorSupport
implements XMLPropertyEditor {
    public static final String XML_URL = "Url";
    public static final String ATTR_VALUE = "value";

    @Override
    public void setAsText(String string) {
        if ("null".equals(string)) {
            this.setValue(null);
            return;
        }
        try {
            URL uRL = new URL(string);
            this.setValue(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(malformedURLException.getMessage());
            String string2 = MessageFormat.format(NbBundle.getMessage(URLEditor.class, (String)"FMT_EXC_BAD_URL"), string);
            UIExceptions.annotateUser(illegalArgumentException, malformedURLException.getMessage(), string2, malformedURLException, new Date());
            throw illegalArgumentException;
        }
    }

    @Override
    public String getAsText() {
        URL uRL = (URL)this.getValue();
        return uRL != null ? uRL.toString() : "null";
    }

    @Override
    public String getJavaInitializationString() {
        URL uRL = (URL)this.getValue();
        return "new java.net.URL(\"" + uRL.toString() + "\")";
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_URL.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_VALUE).getNodeValue();
            this.setAsText(string);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_URL);
        element.setAttribute(ATTR_VALUE, this.getAsText());
        return element;
    }
}

