/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasource;

import java.util.Set;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceProvider;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;

public final class DataSourceRepository
extends DataSourceProvider {
    private static DataSourceRepository sharedInstance;
    private final Listener dataChangeListener = new Listener();

    public static synchronized DataSourceRepository sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new DataSourceRepository();
        }
        return sharedInstance;
    }

    @Override
    void registerDataSourcesImpl(Set<? extends DataSource> added) {
        super.registerDataSourcesImpl(added);
        for (DataSource dataSource : added) {
            dataSource.getRepository().addDataChangeListener(this.dataChangeListener, DataSource.class);
        }
    }

    @Override
    void unregisterDataSourcesImpl(Set<? extends DataSource> removed) {
        super.unregisterDataSourcesImpl(removed);
        for (DataSource dataSource : removed) {
            dataSource.getRepository().removeDataChangeListener(this.dataChangeListener);
        }
    }

    private DataSourceRepository() {
        this.registerDataSource(DataSource.ROOT);
    }

    private class Listener
    implements DataChangeListener<DataSource> {
        private Listener() {
        }

        @Override
        public void dataChanged(DataChangeEvent<DataSource> event) {
            Set<DataSource> added = event.getAdded();
            Set<DataSource> removed = event.getRemoved();
            if (!added.isEmpty() || !removed.isEmpty()) {
                DataSourceRepository.this.changeDataSources(added, removed);
            }
        }
    }
}

