/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.java.decompiler.api.plugin.LanguageSpec;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.IdentityRenamerFactory;
import org.jetbrains.java.decompiler.main.Init;
import org.jetbrains.java.decompiler.main.decompiler.OptionParser;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.main.extern.IVariableNamingFactory;
import org.jetbrains.java.decompiler.main.extern.TextTokenVisitor;
import org.jetbrains.java.decompiler.main.plugins.PluginContext;
import org.jetbrains.java.decompiler.modules.renamer.ConverterHelper;
import org.jetbrains.java.decompiler.modules.renamer.IdentifierConverter;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.util.ClasspathScanner;
import org.jetbrains.java.decompiler.util.JrtFinder;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.token.TextTokenDumpVisitor;

public class Fernflower
implements IDecompiledData {
    private final StructContext structContext;
    private final ClassesProcessor classProcessor;
    private final IIdentifierRenamer helper;
    private final IdentifierConverter converter;

    public Fernflower(IResultSaver saver, Map<String, Object> customProperties, IFernflowerLogger logger) {
        this(null, saver, customProperties, logger);
    }

    @Deprecated
    public Fernflower(IBytecodeProvider provider, IResultSaver saver, Map<String, Object> customProperties, IFernflowerLogger logger) {
        String level;
        HashMap<String, Object> properties = new HashMap<String, Object>(IFernflowerPreferences.DEFAULTS);
        if (customProperties != null) {
            for (Map.Entry<String, Object> entry : customProperties.entrySet()) {
                if (entry.getKey().length() == 3) {
                    OptionParser.parseShort("-" + entry.getKey() + "=" + String.valueOf(entry.getValue()), properties);
                    continue;
                }
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        if ((level = (String)properties.get("log-level")) != null) {
            try {
                logger.setSeverity(IFernflowerLogger.Severity.valueOf(level.toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException entry) {
                // empty catch block
            }
        }
        this.structContext = new StructContext(provider, saver, this);
        this.classProcessor = new ClassesProcessor(this.structContext);
        PoolInterceptor interceptor = null;
        if ("1".equals(properties.get("rename-members"))) {
            this.helper = Fernflower.loadHelper((String)properties.get("user-renamer-class"), logger);
            interceptor = new PoolInterceptor();
            this.converter = new IdentifierConverter(this.structContext, this.helper, interceptor);
        } else {
            this.helper = null;
            this.converter = null;
        }
        DecompilerContext context = new DecompilerContext(properties, logger, this.structContext, this.classProcessor, interceptor);
        DecompilerContext.setCurrentContext(context);
        PluginContext plugins = this.structContext.getPluginContext();
        int pluginCount = plugins.findPlugins();
        logger.writeMessage("Loaded " + pluginCount + " plugins", IFernflowerLogger.Severity.INFO);
        plugins.initialize();
        IVariableNamingFactory renamer = plugins.getVariableRenamer();
        if (renamer == null) {
            renamer = new IdentityRenamerFactory();
        }
        context.renamerFactory = renamer;
        String vendor = System.getProperty("java.vendor", "missing vendor");
        String javaVersion = System.getProperty("java.version", "missing java version");
        String jvmVersion = System.getProperty("java.vm.version", "missing jvm version");
        logger.writeMessage(String.format("JVM info: %s - %s - %s", vendor, javaVersion, jvmVersion), IFernflowerLogger.Severity.INFO);
        if (DecompilerContext.getOption("include-classpath")) {
            ClasspathScanner.addAllClasspath(this.structContext);
        } else if (!DecompilerContext.getProperty("include-runtime").toString().isEmpty()) {
            String javaRuntime = DecompilerContext.getProperty("include-runtime").toString();
            if (javaRuntime.equalsIgnoreCase("current") || javaRuntime.equalsIgnoreCase("1")) {
                JrtFinder.addRuntime(this.structContext);
            } else if (!javaRuntime.equalsIgnoreCase("0")) {
                JrtFinder.addRuntime(this.structContext, new File(javaRuntime));
            }
        }
    }

    private static IIdentifierRenamer loadHelper(String className, IFernflowerLogger logger) {
        if (className != null) {
            try {
                Class<?> renamerClass = Fernflower.class.getClassLoader().loadClass(className);
                return (IIdentifierRenamer)renamerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.writeMessage("Cannot load renamer '" + className + "'", IFernflowerLogger.Severity.WARN, e);
            }
        }
        return new ConverterHelper();
    }

    public void addSource(IContextSource source) {
        this.structContext.addSpace(source, true);
    }

    public void addSource(File source) {
        this.structContext.addSpace(source, true);
    }

    public void addLibrary(IContextSource library) {
        this.structContext.addSpace(library, false);
    }

    public void addLibrary(File library) {
        this.structContext.addSpace(library, false);
    }

    public void decompileContext() {
        if (this.converter != null) {
            this.converter.rename();
        }
        this.classProcessor.loadClasses(this.helper);
        this.structContext.saveContext();
    }

    public void addWhitelist(String prefix) {
        this.classProcessor.addWhitelist(prefix);
    }

    public void clearContext() {
        this.structContext.clear();
        DecompilerContext.setCurrentContext(null);
    }

    @Override
    public String getClassEntryName(StructClass cl, String entryName) {
        LanguageSpec spec = PluginContext.getCurrentContext().getLanguageSpec(cl);
        String extension = spec == null ? "java" : spec.extension;
        ClassesProcessor.ClassNode node = this.classProcessor.getMapRootClasses().get(cl.qualifiedName);
        if (node == null || node.type != ClassesProcessor.ClassNode.Type.ROOT) {
            return null;
        }
        if (this.converter != null) {
            String simpleClassName = cl.qualifiedName.substring(cl.qualifiedName.lastIndexOf(47) + 1);
            return entryName.substring(0, entryName.lastIndexOf(47) + 1) + simpleClassName + "." + extension;
        }
        int clazzIdx = entryName.lastIndexOf(".class");
        if (clazzIdx == -1) {
            return entryName + "." + extension;
        }
        return entryName.substring(0, clazzIdx) + "." + extension;
    }

    @Override
    public void processClass(StructClass cl) throws IOException {
        this.classProcessor.processClass(cl);
    }

    @Override
    public String getClassContent(StructClass cl) {
        TextBuffer buffer = new TextBuffer(16384);
        try {
            buffer.append(DecompilerContext.getProperty("banner").toString());
            this.classProcessor.writeClass(cl, buffer);
            if (DecompilerContext.getOption("dump-text-tokens")) {
                buffer.visitTokens(TextTokenVisitor.createVisitor(next -> new TextTokenDumpVisitor(next, buffer)));
            } else {
                buffer.visitTokens(TextTokenVisitor.createVisitor());
            }
            String res = buffer.convertToStringAndAllowDataDiscard();
            if (res == null) {
                return "$ VF: Unable to decompile class " + cl.qualifiedName;
            }
            return res;
        }
        catch (Throwable t) {
            DecompilerContext.getLogger().writeMessage("Class " + cl.qualifiedName + " couldn't be fully decompiled.", t);
            if (DecompilerContext.getOption("dump-exception-on-error")) {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("/*");
                lines.add("$VF: Unable to decompile class");
                lines.addAll(ClassWriter.getErrorComment());
                ClassWriter.collectErrorLines(t, lines);
                lines.add("*/");
                return String.join((CharSequence)DecompilerContext.getNewLineSeparator(), lines);
            }
            return null;
        }
    }

    static {
        Init.init();
    }
}

