/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class ValtrackProtocolDecoder
extends BaseHttpProtocolDecoder {
    public ValtrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String content = request.content().toString(StandardCharsets.UTF_8);
        JsonObject object = Json.createReader((Reader)new StringReader(content)).readObject();
        JsonArray messages = object.getJsonArray("resource");
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < messages.size(); ++i) {
            JsonObject message = messages.getJsonObject(i);
            String id = message.getString("devid");
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
            if (deviceSession == null) continue;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            position.setTime(new Date());
            position.setLatitude(Double.parseDouble(message.getString("lat")));
            position.setLongitude(Double.parseDouble(message.getString("lon")));
            String speed = message.getString("speed");
            if (!speed.isEmpty()) {
                position.setSpeed(Double.parseDouble(speed));
            }
            position.set("battery", Double.parseDouble(message.getString("vbat")));
            positions.add(position);
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return positions;
    }
}

