/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.toolkit.PosHighlighting;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import java.util.LinkedHashSet;

class PosHighlighter {
    private static final NodePattern gerund = CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.lemma("be")), NodePattern.N.withHeadRelation("xcomp|advcl|acl")));

    PosHighlighter() {
    }

    static PosHighlighting posHighlight(Node node) {
        if (EnglishTreePatterns.contractedNot.matches(node)) {
            return PosHighlighting.VERB;
        }
        LinkedHashSet<PosHighlighting> possibilities = new LinkedHashSet<PosHighlighting>();
        if (node.hasPos("MD|VB[PZD]?")) {
            possibilities.add(PosHighlighting.VERB);
        }
        if (node.hasPos("VBG")) {
            if (gerund.matches(node)) {
                possibilities.add(PosHighlighting.VERB);
            } else {
                if (CommonPatterns.possiblyConj(EnglishTreePatterns.clause).matches(node)) {
                    return null;
                }
                possibilities.add(PosHighlighting.NOUN);
            }
        }
        if (node.hasPos("NN.*")) {
            possibilities.add(PosHighlighting.NOUN);
        }
        if (node.hasPos("VBN")) {
            possibilities.add(node.hasHeadRelation("cop|aux|aux:pass") || node.hasForm("been") ? PosHighlighting.VERB : PosHighlighting.ADJECTIVE);
        }
        if (node.hasPos("RB")) {
            possibilities.add(PosHighlighting.ADVERB);
        }
        if (node.hasPos("JJ")) {
            possibilities.add(PosHighlighting.ADJECTIVE);
        }
        if (node.hasPos("CC")) {
            possibilities.add(PosHighlighting.CONJUNCTION);
        }
        if (possibilities.isEmpty()) {
            return null;
        }
        if (possibilities.size() == 1) {
            return (PosHighlighting)((Object)possibilities.iterator().next());
        }
        if (node.hasHeadRelation("dep")) {
            return null;
        }
        return (PosHighlighting)((Object)possibilities.iterator().next());
    }
}

