/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashTrackerListener;
import git4idea.stash.GitStashUtils;
import git4idea.stash.ui.GitStashUIHandler;
import git4idea.ui.StashInfo;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0001J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u0011J\b\u0010\"\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lgit4idea/stash/GitStashTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/stash/GitStashTrackerListener;", "kotlin.jvm.PlatformType", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "value", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lgit4idea/stash/GitStashTracker$Stashes;", "stashes", "getStashes", "()Ljava/util/Map;", "roots", "", "getRoots", "()Ljava/util/Set;", "scheduleRefresh", "", "addListener", "listener", "disposable", "", "Lgit4idea/ui/StashInfo;", "root", "dispose", "Stashes", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashTracker.kt\ngit4idea/stash/GitStashTracker\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n30#2,2:116\n13#3:118\n*S KotlinDebug\n*F\n+ 1 GitStashTracker.kt\ngit4idea/stash/GitStashTracker\n*L\n64#1:116,2\n74#1:118\n*E\n"})
public final class GitStashTracker
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CheckedDisposable disposableFlag;
    @NotNull
    private final EventDispatcher<GitStashTrackerListener> eventDispatcher;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private Map<VirtualFile, ? extends Stashes> stashes;

    public GitStashTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposableFlag = checkedDisposable;
        EventDispatcher eventDispatcher = EventDispatcher.create(GitStashTrackerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.updateQueue = new MergingUpdateQueue("GitStashTracker", 300, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD, null, 128, null);
        this.stashes = MapsKt.emptyMap();
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                boolean bl;
                block8: {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl2;
                            block7: {
                                GitRepository repo = (GitRepository)element$iv;
                                boolean bl3 = false;
                                Iterable $this$any$iv2 = events;
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        VFileEvent e = (VFileEvent)element$iv2;
                                        boolean bl4 = false;
                                        if (!repo.getRepositoryFiles().isStashReflogFile(e.getPath())) continue;
                                        bl2 = true;
                                        break block7;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.scheduleRefresh();
                }
            }
        });
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> GitStashTracker._init_$lambda$0(this));
        Topic<GitRepositoryChangeListener> topic2 = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic2, arg_0 -> GitStashTracker._init_$lambda$1(this, arg_0));
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleRefresh();
        }
    }

    @NotNull
    public final Map<VirtualFile, Stashes> getStashes() {
        return this.stashes;
    }

    @NotNull
    public final Set<VirtualFile> getRoots() {
        return this.stashes.keySet();
    }

    public final void scheduleRefresh() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashUIHandler> serviceClass$iv = GitStashUIHandler.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (!((GitStashUIHandler)object).isStashTabAvailable()) {
            return;
        }
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)this, (Object)"update", () -> GitStashTracker.scheduleRefresh$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        this.updateQueue.queue((Update)disposableUpdate);
    }

    public final void addListener(@NotNull GitStashTrackerListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    @NotNull
    public final List<StashInfo> getStashes(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Stashes stashes = this.stashes.get(root);
        return stashes instanceof Stashes.Loaded ? ((Stashes.Loaded)stashes).getStashes() : CollectionsKt.emptyList();
    }

    public void dispose() {
        this.stashes = MapsKt.emptyMap();
    }

    private static final void _init_$lambda$0(GitStashTracker this$0) {
        this$0.scheduleRefresh();
    }

    private static final void _init_$lambda$1(GitStashTracker this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduleRefresh();
    }

    private static final void scheduleRefresh$lambda$0(GitStashTracker this$0) {
        Map newStashes = new LinkedHashMap();
        for (GitRepository repo : GitRepositoryManager.getInstance(this$0.project).getRepositories()) {
            try {
                Map map2 = newStashes;
                VirtualFile virtualFile = repo.getRoot();
                Project project = this$0.project;
                VirtualFile virtualFile2 = repo.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
                Stashes.Loaded loaded = new Stashes.Loaded(GitStashUtils.loadStashStack(project, virtualFile2));
                map2.put(virtualFile, loaded);
            }
            catch (VcsException e) {
                newStashes.put(repo.getRoot(), new Stashes.Error(e));
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitStashTracker.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
            }
        }
        BaseSingleTaskControllerKt.runInEdt((CheckedDisposable)this$0.disposableFlag, () -> GitStashTracker.scheduleRefresh$lambda$0$0(this$0, newStashes));
    }

    private static final Unit scheduleRefresh$lambda$0$0(GitStashTracker this$0, Map $newStashes) {
        this$0.stashes = $newStashes;
        ((GitStashTrackerListener)this$0.eventDispatcher.getMulticaster()).stashesUpdated();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes;", "", "<init>", "()V", "Loaded", "Error", "Lgit4idea/stash/GitStashTracker$Stashes$Error;", "Lgit4idea/stash/GitStashTracker$Stashes$Loaded;", "intellij.vcs.git"})
    public static abstract sealed class Stashes {
        private Stashes() {
        }

        public /* synthetic */ Stashes(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes$Error;", "Lgit4idea/stash/GitStashTracker$Stashes;", "error", "Lcom/intellij/openapi/vcs/VcsException;", "<init>", "(Lcom/intellij/openapi/vcs/VcsException;)V", "getError", "()Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
        public static final class Error
        extends Stashes {
            @NotNull
            private final VcsException error;

            public Error(@NotNull VcsException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final VcsException getError() {
                return this.error;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes$Loaded;", "Lgit4idea/stash/GitStashTracker$Stashes;", "stashes", "", "Lgit4idea/ui/StashInfo;", "<init>", "(Ljava/util/List;)V", "getStashes", "()Ljava/util/List;", "intellij.vcs.git"})
        public static final class Loaded
        extends Stashes {
            @NotNull
            private final List<StashInfo> stashes;

            public Loaded(@NotNull List<StashInfo> stashes) {
                Intrinsics.checkNotNullParameter(stashes, (String)"stashes");
                super(null);
                this.stashes = stashes;
            }

            @NotNull
            public final List<StashInfo> getStashes() {
                return this.stashes;
            }
        }
    }
}

