/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(i64vec2(-10l, -9l)) => i64vec2(10l, 9l)
 * abs(i64vec2(-9l, -8l)) => i64vec2(9l, 8l)
 * abs(i64vec2(-8l, -7l)) => i64vec2(8l, 7l)
 * abs(i64vec2(-7l, -6l)) => i64vec2(7l, 6l)
 * abs(i64vec2(-6l, -5l)) => i64vec2(6l, 5l)
 * abs(i64vec2(-5l, -4l)) => i64vec2(5l, 4l)
 * abs(i64vec2(-4l, -3l)) => i64vec2(4l, 3l)
 * abs(i64vec2(-3l, -2l)) => i64vec2(3l, 2l)
 * abs(i64vec2(-2l, -1l)) => i64vec2(2l, 1l)
 * abs(i64vec2(-1l, -1l)) => i64vec2(1l, 1l)
 * abs(i64vec2(0l, 0l)) => i64vec2(0l, 0l)
 * abs(i64vec2(0l, 0l)) => i64vec2(0l, 0l)
 * abs(i64vec2(1l, 1l)) => i64vec2(1l, 1l)
 * abs(i64vec2(2l, 2l)) => i64vec2(2l, 2l)
 * abs(i64vec2(3l, 3l)) => i64vec2(3l, 3l)
 * abs(i64vec2(4l, 4l)) => i64vec2(4l, 4l)
 * abs(i64vec2(5l, 5l)) => i64vec2(5l, 5l)
 * abs(i64vec2(6l, 6l)) => i64vec2(6l, 6l)
 * abs(i64vec2(6l, 7l)) => i64vec2(6l, 7l)
 * abs(i64vec2(7l, 8l)) => i64vec2(7l, 8l)
 * abs(i64vec2(8l, 9l)) => i64vec2(8l, 9l)
 * abs(i64vec2(9l, 10l)) => i64vec2(9l, 10l)
 * abs(i64vec2(10l, 11l)) => i64vec2(10l, 11l)
 * abs(i64vec2(11l, 12l)) => i64vec2(11l, 12l)
 * abs(i64vec2(12l, 13l)) => i64vec2(12l, 13l)
 * abs(i64vec2(13l, 14l)) => i64vec2(13l, 14l)
 * abs(i64vec2(14l, 15l)) => i64vec2(14l, 15l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal(abs(i64vec2(-10l, -9l)), i64vec2(10l, 9l))) ? 1 : -1] array0;
  float[all(equal(abs(i64vec2(-9l, -8l)), i64vec2(9l, 8l))) ? 1 : -1] array1;
  float[all(equal(abs(i64vec2(-8l, -7l)), i64vec2(8l, 7l))) ? 1 : -1] array2;
  float[all(equal(abs(i64vec2(-7l, -6l)), i64vec2(7l, 6l))) ? 1 : -1] array3;
  float[all(equal(abs(i64vec2(-6l, -5l)), i64vec2(6l, 5l))) ? 1 : -1] array4;
  float[all(equal(abs(i64vec2(-5l, -4l)), i64vec2(5l, 4l))) ? 1 : -1] array5;
  float[all(equal(abs(i64vec2(-4l, -3l)), i64vec2(4l, 3l))) ? 1 : -1] array6;
  float[all(equal(abs(i64vec2(-3l, -2l)), i64vec2(3l, 2l))) ? 1 : -1] array7;
  float[all(equal(abs(i64vec2(-2l, -1l)), i64vec2(2l, 1l))) ? 1 : -1] array8;
  float[all(equal(abs(i64vec2(-1l, -1l)), i64vec2(1l, 1l))) ? 1 : -1] array9;
  float[all(equal(abs(i64vec2(0l, 0l)), i64vec2(0l, 0l))) ? 1 : -1] array10;
  float[all(equal(abs(i64vec2(0l, 0l)), i64vec2(0l, 0l))) ? 1 : -1] array11;
  float[all(equal(abs(i64vec2(1l, 1l)), i64vec2(1l, 1l))) ? 1 : -1] array12;
  float[all(equal(abs(i64vec2(2l, 2l)), i64vec2(2l, 2l))) ? 1 : -1] array13;
  float[all(equal(abs(i64vec2(3l, 3l)), i64vec2(3l, 3l))) ? 1 : -1] array14;
  float[all(equal(abs(i64vec2(4l, 4l)), i64vec2(4l, 4l))) ? 1 : -1] array15;
  float[all(equal(abs(i64vec2(5l, 5l)), i64vec2(5l, 5l))) ? 1 : -1] array16;
  float[all(equal(abs(i64vec2(6l, 6l)), i64vec2(6l, 6l))) ? 1 : -1] array17;
  float[all(equal(abs(i64vec2(6l, 7l)), i64vec2(6l, 7l))) ? 1 : -1] array18;
  float[all(equal(abs(i64vec2(7l, 8l)), i64vec2(7l, 8l))) ? 1 : -1] array19;
  float[all(equal(abs(i64vec2(8l, 9l)), i64vec2(8l, 9l))) ? 1 : -1] array20;
  float[all(equal(abs(i64vec2(9l, 10l)), i64vec2(9l, 10l))) ? 1 : -1] array21;
  float[all(equal(abs(i64vec2(10l, 11l)), i64vec2(10l, 11l))) ? 1 : -1] array22;
  float[all(equal(abs(i64vec2(11l, 12l)), i64vec2(11l, 12l))) ? 1 : -1] array23;
  float[all(equal(abs(i64vec2(12l, 13l)), i64vec2(12l, 13l))) ? 1 : -1] array24;
  float[all(equal(abs(i64vec2(13l, 14l)), i64vec2(13l, 14l))) ? 1 : -1] array25;
  float[all(equal(abs(i64vec2(14l, 15l)), i64vec2(14l, 15l))) ? 1 : -1] array26;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length());
}
