/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ubi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.plugins.TelemetryAwarePlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.ubi.UbiActionFilter;
import org.opensearch.ubi.UbiRestHandler;
import org.opensearch.ubi.UbiSettings;
import org.opensearch.ubi.ext.UbiParametersExtBuilder;
import org.opensearch.watcher.ResourceWatcherService;

public class UbiPlugin
extends Plugin
implements ActionPlugin,
SearchPlugin,
TelemetryAwarePlugin {
    public static final String UBI_QUERIES_INDEX = "ubi_queries";
    public static final String UBI_EVENTS_INDEX = "ubi_events";
    public static final String EVENTS_MAPPING_FILE = "/events-mapping.json";
    public static final String QUERIES_MAPPING_FILE = "/queries-mapping.json";
    private ActionFilter ubiActionFilter;

    public List<Setting<?>> getSettings() {
        return UbiSettings.getSettings();
    }

    public List<ActionFilter> getActionFilters() {
        return Collections.singletonList(this.ubiActionFilter);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, Tracer tracer, MetricsRegistry metricsRegistry) {
        this.ubiActionFilter = new UbiActionFilter(client, environment, tracer);
        return Collections.emptyList();
    }

    public List<SearchPlugin.SearchExtSpec<?>> getSearchExts() {
        ArrayList searchExts = new ArrayList();
        searchExts.add(new SearchPlugin.SearchExtSpec("ubi", UbiParametersExtBuilder::new, UbiParametersExtBuilder::parse));
        return searchExts;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.singletonList(new UbiRestHandler());
    }
}

