/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools.utils.mergeMetaData;

import java.util.List;
import java.util.Map;
import org.opensearch.agent.tools.utils.mergeMetaData.DeepMergeRule;
import org.opensearch.agent.tools.utils.mergeMetaData.LatestRule;
import org.opensearch.agent.tools.utils.mergeMetaData.MergeRule;

public class MergeRuleHelper {
    private static final List<MergeRule> RULES = List.of(new DeepMergeRule(), new LatestRule());

    public static MergeRule selectRule(Map<String, Object> source, Map<String, Object> target) {
        MergeRule resultRule = RULES.stream().filter(rule -> rule.isMatch(source, target)).findFirst().orElseThrow();
        return resultRule;
    }

    public static void merge(Map<String, Object> source, Map<String, Object> target) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            Map sourceValue = (Map)entry.getValue();
            Map targetValue = (Map)target.get(key);
            MergeRuleHelper.selectRule(sourceValue, targetValue).mergeInto(key, sourceValue, target);
        }
    }
}

