/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import org.opensearch.cluster.routing.allocation.FileCacheThresholdSettings;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.index.store.remote.filecache.AggregateFileCacheStats;

public class FileCacheEvaluator {
    private final FileCacheThresholdSettings fileCacheThresholdSettings;

    public FileCacheEvaluator(FileCacheThresholdSettings fileCacheThresholdSettings) {
        this.fileCacheThresholdSettings = fileCacheThresholdSettings;
    }

    public boolean isNodeExceedingIndexingThreshold(AggregateFileCacheStats aggregateFileCacheStats) {
        if (!this.fileCacheThresholdSettings.isEnabled().booleanValue()) {
            return false;
        }
        if (!this.fileCacheThresholdSettings.getFileCacheIndexThresholdPercentage().equals(0.0)) {
            return aggregateFileCacheStats.getOverallActivePercent() >= this.fileCacheThresholdSettings.getFileCacheIndexThresholdPercentage();
        }
        if (!this.fileCacheThresholdSettings.getFileCacheIndexThresholdBytes().equals((Object)ByteSizeValue.ZERO)) {
            return aggregateFileCacheStats.getActive().getBytes() >= this.fileCacheThresholdSettings.getFileCacheIndexThresholdBytes().getBytes();
        }
        return false;
    }

    public boolean isNodeExceedingSearchThreshold(AggregateFileCacheStats aggregateFileCacheStats) {
        if (!this.fileCacheThresholdSettings.isEnabled().booleanValue()) {
            return false;
        }
        if (!this.fileCacheThresholdSettings.getFileCacheSearchThresholdPercentage().equals(0.0)) {
            return aggregateFileCacheStats.getOverallActivePercent() >= this.fileCacheThresholdSettings.getFileCacheSearchThresholdPercentage();
        }
        if (!this.fileCacheThresholdSettings.getFileCacheSearchThresholdBytes().equals((Object)ByteSizeValue.ZERO)) {
            return aggregateFileCacheStats.getActive().getBytes() >= this.fileCacheThresholdSettings.getFileCacheSearchThresholdBytes().getBytes();
        }
        return false;
    }
}

