/*
 * Decompiled with CFR 0.152.
 */
package org.passay.entropy;

import java.util.List;
import org.passay.AbstractDictionaryRule;
import org.passay.CharacterCharacteristicsRule;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.Rule;
import org.passay.entropy.ShannonEntropy;

public final class ShannonEntropyFactory {
    private static final int COMPOSITION_CHARACTERISTICS_REQUIREMENT = 4;
    private static final PasswordValidator COMPOSITION_VALIDATOR = new PasswordValidator(new CharacterCharacteristicsRule(4, new CharacterRule(EnglishCharacterData.Digit, 1), new CharacterRule(EnglishCharacterData.Special, 1), new CharacterRule(EnglishCharacterData.UpperCase, 1), new CharacterRule(EnglishCharacterData.LowerCase, 1)));

    private ShannonEntropyFactory() {
    }

    public static ShannonEntropy createEntropy(List<? extends Rule> passwordRules, PasswordData passwordData) {
        boolean dictionaryCheck = passwordRules.stream().anyMatch(rule -> rule instanceof AbstractDictionaryRule && ((AbstractDictionaryRule)rule).getDictionary().size() > 0L);
        return ShannonEntropyFactory.createEntropy(dictionaryCheck, passwordData);
    }

    public static ShannonEntropy createEntropy(boolean dictionaryCheck, PasswordData passwordData) {
        if (!passwordData.getOrigin().equals((Object)PasswordData.Origin.User)) {
            throw new IllegalArgumentException("Password data must have an origin of " + (Object)((Object)PasswordData.Origin.User));
        }
        boolean compositionCheck = ShannonEntropyFactory.hasComposition(passwordData);
        return new ShannonEntropy(dictionaryCheck, compositionCheck, passwordData.getPassword().length());
    }

    private static boolean hasComposition(PasswordData passwordData) {
        return COMPOSITION_VALIDATOR.validate(passwordData).isValid();
    }
}

