/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.FileAudioStream;
import org.openhab.core.audio.UnsupportedAudioFormatException;
import org.openhab.core.audio.UnsupportedAudioStreamException;
import org.openhab.core.common.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AudioSinkSync
implements AudioSink {
    private final Logger logger = LoggerFactory.getLogger(AudioSinkSync.class);

    @Override
    public CompletableFuture<@Nullable Void> processAndComplete(@Nullable AudioStream audioStream) {
        CompletableFuture<Object> completableFuture;
        try {
            this.processSynchronously(audioStream);
            completableFuture = CompletableFuture.completedFuture(null);
        }
        catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
            CompletableFuture<Void> completableFuture2;
            block22: {
                try {
                    completableFuture2 = CompletableFuture.failedFuture(e);
                }
                catch (Throwable throwable) {
                    block23: {
                        if (audioStream instanceof Disposable) {
                            Disposable disposableAudioStream = (Disposable)audioStream;
                            try {
                                disposableAudioStream.dispose();
                            }
                            catch (IOException e2) {
                                String fileName;
                                if (audioStream instanceof FileAudioStream) {
                                    FileAudioStream file = (FileAudioStream)audioStream;
                                    v1 = file.toString();
                                } else {
                                    v1 = fileName = "unknown";
                                }
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Cannot dispose of stream {}", (Object)fileName, (Object)e2);
                                    break block23;
                                }
                                this.logger.warn("Cannot dispose of stream {}, reason {}", (Object)fileName, (Object)e2.getMessage());
                            }
                        }
                    }
                    throw throwable;
                }
                if (audioStream instanceof Disposable) {
                    Disposable disposableAudioStream = (Disposable)audioStream;
                    try {
                        disposableAudioStream.dispose();
                    }
                    catch (IOException e3) {
                        String fileName;
                        if (audioStream instanceof FileAudioStream) {
                            FileAudioStream file = (FileAudioStream)audioStream;
                            v2 = file.toString();
                        } else {
                            v2 = fileName = "unknown";
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Cannot dispose of stream {}", (Object)fileName, (Object)e3);
                            break block22;
                        }
                        this.logger.warn("Cannot dispose of stream {}, reason {}", (Object)fileName, (Object)e3.getMessage());
                    }
                }
            }
            return completableFuture2;
        }
        if (audioStream instanceof Disposable) {
            Disposable disposableAudioStream = (Disposable)audioStream;
            try {
                disposableAudioStream.dispose();
            }
            catch (IOException e) {
                String fileName;
                if (audioStream instanceof FileAudioStream) {
                    FileAudioStream file = (FileAudioStream)audioStream;
                    v0 = file.toString();
                } else {
                    v0 = fileName = "unknown";
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Cannot dispose of stream {}", (Object)fileName, (Object)e);
                }
                this.logger.warn("Cannot dispose of stream {}, reason {}", (Object)fileName, (Object)e.getMessage());
            }
        }
        return completableFuture;
    }

    @Override
    public void process(@Nullable AudioStream audioStream) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException {
        this.processSynchronously(audioStream);
    }

    protected abstract void processSynchronously(@Nullable AudioStream var1) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException;
}

