/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.audio.AudioFormat;

@NonNullByDefault
public class AudioWaveUtils {
    private static final int DATA_MAGIC = 1684108385;
    private static final AudioFormat DEFAULT_WAVE_AUDIO_FORMAT = new AudioFormat("WAVE", "PCM_SIGNED", false, 16, 705600, 44100L, 1);

    public static AudioFormat parseWavFormat(InputStream inputStream) throws IOException {
        try {
            inputStream.mark(200);
            javax.sound.sampled.AudioFormat format = AudioSystem.getAudioInputStream(inputStream).getFormat();
            AudioFormat.Encoding javaSoundencoding = format.getEncoding();
            String codecPCMSignedOrUnsigned = AudioFormat.Encoding.PCM_SIGNED.equals(javaSoundencoding) ? "PCM_SIGNED" : (AudioFormat.Encoding.PCM_UNSIGNED.equals(javaSoundencoding) ? "PCM_UNSIGNED" : (AudioFormat.Encoding.ULAW.equals(javaSoundencoding) ? "ULAW" : (AudioFormat.Encoding.ALAW.equals(javaSoundencoding) ? "ALAW" : null)));
            Integer bitRate = Math.round(format.getSampleRate() * (float)format.getSampleSizeInBits() * (float)format.getChannels());
            Long frequency = Float.valueOf(format.getSampleRate()).longValue();
            AudioFormat audioFormat = new AudioFormat("WAVE", codecPCMSignedOrUnsigned, format.isBigEndian(), format.getSampleSizeInBits(), bitRate, frequency, format.getChannels());
            return audioFormat;
        }
        catch (UnsupportedAudioFileException e) {
            AudioFormat audioFormat = DEFAULT_WAVE_AUDIO_FORMAT;
            return audioFormat;
        }
        finally {
            inputStream.reset();
        }
    }

    public static void removeFMT(InputStream data) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(data);
        int nextInt = dataInputStream.readInt();
        int i = 0;
        while (nextInt != 1684108385 && i < 200) {
            nextInt = dataInputStream.readInt();
            ++i;
        }
        dataInputStream.readInt();
    }
}

