/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.proxy.ClobProxy;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class ClobJavaType
extends AbstractClassJavaType<Clob> {
    public static final ClobJavaType INSTANCE = new ClobJavaType();

    public ClobJavaType() {
        super(Clob.class, ClobMutabilityPlan.INSTANCE, IncomparableComparator.INSTANCE);
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.isNationalized() ? indicators.getJdbcType(2011) : super.getRecommendedJdbcType(indicators);
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof Clob;
    }

    @Override
    public String extractLoggableRepresentation(Clob value) {
        return value == null ? "null" : "{clob}";
    }

    @Override
    public String toString(Clob value) {
        return DataHelper.extractString(value);
    }

    @Override
    public Clob fromString(CharSequence string) {
        return ClobProxy.generateProxy(string.toString());
    }

    @Override
    public int extractHashCode(Clob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(Clob one, Clob another) {
        return one == another;
    }

    @Override
    public Clob getReplacement(Clob original, Clob target, SharedSessionContractImplementor session) {
        return session.getJdbcServices().getJdbcEnvironment().getDialect().getLobMergeStrategy().mergeClob(original, target, session);
    }

    @Override
    public <X> X unwrap(Clob value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        try {
            if (Clob.class.isAssignableFrom(type)) {
                return (X)options.getLobCreator().toJdbcClob(value);
            }
            if (String.class.isAssignableFrom(type)) {
                if (value instanceof ClobImplementer) {
                    ClobImplementer clobImplementer = (ClobImplementer)((Object)value);
                    return (X)clobImplementer.getUnderlyingStream().asString();
                }
                return (X)DataHelper.extractString(value.getCharacterStream());
            }
            if (Reader.class.isAssignableFrom(type)) {
                if (value instanceof ClobImplementer) {
                    ClobImplementer clobImplementer = (ClobImplementer)((Object)value);
                    return (X)clobImplementer.getUnderlyingStream().asReader();
                }
                return (X)value.getCharacterStream();
            }
            if (CharacterStream.class.isAssignableFrom(type)) {
                if (value instanceof ClobImplementer) {
                    ClobImplementer clobImplementer = (ClobImplementer)((Object)value);
                    return (X)clobImplementer.getUnderlyingStream();
                }
                return (X)value.getCharacterStream();
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access clob stream", e);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Clob wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        LobCreator lobCreator = options.getLobCreator();
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return lobCreator.wrap(clob);
        }
        if (value instanceof String) {
            String string = (String)value;
            return lobCreator.createClob(string);
        }
        if (value instanceof Reader) {
            Reader reader = (Reader)value;
            return lobCreator.createClob(DataHelper.extractString(reader));
        }
        if (value instanceof CharacterStream) {
            CharacterStream stream = (CharacterStream)value;
            return lobCreator.createClob(stream.asReader(), stream.getLength());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultLobLength();
    }

    public static class ClobMutabilityPlan
    implements MutabilityPlan<Clob> {
        public static final ClobMutabilityPlan INSTANCE = new ClobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Clob deepCopy(Clob value) {
            return value;
        }

        @Override
        public Serializable disassemble(Clob value, SharedSessionContract session) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }

        @Override
        public Clob assemble(Serializable cached, SharedSessionContract session) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }
    }
}

