/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode;

import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.smallrye.common.os.OS;
import org.jboss.logging.Logger;

public class IdeHelper {
    private static final Logger log = Logger.getLogger(IdeHelper.class);

    public static void openBrowser(HttpRootPathBuildItem rp, NonApplicationRootPathBuildItem np, String path, String host, String port) {
        IdeHelper.openBrowser(rp, np, "http", path, host, port);
    }

    public static void openBrowser(HttpRootPathBuildItem rp, NonApplicationRootPathBuildItem np, String protocol, String path, String host, String port) {
        block9: {
            path = path.startsWith("/q") ? np.resolvePath(path.substring(3)) : rp.resolvePath(path.substring(1));
            StringBuilder sb = new StringBuilder(protocol);
            sb.append("://");
            sb.append(host);
            sb.append(":");
            sb.append(port);
            sb.append(path);
            String url = sb.toString();
            Runtime rt = Runtime.getRuntime();
            OS os = OS.current();
            String[] command = null;
            try {
                switch (os) {
                    case MAC: {
                        command = new String[]{"open", url};
                        break;
                    }
                    case LINUX: {
                        command = new String[]{"xdg-open", url};
                        break;
                    }
                    case WINDOWS: {
                        command = new String[]{"rundll32", "url.dll,FileProtocolHandler", url};
                        break;
                    }
                    case OTHER: {
                        log.error((Object)"Cannot launch browser on this operating system");
                    }
                }
                if (command != null) {
                    rt.exec(command);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Failed to launch browser", (Throwable)e);
                if (command == null) break block9;
                log.warn((Object)("Unable to open browser using command: '" + String.join((CharSequence)" ", command) + "'. Failure is: '" + e.getMessage() + "'"));
            }
        }
    }
}

