/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import org.bouncycastle.jsse.provider.ReflectionUtil;

public class IDNUtil {
    public static final int ALLOW_UNASSIGNED = ReflectionUtil.getStaticIntOrDefault("java.net.IDN", "ALLOW_UNASSIGNED", 1);
    public static final int USE_STD3_ASCII_RULES = ReflectionUtil.getStaticIntOrDefault("java.net.IDN", "USE_STD3_ASCII_RULES", 2);
    private static final Method toASCIIMethod = ReflectionUtil.getMethod("java.net.IDN", "toASCII", String.class, Integer.TYPE);
    private static final Method toUnicodeMethod = ReflectionUtil.getMethod("java.net.IDN", "toUnicode", String.class, Integer.TYPE);
    private static final String IDN_CLASSNAME = "java.net.IDN";
    private static final int MAX_LABEL_LENGTH = 63;

    public static String toASCII(String string, int n) {
        if (null != toASCIIMethod) {
            return (String)ReflectionUtil.invokeMethod(null, toASCIIMethod, string, n);
        }
        if (IDNUtil.isRoot(string)) {
            return ".";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = IDNUtil.findSeparator(string, n3);
            String string2 = string.substring(n3, n4);
            String string3 = IDNUtil.toAsciiLabel(string2, n);
            stringBuilder.append(string3);
            if (n4 < string.length()) {
                stringBuilder.append('.');
            }
            n3 = n4 + 1;
        }
        return stringBuilder.toString();
    }

    public static String toUnicode(String string, int n) {
        if (null != toUnicodeMethod) {
            return (String)ReflectionUtil.invokeMethod(null, toUnicodeMethod, string, n);
        }
        if (IDNUtil.isRoot(string)) {
            return ".";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = IDNUtil.findSeparator(string, n3);
            String string2 = string.substring(n3, n4);
            String string3 = IDNUtil.toUnicodeLabel(string2, n);
            stringBuilder.append(string3);
            if (n4 < string.length()) {
                stringBuilder.append('.');
            }
            n3 = n4 + 1;
        }
        return stringBuilder.toString();
    }

    private static int findSeparator(String string, int n) {
        while (n < string.length() && !IDNUtil.isSeparator(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static boolean isAllAscii(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') continue;
            return false;
        }
        return true;
    }

    private static boolean hasAnyNonLDHAscii(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (!('\u0000' <= c && c <= ',' || '.' <= c && c <= '/' || ':' <= c && c <= '@' || '[' <= c && c <= '`') && ('{' > c || c > '\u007f')) continue;
            return true;
        }
        return false;
    }

    private static boolean isRoot(String string) {
        return string.length() == 1 && IDNUtil.isSeparator(string.charAt(0));
    }

    private static boolean isSeparator(char c) {
        switch (c) {
            case '.': 
            case '\u3002': 
            case '\uff0e': 
            case '\uff61': {
                return true;
            }
        }
        return false;
    }

    private static String toAsciiLabel(String string, int n) {
        boolean bl;
        if (string.length() < 1) {
            throw new IllegalArgumentException("Domain name label cannot be empty");
        }
        boolean bl2 = IDNUtil.isAllAscii(string);
        if (!bl2) {
            throw new UnsupportedOperationException("IDN support incomplete");
        }
        boolean bl3 = bl = (n & USE_STD3_ASCII_RULES) != 0;
        if (bl) {
            if (IDNUtil.hasAnyNonLDHAscii(string)) {
                throw new IllegalArgumentException("Domain name label cannot contain non-LDH characters");
            }
            if ('-' == string.charAt(0) || '-' == string.charAt(string.length() - 1)) {
                throw new IllegalArgumentException("Domain name label cannot begin or end with a hyphen");
            }
        }
        if (63 < string.length()) {
            throw new IllegalArgumentException("Domain name label length cannot be more than 63");
        }
        return string;
    }

    private static String toUnicodeLabel(String string, int n) {
        return string;
    }
}

