/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;

public class MultiPartRequestContent
extends MultiPartFormData.ContentSource
implements Request.Content {
    private final String contentType;

    public MultiPartRequestContent() {
        this(MultiPart.generateBoundary((String)"JettyHttpClient-", (int)24));
    }

    public MultiPartRequestContent(String boundary) {
        super(boundary);
        this.contentType = "multipart/form-data; boundary=\"%s\"".formatted(boundary);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    protected HttpFields customizePartHeaders(MultiPart.Part part) {
        Request.Content requestContent;
        String contentType;
        HttpFields headers = super.customizePartHeaders(part);
        if (headers.contains(HttpHeader.CONTENT_TYPE)) {
            return headers;
        }
        Content.Source partContent = part.getContentSource();
        if (partContent instanceof Request.Content && (contentType = (requestContent = (Request.Content)partContent).getContentType()) != null) {
            return HttpFields.build((HttpFields)headers).put(HttpHeader.CONTENT_TYPE, contentType);
        }
        return headers;
    }
}

