/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.JAWT;
import com.sun.opengl.impl.JAWT_DrawingSurface;
import com.sun.opengl.impl.JAWT_DrawingSurfaceInfo;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.JAWT_X11DrawingSurfaceInfo;
import com.sun.opengl.impl.x11.X11GLDrawable;
import com.sun.opengl.impl.x11.X11OnscreenGLContext;
import java.awt.Component;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class X11OnscreenGLDrawable
extends X11GLDrawable {
    public static final int LOCK_SURFACE_NOT_READY = 1;
    public static final int LOCK_SURFACE_CHANGED = 2;
    public static final int LOCK_SUCCESS = 3;
    protected Component component;
    private JAWT_DrawingSurface ds;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_X11DrawingSurfaceInfo x11dsi;
    protected boolean realized;

    public X11OnscreenGLDrawable(Component component) {
        super(null, null);
        this.component = component;
    }

    public GLContext createContext(GLContext gLContext) {
        return new X11OnscreenGLContext(this, gLContext);
    }

    public void setRealized(boolean bl) {
        this.realized = bl;
    }

    public void setSize(int n, int n2) {
        this.component.setSize(n, n2);
    }

    public int getWidth() {
        return this.component.getWidth();
    }

    public int getHeight() {
        return this.component.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapBuffers() throws GLException {
        this.lockToolkit();
        try {
            boolean bl = false;
            if (this.drawable == 0L) {
                if (this.lockSurface() == 1) {
                    return;
                }
                bl = true;
            }
            GLX.glXSwapBuffers(this.display, this.drawable);
            if (bl) {
                this.unlockSurface();
            }
        }
        finally {
            this.unlockToolkit();
        }
    }

    public int lockSurface() throws GLException {
        if (!this.realized) {
            return 1;
        }
        if (this.drawable != 0L) {
            throw new GLException("Surface already locked");
        }
        this.ds = JAWT.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            return 1;
        }
        int n = this.ds.Lock();
        if ((n & 1) != 0) {
            throw new GLException("Unable to lock surface");
        }
        int n2 = 3;
        if ((n & 8) != 0) {
            n2 = 2;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.ds.Unlock();
            JAWT.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            return 1;
        }
        this.x11dsi = (JAWT_X11DrawingSurfaceInfo)this.dsi.platformInfo();
        this.display = this.x11dsi.display();
        this.drawable = this.x11dsi.drawable();
        this.visualID = this.x11dsi.visualID();
        if (this.display == 0L || this.drawable == 0L) {
            this.ds.FreeDrawingSurfaceInfo(this.dsi);
            this.ds.Unlock();
            JAWT.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            this.dsi = null;
            this.x11dsi = null;
            this.display = 0L;
            this.drawable = 0L;
            this.visualID = 0L;
            return 1;
        }
        return n2;
    }

    public void unlockSurface() {
        if (this.drawable == 0L) {
            throw new GLException("Surface already unlocked");
        }
        this.ds.FreeDrawingSurfaceInfo(this.dsi);
        this.ds.Unlock();
        JAWT.getJAWT().FreeDrawingSurface(this.ds);
        this.ds = null;
        this.dsi = null;
        this.x11dsi = null;
        this.display = 0L;
        this.drawable = 0L;
        this.visualID = 0L;
    }
}

