/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * asinh(0.0) => 0.0
 * asinh(1e-10) => 1e-10
 * asinh(-1e-10) => -1e-10
 * asinh(0.1) => 0.09983408
 * asinh(-0.1) => -0.09983408
 * asinh(1.0) => 0.8813736
 * asinh(-1.0) => -0.8813736
 * asinh(10.0) => 2.998223
 * asinh(-10.0) => -2.998223
 * asinh(10000000000.0) => 23.718998
 * asinh(-10000000000.0) => -23.718998
 */
#version 130

void main()
{
  float[distance(asinh(0.0), 0.0) <= 1e-04 ? 1 : -1] array0;
  float[distance(asinh(1e-10), 1e-10) <= 1e-04 ? 1 : -1] array1;
  float[distance(asinh(-1e-10), -1e-10) <= 1e-04 ? 1 : -1] array2;
  float[distance(asinh(0.1), 0.09983408) <= 1e-04 ? 1 : -1] array3;
  float[distance(asinh(-0.1), -0.09983408) <= 1e-04 ? 1 : -1] array4;
  float[distance(asinh(1.0), 0.8813736) <= 0.0008813736 ? 1 : -1] array5;
  float[distance(asinh(-1.0), -0.8813736) <= 0.0008813736 ? 1 : -1] array6;
  float[distance(asinh(10.0), 2.998223) <= 0.002998223 ? 1 : -1] array7;
  float[distance(asinh(-10.0), -2.998223) <= 0.002998223 ? 1 : -1] array8;
  float[distance(asinh(10000000000.0), 23.718998) <= 0.023718998 ? 1 : -1] array9;
  float[distance(asinh(-10000000000.0), -23.718998) <= 0.023718998 ? 1 : -1] array10;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length());
}
