"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _jsYaml = require("js-yaml");
var _moment = _interopRequireDefault(require("moment"));
var _constants2 = require("../../common/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class RulesService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend POST Rules API.
     */
    _defineProperty(this, "createRule", async (context, request, response) => {
      try {
        const {
          id,
          title,
          category,
          description,
          detection,
          status,
          author,
          references,
          tags,
          level,
          false_positives
        } = request.body;
        const today = (0, _moment.default)(_moment.default.now()).format('YYYY/MM/DD');
        const jsonPayload = {
          id: id || _constants2.DEFAULT_RULE_UUID,
          title,
          description: description || title,
          status,
          author,
          date: today,
          modified: today,
          logsource: {
            category
          },
          level,
          detection: (0, _jsYaml.load)(detection)
        };
        if (tags.length > 0) {
          jsonPayload['tags'] = tags.map(tag => tag.value);
        }
        if (references.length > 0) {
          jsonPayload['references'] = references.map(ref => ref.value);
        }
        if (false_positives.length > 0) {
          jsonPayload['falsepositives'] = false_positives.map(falsePos => falsePos.value);
        }
        const ruleYamlPayload = (0, _jsYaml.dump)(jsonPayload);
        const params = {
          body: ruleYamlPayload,
          category: encodeURIComponent(category)
        };
        const client = this.getClient(request, context);
        const createRuleResponse = await client(_constants.CLIENT_RULE_METHODS.CREATE_RULE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createRuleResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - RulesService - createRule:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getRules", async (context, request, response) => {
      try {
        const {
          prePackaged
        } = request.query;
        const params = {
          prePackaged,
          body: request.body
        };
        const client = this.getClient(request, context);
        const getRuleResponse = await client(_constants.CLIENT_RULE_METHODS.GET_RULES, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getRuleResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - RulesService - getRules:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "deleteRule", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const deleteRuleResponse = await client(_constants.CLIENT_RULE_METHODS.DELETE_RULE, request.params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteRuleResponse
          }
        });
      } catch (error) {
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend PUT Rules API.
     */
    _defineProperty(this, "updateRule", async (context, request, response) => {
      try {
        const {
          id,
          title,
          category,
          description,
          detection,
          status,
          author,
          references,
          tags,
          level,
          false_positives
        } = request.body;
        const today = (0, _moment.default)(_moment.default.now()).format('YYYY/MM/DD');
        const {
          ruleId
        } = request.params;
        const jsonPayload = {
          id,
          title,
          description: description || title,
          status,
          author,
          date: today,
          modified: today,
          logsource: {
            category
          },
          level,
          detection: (0, _jsYaml.load)(detection)
        };
        if (tags.length > 0) {
          jsonPayload['tags'] = tags.map(tag => tag.value);
        }
        if (references.length > 0) {
          jsonPayload['references'] = references.map(ref => ref.value);
        }
        if (false_positives.length > 0) {
          jsonPayload['falsepositives'] = false_positives.map(falsePos => falsePos.value);
        }
        const ruleYamlPayload = (0, _jsYaml.dump)(jsonPayload);
        const params = {
          body: ruleYamlPayload,
          category,
          ruleId
        };
        const client = this.getClient(request, context);
        const createRuleResponse = await client(_constants.CLIENT_RULE_METHODS.UPDATE_RULE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createRuleResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - RulesService - updateRule:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = RulesService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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