"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMLRoutes = registerMLRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// eslint-disable-next-line @typescript-eslint/no-var-requires
const performance = require('perf_hooks').performance;
function registerMLRoutes(router, dataSourceEnabled) {
  router.post({
    path: `${_common.ServiceEndpoints.GetModels}/{dataSourceId?}`,
    validate: {
      params: _configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, backendAction('POST', `${_common.ML_MODEL_ROUTE_PREFIX}${_common.SEARCH_API}`, dataSourceEnabled));
}
const backendAction = (method, path, dataSourceEnabled) => {
  return async (context, request, response) => {
    try {
      const dataSourceId = request.params.dataSourceId;
      let callApi;
      if (dataSourceEnabled && dataSourceId) {
        callApi = context.dataSource.opensearch.legacy.getClient(dataSourceId).callAPI;
      } else {
        callApi = context.core.opensearch.legacy.client.callAsCurrentUser;
      }
      const resp = await callApi('transport.request', {
        method,
        path,
        body: {
          query: {
            match_all: {}
          },
          size: 1000
        }
      });
      return response.ok({
        body: resp
      });
    } catch (err) {
      var _err$body;
      console.error('Failed to call ml-commons APIs', err);
      return response.customError({
        statusCode: err.statusCode || 500,
        body: {
          message: err.message,
          attributes: {
            error: ((_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.error) || err.message
          }
        }
      });
    }
  };
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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