/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.flowframework.common.CommonValue;

public class JsonToJsonRecommender {
    private static final ObjectMapper MAPPER;

    private JsonToJsonRecommender() {
    }

    public static StringFormatResult getRecommendationInStringFormat(String inputJson, String outputJson) throws IllegalArgumentException, JsonProcessingException {
        JsonToJsonRecommender.validateInputStrings(inputJson, outputJson);
        JsonNode inputNode = MAPPER.readTree(inputJson);
        JsonNode outputNode = MAPPER.readTree(outputJson);
        MapFormatResult result = JsonToJsonRecommender.getRecommendationInMapFormat(inputNode, outputNode, false);
        String detailedJsonPathString = JsonToJsonRecommender.WriteMappedPathAsString(result.detailedJsonPath);
        String generalizedJsonPathString = JsonToJsonRecommender.WriteMappedPathAsString(result.generalizedJsonPath);
        return new StringFormatResult(detailedJsonPathString, generalizedJsonPathString);
    }

    public static MapFormatResult getRecommendationInMapFormat(JsonNode inputNode, JsonNode outputNode) throws IllegalArgumentException {
        return JsonToJsonRecommender.getRecommendationInMapFormat(inputNode, outputNode, true);
    }

    public static MapFormatResult getRecommendationInMapFormat(JsonNode inputNode, JsonNode outputNode, boolean needValidation) throws IllegalArgumentException {
        if (needValidation) {
            JsonToJsonRecommender.validateInputJsonNode(inputNode, "Input JSON Node");
            JsonToJsonRecommender.validateInputJsonNode(outputNode, "Output JSON Node");
        }
        Map<String, String> inputIndex = JsonToJsonRecommender.createInvertedIndex(inputNode);
        return JsonToJsonRecommender.generateMappings(outputNode, inputIndex, "$");
    }

    public static Map<String, Object> getRecommendationDetailedInMapFormat(JsonNode inputNode, JsonNode outputNode) throws IllegalArgumentException {
        return JsonToJsonRecommender.getRecommendationInMapFormat((JsonNode)inputNode, (JsonNode)outputNode).detailedJsonPath;
    }

    public static Map<String, Object> getRecommendationGeneralizedInMapFormat(JsonNode inputNode, JsonNode outputNode) throws IllegalArgumentException {
        return JsonToJsonRecommender.getRecommendationInMapFormat((JsonNode)inputNode, (JsonNode)outputNode).generalizedJsonPath;
    }

    public static String WriteMappedPathAsString(Map<String, Object> mappedPath) throws JsonProcessingException {
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(mappedPath);
    }

    public static String getRecommendationDetailedInStringFormat(String inputJson, String outputJson) throws IllegalArgumentException, JsonProcessingException {
        return JsonToJsonRecommender.getRecommendationInStringFormat((String)inputJson, (String)outputJson).detailedJsonPathString;
    }

    public static String getRecommendationGeneralizedInStringFormat(String inputJson, String outputJson) throws IllegalArgumentException, JsonProcessingException {
        return JsonToJsonRecommender.getRecommendationInStringFormat((String)inputJson, (String)outputJson).generalizedJsonPathString;
    }

    private static void validateInputStrings(String inputJson, String outputJson) throws IllegalArgumentException {
        if (inputJson == null || outputJson == null) {
            throw new IllegalArgumentException("Input and output JSON strings cannot be null");
        }
        if (inputJson.trim().isEmpty() || outputJson.trim().isEmpty()) {
            throw new IllegalArgumentException("Input and output JSON strings cannot be empty");
        }
        String trimmedInputJson = inputJson.replaceAll("\\s", "");
        String trimmedOutputJson = outputJson.replaceAll("\\s", "");
        if ("{}".equals(trimmedInputJson) || "{}".equals(trimmedOutputJson)) {
            throw new IllegalArgumentException("JSON cannot be an empty map");
        }
    }

    private static void validateInputJsonNode(JsonNode node, String nodeType) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException(nodeType + " cannot be null");
        }
        int maxDepth = JsonToJsonRecommender.getJsonNodeNestingDepth(node);
        if (maxDepth > CommonValue.MAX_JSON_NESTING_DEPTH) {
            throw new IllegalArgumentException(nodeType + " nesting depth (" + maxDepth + ") exceeds the maximum allowed depth (" + CommonValue.MAX_JSON_NESTING_DEPTH + ")");
        }
        JsonToJsonRecommender.validateJsonNodeKeyLengths(node, nodeType);
    }

    private static void validateJsonNodeKeyLengths(JsonNode node, String nodeType) throws IllegalArgumentException {
        block5: {
            block4: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block4;
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry entry = (Map.Entry)fields.next();
                    String key = (String)entry.getKey();
                    if (key.length() > 50000) {
                        throw new IllegalArgumentException(nodeType + " contains a key with length (" + key.length() + ") that exceeds the maximum allowed length (50000)");
                    }
                    JsonToJsonRecommender.validateJsonNodeKeyLengths((JsonNode)entry.getValue(), nodeType);
                }
                break block5;
            }
            if (!node.isArray()) break block5;
            for (JsonNode arrayElement : node) {
                JsonToJsonRecommender.validateJsonNodeKeyLengths(arrayElement, nodeType);
            }
        }
    }

    private static int getJsonNodeNestingDepth(JsonNode node) {
        int maxDepth;
        block4: {
            block3: {
                if (node == null || node.isValueNode()) {
                    return 0;
                }
                maxDepth = 0;
                if (!node.isObject()) break block3;
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry entry = (Map.Entry)fields.next();
                    int childDepth = JsonToJsonRecommender.getJsonNodeNestingDepth((JsonNode)entry.getValue());
                    maxDepth = Math.max(maxDepth, childDepth);
                }
                break block4;
            }
            if (!node.isArray()) break block4;
            for (JsonNode arrayElement : node) {
                int childDepth = JsonToJsonRecommender.getJsonNodeNestingDepth(arrayElement);
                maxDepth = Math.max(maxDepth, childDepth);
            }
        }
        return maxDepth + 1;
    }

    private static Map<String, String> createInvertedIndex(JsonNode node) {
        HashMap<String, String> invertedIndex = new HashMap<String, String>();
        JsonToJsonRecommender.createIndexRecursive(node, "$", invertedIndex);
        return invertedIndex;
    }

    private static void createIndexRecursive(JsonNode node, String path, Map<String, String> invertedIndex) {
        if (node.isObject()) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String newPath = path.isEmpty() ? (String)entry.getKey() : path + "." + (String)entry.getKey();
                JsonToJsonRecommender.createIndexRecursive((JsonNode)entry.getValue(), newPath, invertedIndex);
            }
        } else if (node.isArray()) {
            for (int i = 0; i < node.size(); ++i) {
                JsonToJsonRecommender.createIndexRecursive(node.get(i), path + "[" + i + "]", invertedIndex);
            }
        } else {
            String value = node.asText();
            invertedIndex.putIfAbsent(value, path);
        }
    }

    private static MapFormatResult generateMappings(JsonNode outputNode, Map<String, String> inputIndex, String path) {
        LinkedHashMap<String, String> detailed = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> generalized = new LinkedHashMap<String, String>();
        JsonToJsonRecommender.generateMappingsRecursive(outputNode, inputIndex, path, detailed, generalized);
        return new MapFormatResult(JsonToJsonRecommender.toNestedMapping(detailed), JsonToJsonRecommender.toNestedMapping(generalized));
    }

    private static void generateMappingsRecursive(JsonNode node, Map<String, String> inputIndex, String path, Map<String, String> detailed, Map<String, String> generalized) {
        if (node.isObject()) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String newPath = path.equals("$") ? "$." + (String)entry.getKey() : path + "." + (String)entry.getKey();
                JsonToJsonRecommender.generateMappingsRecursive((JsonNode)entry.getValue(), inputIndex, newPath, detailed, generalized);
            }
        } else if (node.isArray()) {
            int i;
            ArrayList<LinkedHashMap<String, String>> arrayDetailedMappings = new ArrayList<LinkedHashMap<String, String>>();
            ArrayList<Map<String, String>> arrayGeneralizedMappings = new ArrayList<Map<String, String>>();
            for (i = 0; i < node.size(); ++i) {
                String string = path + "[" + i + "]";
                LinkedHashMap<String, String> elementDetailed = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> elementGeneralized = new LinkedHashMap<String, String>();
                JsonToJsonRecommender.generateMappingsRecursive(node.get(i), inputIndex, string, elementDetailed, elementGeneralized);
                arrayDetailedMappings.add(elementDetailed);
                arrayGeneralizedMappings.add(elementGeneralized);
            }
            if (arrayGeneralizedMappings.size() > 1 && JsonToJsonRecommender.areArrayMappingsSimilar(arrayGeneralizedMappings)) {
                for (Map map : arrayDetailedMappings) {
                    detailed.putAll(map);
                }
                Map firstElementGeneralized = (Map)arrayGeneralizedMappings.get(0);
                for (Map.Entry entry : firstElementGeneralized.entrySet()) {
                    HashSet<String> allKeys = new HashSet<String>();
                    HashSet<String> allValues = new HashSet<String>();
                    for (Map map : arrayGeneralizedMappings) {
                        for (Map.Entry e : map.entrySet()) {
                            if (!((String)e.getKey()).replaceAll("\\[\\d+\\]", "[*]").equals(((String)entry.getKey()).replaceAll("\\[\\d+\\]", "[*]"))) continue;
                            allKeys.add((String)e.getKey());
                            allValues.add((String)e.getValue());
                        }
                    }
                    String generalizedKey = JsonToJsonRecommender.generalizeVaryingArrayIndices(allKeys);
                    String string = JsonToJsonRecommender.generalizeVaryingArrayIndices(allValues);
                    generalized.put(generalizedKey, string);
                }
            } else {
                for (i = 0; i < arrayDetailedMappings.size(); ++i) {
                    detailed.putAll((Map)arrayDetailedMappings.get(i));
                    generalized.putAll((Map)arrayGeneralizedMappings.get(i));
                }
            }
        } else {
            String value = node.asText();
            String matchingInputPath = inputIndex.get(value);
            if (matchingInputPath != null && !matchingInputPath.isEmpty()) {
                detailed.put(path, matchingInputPath);
                generalized.put(path, matchingInputPath);
            }
        }
    }

    private static boolean areArrayMappingsSimilar(List<Map<String, String>> arrayMappings) {
        if (arrayMappings.size() <= 1) {
            return true;
        }
        Map<String, String> firstMapping = arrayMappings.get(0);
        Set firstKeys = firstMapping.keySet().stream().map(key -> key.replaceAll("\\[\\d+\\]", "[*]")).collect(Collectors.toSet());
        for (int i = 1; i < arrayMappings.size(); ++i) {
            Map<String, String> currentMapping = arrayMappings.get(i);
            Set currentKeys = currentMapping.keySet().stream().map(key -> key.replaceAll("\\[\\d+\\]", "[*]")).collect(Collectors.toSet());
            if (!firstKeys.equals(currentKeys)) {
                return false;
            }
            for (String generalizedKey : firstKeys) {
                String currentValue;
                String firstValue = firstMapping.entrySet().stream().filter(e -> ((String)e.getKey()).replaceAll("\\[\\d+\\]", "[*]").equals(generalizedKey)).map(e -> ((String)e.getValue()).replaceAll("\\[\\d+\\]", "[*]")).findFirst().orElse("");
                if (firstValue.equals(currentValue = currentMapping.entrySet().stream().filter(e -> ((String)e.getKey()).replaceAll("\\[\\d+\\]", "[*]").equals(generalizedKey)).map(e -> ((String)e.getValue()).replaceAll("\\[\\d+\\]", "[*]")).findFirst().orElse(""))) continue;
                return false;
            }
        }
        return true;
    }

    private static String generalizeVaryingArrayIndices(Set<String> paths) {
        if (paths.isEmpty()) {
            return "";
        }
        if (paths.size() == 1) {
            return paths.iterator().next();
        }
        List split = paths.stream().map(p -> p.split("(?<=]\\.)|(?=\\[)|\\.")).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        int max = split.stream().mapToInt(a -> ((String[])a).length).max().orElse(0);
        for (int i = 0; i < max; ++i) {
            int index = i;
            Set parts = split.stream().map(arr -> index < ((String[])arr).length ? arr[index] : "").collect(Collectors.toSet());
            if (i > 0 && sb.length() > 0 && !sb.toString().endsWith(".") && !((String)parts.iterator().next()).startsWith("[")) {
                sb.append('.');
            }
            if (parts.size() == 1) {
                sb.append((String)parts.iterator().next());
                continue;
            }
            if (parts.stream().anyMatch(p -> p.matches("\\[\\d+]"))) {
                sb.append("[*]");
                continue;
            }
            sb.append((String)parts.iterator().next());
        }
        return sb.toString();
    }

    private static Map<String, Object> getOrCreateChildMap(Map<String, Object> parent, String key) {
        Object value = parent.get(key);
        if (value == null) {
            LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
            parent.put(key, child);
            return child;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalStateException("Conflict at key '" + key + "': expected a nested object but found " + value.getClass().getSimpleName());
    }

    private static Map<String, Object> toNestedMapping(Map<String, String> flatMap) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : flatMap.entrySet()) {
            String keyPath = entry.getKey();
            if (keyPath.startsWith("$.")) {
                keyPath = keyPath.substring(2);
            }
            String[] parts = keyPath.split("\\.");
            ArrayList<String> validParts = new ArrayList<String>();
            for (String part : parts) {
                if (part.isEmpty()) continue;
                validParts.add(part);
            }
            Map<String, Object> current = result;
            for (int i = 0; i < validParts.size(); ++i) {
                boolean isLast;
                String key = (String)validParts.get(i);
                boolean bl = isLast = i == validParts.size() - 1;
                if (isLast) {
                    current.put(key, entry.getValue());
                    continue;
                }
                current = JsonToJsonRecommender.getOrCreateChildMap(current, key);
            }
        }
        return result;
    }

    static {
        StreamReadConstraints constraints = StreamReadConstraints.builder().maxNestingDepth(CommonValue.MAX_JSON_NESTING_DEPTH).maxStringLength(CommonValue.MAX_JSON_SIZE).maxNameLength(CommonValue.MAX_JSON_NAME_LENGTH).build();
        MAPPER = new ObjectMapper();
        MAPPER.getFactory().setStreamReadConstraints(constraints);
    }

    public static class MapFormatResult {
        public final Map<String, Object> detailedJsonPath;
        public final Map<String, Object> generalizedJsonPath;

        public MapFormatResult(Map<String, Object> detailedJsonPath, Map<String, Object> generalizedJsonPath) {
            this.detailedJsonPath = detailedJsonPath;
            this.generalizedJsonPath = generalizedJsonPath;
        }
    }

    public static class StringFormatResult {
        public final String detailedJsonPathString;
        public final String generalizedJsonPathString;

        public StringFormatResult(String detailedJsonPathString, String generalizedJsonPathString) {
            this.detailedJsonPathString = detailedJsonPathString;
            this.generalizedJsonPathString = generalizedJsonPathString;
        }
    }
}

