/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.searchConfiguration;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteSearchConfigurationTransportAction
extends HandledTransportAction<OpenSearchDocRequest, DeleteResponse> {
    private final ClusterService clusterService;
    private final SearchConfigurationDao searchConfigurationDao;
    private final ExperimentDao experimentDao;

    @Inject
    public DeleteSearchConfigurationTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, SearchConfigurationDao searchConfigurationDao, ExperimentDao experimentDao) {
        super("cluster:admin/opensearch/search_relevance/search_configuration/delete", transportService, actionFilters, OpenSearchDocRequest::new);
        this.clusterService = clusterService;
        this.searchConfigurationDao = searchConfigurationDao;
        this.experimentDao = experimentDao;
    }

    protected void doExecute(Task task, OpenSearchDocRequest request, final ActionListener<DeleteResponse> listener) {
        try {
            final String searchConfigurationId = request.getId();
            if (searchConfigurationId == null || searchConfigurationId.trim().isEmpty()) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("searchConfigurationId cannot be null or empty", RestStatus.BAD_REQUEST)));
                return;
            }
            this.experimentDao.getExperimentByFieldId(searchConfigurationId, "searchConfigurationList", 3, new ActionListener<SearchResponse>(this){
                final /* synthetic */ DeleteSearchConfigurationTransportAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse experiments) {
                    if (experiments != null && experiments.getHits().getTotalHits().value() > 0L) {
                        List<String> ids = Arrays.stream(experiments.getHits().getHits()).map(SearchHit::getId).toList();
                        listener.onFailure((Exception)((Object)new SearchRelevanceException(String.format(Locale.ROOT, "search configuration cannot be deleted as it is currently used by experiments with ids %s", String.join((CharSequence)", ", ids)), RestStatus.CONFLICT)));
                        return;
                    }
                    this.this$0.searchConfigurationDao.deleteSearchConfiguration(searchConfigurationId, (ActionListener<DeleteResponse>)listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

