/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolMapper;
import org.eclipse.xtext.ide.server.symbol.IDocumentSymbolService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
@Beta
public class HierarchicalDocumentSymbolService
implements IDocumentSymbolService {
    @Inject
    private DocumentSymbolMapper symbolMapper;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public static boolean isValid(DocumentSymbol symbol) {
        if (symbol != null) {
            Field[] fieldArray = DocumentSymbol.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Annotation[] annotationArray = field.getAnnotations();
                int n3 = annotationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation annotation = annotationArray[n4];
                    if (NonNull.class == annotation.annotationType()) {
                        field.setAccessible(true);
                        try {
                            Object o = field.get(symbol);
                            if (o == null) {
                                return false;
                            }
                        }
                        catch (Throwable e) {
                            throw Exceptions.sneakyThrow((Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<DocumentSymbol> getSymbols(Document document, XtextResource resource, DocumentSymbolParams params, CancelIndicator cancelIndicator) {
        return this.getSymbols(resource, cancelIndicator);
    }

    public List<DocumentSymbol> getSymbols(XtextResource resource, CancelIndicator cancelIndicator) {
        HashMap<EObject, DocumentSymbol> allSymbols = new HashMap<EObject, DocumentSymbol>();
        ArrayList<DocumentSymbol> rootSymbols = new ArrayList<DocumentSymbol>();
        Iterator<Object> itr = this.getAllContents((Resource)resource);
        while (itr.hasNext()) {
            EObject object;
            DocumentSymbol symbol;
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            Optional<EObject> next = this.toEObject(itr.next());
            if (!next.isPresent() || !HierarchicalDocumentSymbolService.isValid(symbol = this.symbolMapper.toDocumentSymbol(object = (EObject)next.get()))) continue;
            allSymbols.put(object, symbol);
            EObject parent = object.eContainer();
            if (parent == null) {
                rootSymbols.add(symbol);
                continue;
            }
            DocumentSymbol parentSymbol = (DocumentSymbol)allSymbols.get(parent);
            while (parentSymbol == null && parent != null) {
                parent = parent.eContainer();
                parentSymbol = (DocumentSymbol)allSymbols.get(parent);
            }
            if (parentSymbol == null) {
                rootSymbols.add(symbol);
                continue;
            }
            parentSymbol.getChildren().add(symbol);
        }
        return rootSymbols;
    }

    protected Iterator<Object> getAllContents(Resource resource) {
        return EcoreUtil.getAllProperContents((Resource)resource, (boolean)true);
    }

    protected Optional<EObject> toEObject(Object object) {
        if (object instanceof EObject) {
            return Optional.of((Object)((EObject)object));
        }
        return Optional.absent();
    }
}

