/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.logstash.snmp.SnmpUtils;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTestTrapSender {
    private final Snmp snmp;

    public SnmpTestTrapSender(int port) {
        this.snmp = SnmpTestTrapSender.createSnmpSession(port);
    }

    public void sendTrapV1(String address, String community, Map<String, Object> bindings) {
        CommunityTarget target = new CommunityTarget(GenericAddress.parse((String)address), new OctetString(community));
        PDUv1 pdu = new PDUv1();
        this.addVariableBindings((PDU)pdu, bindings);
        this.send((PDU)pdu, (Target<Address>)target);
    }

    public void sendTrapV2c(String address, String community, Map<String, Object> bindings) {
        PDU pdu = new PDU();
        pdu.setType(-89);
        this.addVariableBindings(pdu, bindings);
        CommunityTarget target = new CommunityTarget(GenericAddress.parse((String)address), new OctetString(community));
        target.setVersion(1);
        target.setSecurityModel(2);
        this.send(pdu, (Target<Address>)target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTrapV3(String address, String securityName, String authProtocol, String authPassphrase, String privProtocol, String privPassphrase, String securityLevel, Map<String, Object> bindings) {
        try {
            USM usm = new USM();
            usm.addUser(new UsmUser(new OctetString(securityName), SnmpUtils.parseAuthProtocol(authProtocol), SnmpUtils.parseNullableOctetString(authPassphrase), SnmpUtils.parsePrivProtocol(privProtocol), SnmpUtils.parseNullableOctetString(privPassphrase)));
            this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3(usm));
            ScopedPDU pdu = new ScopedPDU();
            pdu.setType(-89);
            this.addVariableBindings((PDU)pdu, bindings);
            UserTarget target = new UserTarget();
            target.setAddress(GenericAddress.parse((String)address));
            target.setSecurityLevel(SnmpUtils.parseSecurityLevel(securityLevel));
            target.setSecurityName(new OctetString(securityName));
            target.setVersion(3);
            target.setSecurityModel(3);
            this.send((PDU)pdu, (Target<Address>)target);
        }
        finally {
            this.cleanupSnmpMessageDispatcherMPv3Model();
        }
    }

    private void cleanupSnmpMessageDispatcherMPv3Model() {
        MessageDispatcher messageDispatcher = this.snmp.getMessageDispatcher();
        MessageProcessingModel existingMPv3Model = messageDispatcher.getMessageProcessingModel(3);
        if (existingMPv3Model != null) {
            messageDispatcher.removeMessageProcessingModel(existingMPv3Model);
        }
    }

    private void send(PDU pdu, Target<Address> target) {
        try {
            ResponseEvent response = this.snmp.send(pdu, target);
            if (response != null && response.getError() != null) {
                throw new RuntimeException(response.getError());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addVariableBindings(PDU pdu, Map<String, Object> bindings) {
        for (Map.Entry<String, Object> binding : bindings.entrySet()) {
            Object variable = binding.getValue() instanceof Variable ? (Variable)binding.getValue() : new OctetString(String.valueOf(binding.getValue()));
            pdu.add(new VariableBinding(new OID(binding.getKey()), variable));
        }
    }

    private static Snmp createSnmpSession(int port) {
        Snmp snmp = new Snmp();
        snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
        snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        try {
            snmp.addTransportMapping((TransportMapping)new DefaultTcpTransportMapping(new TcpAddress(port)));
            snmp.addTransportMapping((TransportMapping)new DefaultUdpTransportMapping(new UdpAddress(port), true));
            snmp.listen();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return snmp;
    }

    public void close() {
        try {
            CompletableFuture.runAsync(() -> {
                try {
                    this.snmp.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

