/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSLImportSchema
extends StyleElement {
    public boolean isDeclaration() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String namespace = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("schema-location")) continue;
            if (f.equals("namespace")) {
                namespace = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if ("".equals(namespace)) {
            this.compileError("The zero-length string is not a valid namespace URI. For a schema with no namespace, omit the namespace attribute");
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkTopLevel("XTSE0010", false);
    }

    public void index(ComponentDeclaration decl, StylesheetPackage top) throws XPathException {
    }

    public void readSchema() throws XPathException {
        try {
            NodeInfo child;
            String schemaLoc = Whitespace.trim(this.getAttributeValue("", "schema-location"));
            String namespace = Whitespace.trim(this.getAttributeValue("", "namespace"));
            namespace = namespace == null ? "" : namespace.trim();
            Configuration config = this.getConfiguration();
            try {
                config.checkLicensedFeature(2, "xsl:import-schema");
            }
            catch (LicenseException err) {
                XPathException xe = new XPathException(err);
                xe.setErrorCode("XTSE1650");
                xe.setLocator(this);
                throw xe;
            }
            AxisIterator kids = this.iterateAxis((byte)3);
            NodeInfo inlineSchema = null;
            while ((child = kids.next()) != null) {
                if (inlineSchema != null) {
                    this.compileError(this.getDisplayName() + " must not have more than one child element");
                }
                if ((inlineSchema = child).getFingerprint() != 617) {
                    this.compileError("The only child element permitted for " + this.getDisplayName() + " is xs:schema");
                }
                if (schemaLoc != null) {
                    this.compileError("The schema-location attribute must be absent if an inline schema is present", "XTSE0215");
                }
                namespace = config.readInlineSchema(inlineSchema, namespace, this.getCompilation().getCompilerInfo().getErrorListener());
                this.getContainingPackage().addImportedSchema(namespace);
            }
            if (inlineSchema != null) {
                return;
            }
            if (!config.isSchemaAvailable(namespace)) {
                if (schemaLoc == null) {
                    this.compileWarning("No schema for this namespace is known, and no schema-location was supplied, so no schema has been imported", "SXWN9006");
                    return;
                }
                PipelineConfiguration pipe = config.makePipelineConfiguration();
                namespace = config.readSchema(pipe, this.getBaseURI(), schemaLoc, namespace);
            }
            this.getContainingPackage().addImportedSchema(namespace);
        }
        catch (SchemaException err) {
            this.compileError(err.getMessage(), "XTSE0220");
        }
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
    }
}

