/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Mayotte
* Equirectangular projection

* @author CCM Benchmark Group
* @source http://commons.wikimedia.org/wiki/File:Mayotte_blank_map.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_06 : {
					width : 50.342926,
					height : 64.002068,
					getCoords : function (lat, lon) {
						var xfactor = 193.03305111901;
						var xoffset = -8694.0721391537;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -180.02792269821;
						var yoffset = -2277.4739363656;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-976" : "m 47.35,19.46 c -0.03,0.13 -0.27,-0.04 -0.24,0.15 -0.18,0.13 -0.24,0.34 -0.37,0.48 0.02,0.18 -0.17,0.28 -0.2,0.45 -0.21,0.03 -0.27,0.23 -0.31,0.38 -0.12,0.16 -0.26,0.34 -0.46,0.41 -0.13,0.08 -0.33,0.09 -0.31,0.29 -0.17,0.16 -0.23,0.4 -0.47,0.5 -0.14,0.07 -0.27,0.15 -0.38,0.21 -0.06,0.15 -0.29,0.16 -0.32,0.35 -0.16,0.04 -0.17,0.23 -0.35,0.26 -0.02,0.11 -0.21,0.2 -0.28,0.17 -0.22,0.11 -0.39,-0.24 -0.23,-0.39 0.14,-0.08 -0.1,-0.11 -0.07,-0.23 -0.13,0.07 -0.34,0.03 -0.25,0.24 0.04,0.22 -0.18,0.31 -0.2,0.51 -0.07,0.04 -0.18,0.06 -0.13,0.19 -0.07,0.17 -0.3,0.28 -0.43,0.1 -0.09,-0.08 -0.34,5.7e-4 -0.33,-0.2 -0.26,-0.03 -0.43,0.06 -0.63,0.18 0.04,0.18 -0.26,0.35 -0.03,0.51 0.22,0.08 0.49,0.07 0.68,0.2 0.19,0.03 0.37,0.04 0.48,0.2 0.17,0.1 -0.11,0.26 0.05,0.37 0.03,0.13 0.25,0.05 0.25,0.21 0.09,4.1e-4 0.26,-0.18 0.38,-0.01 0.13,0.08 0.38,-0.02 0.49,0.14 0.19,4.4e-4 0.27,0.23 0.43,0.27 0.15,0.18 0.34,0.28 0.54,0.34 0.15,0.16 0.13,0.34 0.31,0.46 0.11,0.11 0.02,0.35 0.11,0.5 -0.09,0.3 0.28,0.3 0.5,0.43 0.2,0.03 0.16,0.31 0.3,0.44 0.09,0.1 0.13,0.21 0.05,0.33 0.13,0.04 -0.01,0.22 0.13,0.26 0.15,0.2 -0.01,0.39 0.03,0.64 -0.08,0.26 0.17,0.33 0.21,0.56 0.22,-0.02 0.35,0.14 0.53,0.06 0.17,-0.04 0.13,0.2 0.31,0.17 0.07,0.09 0.06,0.2 0.21,0.24 -0.02,0.19 0.24,0.25 0.18,0.44 0.17,0.05 0.35,-0.1 0.47,-0.14 0.02,-0.21 -0.13,-0.37 -0.25,-0.52 -0.09,-0.16 -0.14,-0.35 -0.24,-0.46 -0.1,-0.11 -0.1,-0.28 -0.06,-0.37 0.11,-0.14 0.08,-0.36 0.08,-0.55 -0.13,-0.01 0.08,-0.1 -0.06,-0.13 0.1,-0.14 0.04,-0.32 0.11,-0.45 0.01,-0.21 0.26,-0.27 0.3,-0.47 0.06,-0.15 0.33,-0.34 0.52,-0.19 0.12,-0.14 0.43,0.02 0.58,-0.11 0.19,-0.03 0.33,-0.18 0.47,-0.31 0.12,-0.17 0.34,-0.3 0.33,-0.53 -0.06,-0.1 -0.14,-0.11 -0.05,-0.21 -0.01,-0.2 -0.18,-0.32 -0.23,-0.52 -0.23,-0.06 -0.28,-0.43 -0.12,-0.56 0.18,-0.13 0.27,-0.32 0.3,-0.51 0.06,-0.11 0.25,-0.12 0.34,-0.1 0.04,0.13 0.28,0.34 0.27,0.07 0.11,-0.14 -0.08,-0.2 -0.02,-0.36 -0.14,0.03 -0.14,-0.18 -0.27,-0.23 0.01,-0.25 -0.01,-0.49 -0.11,-0.66 0.02,-0.21 -0.28,-0.24 -0.42,-0.29 -0.23,0.01 -0.38,-0.16 -0.32,-0.39 0.09,-0.05 0.02,-0.23 0.1,-0.26 -0.08,-0.07 0.1,-0.28 -0.05,-0.36 0.02,-0.19 -0.1,-0.27 -0.12,-0.45 -0.13,0.01 -0.04,-0.11 -0.19,-0.13 -0.02,-0.15 -0.24,-0.14 -0.26,-0.29 -0.18,-0.13 -0.25,-0.32 -0.43,-0.46 -0.07,-0.03 -0.12,-0.05 -0.14,-0.14 -0.28,-0.05 -0.11,-0.37 -0.3,-0.52 -0.07,-0.16 -0.21,-0.25 -0.43,-0.23 z m -25.87,43.4 c 0.03,0.18 -0.25,0.07 -0.36,0.1 -0.08,0.02 -0.19,0.12 -0.25,0 -0.14,-0.02 -0.35,0.05 -0.46,-0.04 0.04,-0.19 -0.21,-0.1 -0.33,-0.12 -0.13,0.03 0.02,0.2 -0.11,0.24 -0.13,0.09 -0.19,-0.1 -0.31,-0.1 0,-0.1 -0,-0.2 -0.1,-0.26 0,-0.11 -0.09,-0.16 -0.07,-0.27 -0.1,-0.04 -0.09,-0.13 -0.12,-0.21 -0.1,-0.05 -0.09,-0.16 -0.19,-0.23 -0.03,-0.09 0.03,-0.2 -0.06,-0.26 0.04,-0.13 -0.07,-0.21 -0.15,-0.27 -0.01,-0.07 -0.05,-0.15 -0.16,-0.14 -0.12,-0.01 -0.29,0.04 -0.38,-0.05 -0.15,-0.03 -0.27,0.03 -0.36,0.14 -0.11,0.09 -0.2,0.21 -0.2,0.35 -0.07,0.06 -0.14,0.08 -0.23,0.12 -0.07,-0.03 -0.12,0.07 -0.17,0.06 -0.12,0.08 -0.25,0.09 -0.41,0.08 -0.17,-0.06 -0.01,0.21 -0.19,0.15 -0.06,-0.02 -0.09,0.11 -0.15,9e-4 -0.02,-0.12 -0.09,-0.2 -0.08,-0.33 -0.08,-0.05 -0.02,-0.16 -0.1,-0.21 0.03,-0.09 -0.03,-0.16 -0.05,-0.23 0.01,-0.11 -0.19,-0.23 -0.08,-0.34 0.11,-0.06 0.16,-0.17 0.13,-0.29 0.12,-0.06 0.02,-0.23 0.05,-0.33 -0.12,-0.06 -0.13,-0.19 -0.04,-0.28 0.01,-0.15 -0.18,-0.16 -0.3,-0.14 -0.08,-0.02 -0.19,0.01 -0.23,0.04 -0.06,-0.06 -0.21,-0.06 -0.18,-0.18 -0.08,-0.06 -0.17,-0.13 -0.25,-0.13 -0.07,-0.07 -0.22,0.01 -0.27,-0.08 -0.15,0.02 -0.23,-0.06 -0.35,-0.11 -0.09,0 -0.19,0.01 -0.25,0.05 -0.1,-0.01 -0.14,0.06 -0.23,0.08 -0.07,0.08 -0.01,0.2 -0.14,0.23 0.02,0.13 -0.12,0.07 -0.16,0.16 -0.09,0.04 -0.03,0.14 -0.13,0.16 -0.08,0.08 -0.13,0.15 -0.15,0.26 -0.03,0.07 -0.07,0.15 -0.05,0.24 -0.09,0.06 -0.12,0.15 -0.16,0.24 0.01,0.17 5.3e-4,0.34 0.01,0.51 0.03,0.1 -0.16,0.11 -0.1,0.24 -0,0.15 -0.21,0.07 -0.32,0.08 -0.13,-0.07 -0.13,-0.21 -0.12,-0.34 -0.12,-0.04 0.01,-0.23 -0.14,-0.26 -0.13,-0.06 -0.11,-0.21 -0.22,-0.24 -0.2,0.05 -0.09,-0.17 -0.11,-0.27 0.02,-0.1 -0.13,-0.2 0.02,-0.27 0.11,-0.07 0.08,-0.18 0.2,-0.23 -0.02,-0.09 0.13,-0.14 0.12,-0.22 0.06,-0.05 0.01,-0.16 0.09,-0.2 -0.04,-0.13 0.09,-0.21 0.05,-0.34 -0.01,-0.11 -0.17,-0.14 -0.17,-0.25 -0.01,-0.12 0.06,-0.27 -0.03,-0.37 -0.03,-0.1 -0.1,-0.16 -0.06,-0.28 -0.03,-0.09 -0.12,-0.16 -0.12,-0.27 0.07,-0.05 0.05,-0.13 0.08,-0.2 0.11,-0.03 0.07,-0.15 0.17,-0.2 0.02,-0.15 0.2,-0.14 0.28,-0.26 0.11,-0.05 0.17,-0.22 0.09,-0.29 -0.06,-0.08 0.2,-0.13 0.14,-0.25 0.14,-0.06 0.01,-0.22 -0.1,-0.23 -0.06,-0.12 0.06,-0.29 -0.06,-0.39 -0.04,-0.09 0.11,-0.15 0.05,-0.26 -0,-0.08 -8.9e-4,-0.12 -0.05,-0.17 0.02,-0.08 -0.03,-0.15 -0.13,-0.11 -0.07,-0.08 -0.18,-0.02 -0.23,-0.1 -0.16,0.06 -0.11,-0.18 -0.27,-0.15 -0.03,-0.06 -0.11,-0.04 -0.17,-0.1 -0.09,-0.02 -0.16,0.08 -0.22,0.08 -0.09,0.1 -0.2,0.18 -0.3,0.28 -0.11,0.06 0.11,0.13 -0.03,0.17 -0.1,0.06 -0.1,0.15 -0.16,0.22 -0,0.08 0.05,0.26 -0.11,0.2 -0.09,0.1 -0.23,0.03 -0.35,0.06 -0.08,0.11 -0.28,-0.02 -0.38,0.09 -0.12,-0.05 -0.19,0.13 -0.29,0.12 -0.07,0.08 -0.13,0.12 -0.21,0.15 -0.06,0.06 -0.16,-0.01 -0.2,0.08 -0.11,-0.01 -0.25,0.02 -0.33,-0.05 -0.07,-0.05 -0.14,-0.05 -0.21,-0.07 0.01,-0.09 -0.06,-0.09 -0.07,-0.17 -0.07,-0.09 -0.15,-0.11 -0.25,-0.13 5.7e-4,-0.1 -0.14,-0.18 -0.22,-0.2 -0.06,-0.09 -0.19,-0.09 -0.25,-0.18 -0.07,-0.06 -0.14,-0.19 -0.27,-0.15 -0.08,0.01 -0.13,-0.09 -0.23,-0.05 -0.14,-0.03 -0.25,0.02 -0.36,0.09 -0.05,0.08 -0.12,0.1 -0.2,0.13 -0.01,0.03 -0.1,0.02 -0.13,0.08 -0.14,0.02 -0.33,-0.02 -0.34,-0.18 -0.01,-0.13 -0.01,-0.29 0.15,-0.28 0.06,-0.09 0.15,-0.16 0.27,-0.15 0.05,-0.06 0.1,-0.04 0.15,-0.09 0.11,0 0.11,-0.13 0.23,-0.11 0.06,-0.11 0.18,-0.13 0.26,-0.21 0.11,-0.08 0.16,-0.19 0.29,-0.24 0.05,0.01 0.08,-0.1 0.16,-0.02 0.12,0.09 0.27,-0.01 0.29,-0.14 0.04,-0.05 0.14,-0.03 0.16,-0.09 0.15,0.03 0.25,-0.07 0.37,-0.11 0.14,0.04 0.2,-0.09 0.33,-0.1 0.12,0.03 0.2,-0.02 0.28,-0.06 0,-0.17 0.22,-0.12 0.29,-0.24 0.01,-0.07 0.1,-0.1 0.11,-0.18 0.09,-0.05 0.08,-0.14 0.14,-0.19 0.02,-0.11 0.1,-0.17 0.16,-0.26 0.01,-0.07 0.05,-0.1 0.07,-0.15 0.12,0 0.12,-0.12 0.24,-0.12 0.05,-0.11 0.23,-0.07 0.24,-0.22 0.06,-0.03 0.03,-0.13 0.1,-0.14 -0.03,-0.13 0.07,-0.2 0.05,-0.32 0.03,-0.1 0.17,-0.13 0.09,-0.25 -0.12,-0.04 -0.11,-0.19 -0.03,-0.25 -0.01,-0.25 -7.1e-4,-0.5 -0,-0.75 0.08,-0.03 0.15,-0.11 0.21,-0.13 0.17,-0.02 0.18,-0.19 0.16,-0.32 -0.02,-0.13 -0,-0.27 0.06,-0.37 0.03,-0.13 -0.12,-0.16 -0.12,-0.26 -0.09,-0.08 0.01,-0.21 -0.13,-0.27 -0.07,-0.07 0.03,-0.19 -0.08,-0.23 -0.06,-0.1 -0.16,-0.11 -0.26,-0.14 -0.09,-0.09 -0.27,0.04 -0.35,-0.08 -0.1,-0 -0.22,0.02 -0.29,-0.05 -0.11,0.02 -0.21,-0.13 -0.3,-0 -0.14,0.06 -0.11,0.25 -0.27,0.25 -0.12,-0.03 -0.16,0.07 -0.27,0.05 -0.12,0.08 -0.26,0.1 -0.36,0.23 -0.06,0.12 -0.23,0.02 -0.3,0.11 -0.18,-0 -0.37,4.1e-4 -0.55,-0 -0.02,-0.11 0.01,-0.21 0.11,-0.28 -0.01,-0.13 0.17,-0.1 0.22,-0.2 0.14,-0.08 0.18,-0.19 0.16,-0.35 -0.01,-0.14 -0.17,-0.12 -0.27,-0.13 -0.06,-0.08 -0.17,-0.16 -0.19,-0.24 -0.1,-0.14 -0.28,-0.18 -0.45,-0.14 -0.08,-0.01 -0.26,0.04 -0.22,-0.09 -0.08,-0.02 -0.04,-0.12 -0.12,-0.15 -0.11,-0.06 -0.13,-0.18 -0.03,-0.26 0.02,-0.12 -0.03,-0.3 -0.21,-0.25 -0.11,0.02 -0.05,-0.09 -0.11,-0.1 0,-0.12 -0.21,-0.17 -0.07,-0.29 -0.01,-0.12 0.05,-0.28 -0.04,-0.37 -0.07,-0.1 -0.24,-0.1 -0.24,-0.23 -0.06,-0.05 -0.02,-0.16 -0.09,-0.2 -0.02,-0.1 0.01,-0.19 0.05,-0.27 0.03,-0.11 -0.07,-0.16 -0.06,-0.27 -0.06,-0.05 -0.05,-0.11 -0.11,-0.17 -0.04,-0.05 -0.05,-0.14 -0.07,-0.2 -0.08,-0.07 0.02,-0.28 -0.05,-0.34 -0.06,-0.08 -0.14,-0.04 -0.19,-0.13 -0.06,-0.04 -0.1,-0.02 -0.14,-0.07 -0.11,-0.02 -0.2,-0.12 -0.34,-0.11 -0.06,-0.11 -0.25,0.02 -0.31,-0.09 -0.08,0.01 -0.17,-0.01 -0.22,-0.05 -0.12,-0.02 -0.05,-0.18 -0.05,-0.24 0.09,-0.06 0.03,-0.24 -0,-0.3 0.07,-0.07 0.16,-0.08 0.22,-0.15 0.11,-0.03 0.23,0.02 0.3,-0.07 0.09,0.02 0.21,0.01 0.27,-0.04 0.16,-0.03 0.37,0.05 0.48,-0.05 0.14,-0.01 0.26,-0 0.36,0.06 0.15,-0.02 0.3,-0 0.44,-0.01 0.18,3e-5 0.37,0 0.55,0 0.01,-0.05 0.08,-0.09 0.07,-0.13 0.15,-0.05 0.32,0 0.48,-0.02 0.41,0 0.81,4e-4 1.22,4e-4 0.07,0.12 0.27,0.01 0.39,0.05 0.07,-0.09 0.15,-0.02 0.23,0.01 0.14,-0.02 0.29,-0 0.43,-0.01 0.12,0 0.24,-0.03 0.3,0.08 0.1,0.11 0.12,0.26 0.09,0.41 0.01,0.13 0.1,0.2 0.15,0.33 0.07,0.07 0.28,-0.02 0.24,0.13 0.1,0.05 0.13,0.15 0.16,0.24 -0.05,0.14 0.09,0.2 0.05,0.34 0.01,0.09 10e-4,0.16 -0.06,0.23 0.02,0.05 -0.1,0.07 -0.01,0.11 0.07,0.09 -0.07,0.15 -0.04,0.24 -0.03,0.08 -0.13,0.1 -0.12,0.19 -0.12,0.11 0.02,0.25 0.01,0.36 -0.01,0.1 0.14,0.2 -0.01,0.28 0.04,0.11 -0.09,0.16 -0.05,0.28 -0.04,0.12 0.1,0.21 0.09,0.29 -0.07,0.02 0.06,0.11 0.04,0.15 0.11,0.08 0.15,0.2 0.14,0.33 0.06,0.09 0.24,0.07 0.22,0.22 0.06,0.01 0.02,0.13 0.13,0.1 0.11,-0.02 0.22,-0.01 0.19,0.12 -0.03,0.09 -0.12,0.2 0.02,0.27 0.1,0.03 0.23,-0.02 0.3,0.06 0.12,0.02 0.17,-0.1 0.3,-0.05 0.15,0.05 0.26,-0.09 0.39,-0.04 0.05,0.08 0.29,-0.02 0.23,0.15 -0.03,0.12 0.03,0.27 0.19,0.24 0.13,0 0.25,-0.01 0.33,-0.1 0.01,0.09 0.05,0.22 0.17,0.21 -0.01,0.15 0.19,0.16 0.31,0.14 0.18,-0.04 0.15,0.15 0.26,0.2 0.11,0.02 0.22,-0.02 0.3,0.06 0.13,-0.04 0.19,0.08 0.32,0.04 0.12,-4.8e-4 0.25,0 0.37,5.7e-4 -0.02,0.13 0.14,0.19 0.11,0.32 0.1,0.07 0.02,0.2 0.15,0.24 0.08,0.09 0.19,0.18 0.28,0.27 0.06,0.09 0.19,0.05 0.26,0.11 0.13,-0.02 0.18,0.12 0.29,0.14 0.06,0.04 0.15,10e-4 0.2,0.08 0.14,0 0.29,-0.04 0.42,0.01 0.05,0.06 0.17,0.01 0.21,0.08 0.15,0.03 0.22,-0.08 0.37,-0.05 0.11,-0.01 0.22,0.03 0.27,-0.06 0.1,-0.1 0.32,0.04 0.42,-0.09 0.11,-0.02 0.3,0.05 0.35,-0.04 0.07,-0.09 0.18,-0.05 0.26,-0 0.12,0.01 0.15,-0.11 0.26,-0.13 0.07,-0.04 0.03,-0.17 0.15,-0.13 0.1,-0.09 0.11,-0.2 0.15,-0.31 0.09,-0.07 0.16,-0.13 0.26,-0.17 0.11,-0.09 0.17,-0.2 0.13,-0.34 0.01,-0.19 0,-0.38 0,-0.57 -0.07,-0.02 -0.11,-0.08 -0.19,-0.05 -0.06,-0.05 -0.02,-0.21 -0.01,-0.24 0.14,-0 0.18,-0.15 0.24,-0.23 0.02,-0.11 0.01,-0.24 -0.05,-0.33 -0.03,-0.08 0.02,-0.19 0.03,-0.23 -0.11,-0.11 0.06,-0.18 0.02,-0.3 0.04,-0.11 -0.04,-0.23 -0.15,-0.23 -0.05,-0.13 -0.27,-0.03 -0.22,-0.19 0,-0.21 -0,-0.42 0,-0.63 -0.03,-0.13 -0.09,-0.25 -0.18,-0.35 -0.1,-0.12 -0.25,-0.14 -0.34,-0.27 -0.11,-0.03 -0.19,-0.09 -0.2,-0.19 -0.1,-0.04 -0.16,-0.17 -0.2,-0.25 -0.06,-0.09 -0.09,-0.25 -0.01,-0.37 0.07,-0.1 -0.02,-0.27 -0.17,-0.23 -0.15,0.03 -0.28,-0.01 -0.41,-0.06 -0.06,-0.08 -0.24,-0.17 -0.14,-0.28 0.08,-0.09 0.01,-0.26 0.03,-0.38 -0.03,-0.11 0.06,-0.28 -0.05,-0.34 0.01,-0.07 -0.02,-0.14 -0.05,-0.18 -0.01,-0.12 -0.13,-0.22 -0.12,-0.33 -0.1,-0.1 0.03,-0.27 -0.09,-0.35 0.01,-0.08 -0.04,-0.18 -0.11,-0.23 -0.05,0.01 -0.07,-0.06 -0.15,-0.05 -0.03,-0.06 -0.11,-0.12 -0.14,-0.04 -0.08,-0.11 -0.25,-0.01 -0.38,-0.06 -0.1,-0.04 -0.22,-0.09 -0.19,-0.22 -0.11,-0.05 0.01,-0.24 -0.15,-0.27 -0.02,-0.11 -0.12,-0.21 -0.25,-0.2 -0.15,0.01 -0.12,-0.17 -0.24,-0.22 -0.1,-0.08 -0.18,-0.19 -0.28,-0.26 -0.14,-0.04 -0.29,8.6e-4 -0.44,-0.01 -0.07,0 -0.14,-0.02 -0.14,0.05 -0.1,-0.02 -0.14,-0.15 -0.18,-0.19 -0.06,-0.09 -0.07,-0.21 -0.17,-0.25 -0.07,-0 -0.12,-0.07 -0.18,-0.07 -0.08,-0.06 -0.12,-0.15 -0.13,-0.23 -0.1,-0.06 -0.15,-0.2 -0.29,-0.21 -0.07,0.01 -0.14,0.11 -0.12,-0.02 -0,-0.08 -0.09,-0.12 -0.06,-0.22 -0.07,-0.05 -0.03,-0.17 -0.13,-0.22 -0.01,-0.09 -0.16,-0.13 -0.13,-0.24 -0.08,-0.04 -0.08,-0.15 -0.17,-0.18 -0.1,-0.09 -0.22,-0.21 -0.21,-0.35 -0.13,-0.08 -0.11,-0.23 -0.1,-0.35 0.03,-0.14 -0.13,-0.18 -0.11,-0.32 -0.01,-0.1 -0.06,-0.19 -0.15,-0.26 -0.09,-0.07 -0.08,-0.2 -0.21,-0.24 -0.1,-0.04 -0.17,0.02 -0.24,0.05 -0.06,-0.04 -0.09,-0.05 -0.15,-0.08 -0.06,-0.03 -0.18,-0.03 -0.23,-0.11 -0.04,-0.04 -0.16,0.02 -0.17,-0.07 -0.08,0.11 -0.27,0 -0.35,0.1 -0.15,-0.03 -0.36,0.06 -0.43,-0.07 -0.14,-0.07 0.02,-0.24 -0.12,-0.31 -0.07,-0.03 -0.16,-0.01 -0.2,-0.07 -0.11,0.01 -0.25,0.01 -0.33,-0.04 -0.08,-0.01 -0.04,-0.11 -0.11,-0.14 0.01,-0.1 -0.16,-0.12 -0.11,-0.24 -0.07,-0.07 -0.17,-0.14 -0.19,-0.23 -0.1,-0.08 -0.11,-0.19 -0.23,-0.26 -0.1,-0.06 -0.07,-0.21 -0.23,-0.2 -0.08,-0.11 -0.19,-0.2 -0.31,-0.24 -0.1,0.01 -0.15,-0.08 -0.26,-0.05 -0.08,-0.07 -0.15,-0.17 -0.18,-0.26 0.07,-0.13 0.22,-0.14 0.31,-0.25 -0.02,-0.12 0.21,-0.14 0.26,-0.03 0.1,0.05 0.27,0.07 0.35,7.8e-4 0.08,-0.03 0.25,0.01 0.27,-0.11 0.07,-0.01 0.05,-0.12 0.09,-0.14 0.03,-0.14 0.21,-0.14 0.27,-0.24 -0.01,-0.11 0.17,-0.12 0.16,-0.24 0.01,-0.08 0.08,-0.11 0.06,-0.21 0.06,-0.08 0.11,-0.18 0.16,-0.27 -0.02,-0.08 0.04,-0.12 0.1,-0.11 0.08,-0.1 0.21,0.01 0.28,0.04 0.09,0.11 0.23,0.12 0.34,0.19 0.08,-0.01 0.19,-0 0.24,-0.06 0.15,0.01 0.24,-0.15 0.4,-0.1 0.11,0.01 0.2,0.11 0.31,0.02 0.01,-0.06 0.1,0.09 0.11,-0.02 0.15,-0.02 0.32,0.03 0.47,-0.02 0.05,-0.04 0.12,-0.05 0.17,-0.08 0.15,0.03 0.29,-0.11 0.32,-0.23 0.08,-0.06 0.04,-0.12 0.11,-0.17 0.03,-0.12 -0.17,-0.15 -0.12,-0.28 -0.05,-0.09 -0.17,-0.08 -0.23,-0.16 -0.07,-0.02 -0.13,0.01 -0.17,-0.06 -0.1,10e-4 -0.15,-0.14 -0.23,-0.12 -0.05,-0.06 -0.18,-0.02 -0.21,-0.09 -0.22,0 -0.43,0 -0.65,0 -0.01,-0.1 -0.18,-0.01 -0.21,-0.1 -0.15,0.01 -0.31,0.03 -0.41,-0.09 -0.14,-0.02 -0.31,-0.04 -0.41,0.05 -0.12,0.02 -0.16,-0.17 -0.29,-0.1 -0.12,0.02 -0.05,-0.12 -0.15,-0.13 -0.06,-0.11 -0.06,-0.27 -0.01,-0.37 0.06,-0.06 -0,-0.19 0.08,-0.25 -0.03,-0.09 0.07,-0.12 0.06,-0.19 0.09,-0.08 0.1,-0.19 0.11,-0.31 0.11,-0.07 -0.03,-0.26 0.1,-0.34 0.14,-0.07 -0.03,-0.28 0.1,-0.32 0,-0.12 0.06,-0.19 0.12,-0.29 0.03,-0.14 -0.08,-0.2 -0.18,-0.29 -0.1,-0.04 0.07,-0.11 0.01,-0.2 0.07,-0.04 0.05,-0.17 0.17,-0.12 0.13,0.04 0.21,-0.06 0.23,-0.16 0.1,-0.03 0.07,-0.13 0.13,-0.17 -8.9e-4,-0.08 0.08,-0.1 0.05,-0.2 0.05,-0.15 -0.09,-0.26 -0.05,-0.4 0.01,-0.12 -0.06,-0.21 -0.15,-0.29 0.01,-0.1 -0.14,-0.11 -0.12,-0.23 -0.09,-0 -0.03,-0.15 -0.14,-0.11 -0.1,-0.12 -0.2,0.09 -0.33,-0 -0.03,-0.07 0.01,-0.18 -0.07,-0.23 -0.06,-0.11 -0.12,-0.25 -0.26,-0.27 0,-0.12 -0.17,-0.13 -0.11,-0.27 -0.02,-0.11 0.09,-0.17 0.05,-0.29 5.8e-4,-0.42 4.4e-4,-0.85 6.2e-4,-1.27 0.09,0.01 0.03,-0.13 0.13,-0.14 0.08,-0.12 0.24,-0.12 0.33,-0.21 0.07,0.04 0.11,-0.1 0.16,0 0.16,0.01 0.33,-0.01 0.49,0.01 0.18,-0.02 0.15,-0.26 0.33,-0.26 0.14,0.02 0.17,-0.21 0.02,-0.26 -0.06,-0.12 -0.2,-0.1 -0.3,-0.03 -0.09,-0.03 -0.14,0.11 -0.22,0 -0.13,-0.01 -0.3,-0.03 -0.42,0.02 -0.08,0.12 -0.16,-0.17 -0.23,-0.03 -0.08,-0.12 -0.25,0 -0.36,-0.07 -0.02,-0.08 -0.08,0.09 -0.11,-0.01 -0.11,-0.05 -0.27,0.04 -0.35,-0.07 -0.13,-0.07 -0.15,-0.18 -0.13,-0.3 -0.08,-0.06 -0.07,-0.14 0.03,-0.18 0.09,-0.08 -0.15,-0.03 -0.05,-0.12 0.07,-0.07 0.02,-0.22 -0.09,-0.27 -0.09,-0.07 -0.15,-0.18 -0.26,-0.22 -0.1,0.01 -0.02,-0.11 -0.11,-0.12 -0.14,-0.05 -0.08,-0.24 -0.12,-0.32 -0.09,-0.07 0.14,-0.06 0.2,-0.05 0.13,0.02 0.19,-0.07 0.32,-0.06 0.1,-0.02 0.12,-0.18 0.23,-0.14 0.05,-0.08 0.17,-0.06 0.2,-0.16 0.05,0.01 0.04,-0.07 0.11,-0.05 0.06,-0.07 0.21,-0.02 0.25,-0.13 0.14,0 0.12,-0.18 0.07,-0.26 -0.02,-0.03 -0.08,-0.1 -0.07,-0.15 0.11,-0.06 0.17,-0.17 0.15,-0.29 0.11,-0.07 0.02,-0.21 -0.01,-0.28 0.02,-0.1 -0.04,-0.27 0.03,-0.33 0.15,0.01 0.29,-0.09 0.35,-0.2 -0.08,-0.09 -0.05,-0.21 -0.17,-0.27 0.03,-0.13 -0.12,-0.05 -0.15,-0.15 -0.06,-0.05 -0.13,-0.02 -0.12,-0.11 -0.13,-0.08 0.01,-0.23 0.06,-0.3 0.01,-0.08 0.01,-0.18 -0.1,-0.18 -0.07,-0.08 -0.19,0.01 -0.26,-0.08 -0.04,0.06 -0.2,0.05 -0.18,0.17 -0.12,0.05 0.02,0.2 -0.1,0.24 0.03,0.14 -0.15,0.11 -0.21,0.2 -0.05,0.04 -0.16,0.04 -0.12,0.13 -0.09,0 -0.03,0.16 -0.14,0.11 -0.09,0.13 -0.25,0.09 -0.39,0.09 -0.09,0.01 -0.22,-0.03 -0.25,0.05 -0.09,-0.09 0.03,-0.25 -0.05,-0.35 -0.12,-0.05 -0.07,-0.22 -0.24,-0.2 -0.14,0.05 -0.15,-0.15 -0.29,-0.14 -0.1,0.01 -0.15,0 -0.2,-0.07 -0.07,-0.07 -0.14,-0.16 -0.25,-0.14 -0.06,-0.08 -0.17,-0.01 -0.22,-0.1 -0.09,0.04 -0.15,-0.06 -0.22,-0.06 -0.05,-0.12 -0.21,-0.05 -0.27,-0.14 -0.11,-0.02 -0.15,0.09 -0.27,0.05 -0.07,0.01 -0.08,0.06 -0.15,0.06 -0.04,0.11 -0.15,0.24 -0.28,0.26 -0.09,0.09 -0.31,0.02 -0.45,0.04 -0.08,-0.06 -0.17,-0.2 -0.32,-0.15 -0.11,0.02 -0.16,-0.07 -0.27,-0.06 -0.08,-0.09 0.04,-0.25 -0.07,-0.33 0.05,-0.1 -0.09,-0.11 -0.11,-0.15 0.04,-0.15 -0.12,-0.17 -0.23,-0.19 -0.02,-0.13 -0.27,-0.01 -0.2,-0.19 -0.03,-0.06 -0.07,-0.08 -0.06,-0.16 -0.04,-0.05 -0.1,-0.02 -0.13,-0.07 -0.16,0.02 -0.1,-0.22 -0.26,-0.15 -0.08,-0.06 -0.15,-0.15 -0.27,-0.1 -0.09,0 -0.13,-0.07 -0.23,-0.05 -0.07,-0.05 -0.2,-0.07 -0.2,-0.19 -0.09,-0.07 0.01,-0.18 -0.09,-0.25 0.02,-0.11 0.01,-0.22 -0.1,-0.29 -0.02,-0.13 -0.21,-0.21 -0.3,-0.32 -0.06,-0.08 -0.16,-0.11 -0.27,-0.1 -0.09,-0.12 -0.26,0.06 -0.23,0.16 -0.04,0.09 -0.14,0.04 -0.12,-0.04 -0.08,-0.12 -0.25,-0.05 -0.37,-0.07 -0.1,-0 -0.14,0.07 -0.24,0.06 -0.09,0.04 -0.08,0.14 -0.13,0.19 0.05,0.13 -0.07,0.2 -0.16,0.27 -0.08,0.05 -0.03,0.15 -0.14,0.13 -0.04,0.05 -0.01,0.11 -0.1,0.1 -0.09,0.05 -0.14,0.2 -0.27,0.14 -0.09,-0.06 0.03,-0.18 -0.09,-0.23 -0.06,-0.04 -0.05,-0.13 -0.09,-0.16 0.01,-0.09 -0.06,-0.14 -0.08,-0.21 -0.05,-0.07 -0.18,-0.04 -0.15,-0.15 0.04,-0.12 -0.01,-0.28 -0.17,-0.25 -0.08,0.04 -0.14,0.09 -0.23,0.1 -0.08,-0.09 -0.22,-0.08 -0.3,-0.19 -0.07,-0.09 -0.17,-0.06 -0.23,-0.16 -0.06,-0.15 -0.3,-0.05 -0.3,-0.23 -0.02,-0.05 -0.15,-0.11 -0.1,-0.21 0.05,-0.14 -0.08,-0.25 -0.06,-0.39 0.02,-0.12 -0.02,-0.25 0.06,-0.33 0.03,-0.12 0.19,-0.09 0.24,-0.2 0.08,-0.04 0.08,-0.08 0.09,-0.15 0.07,-0.07 0.23,-0.03 0.28,-0.15 0.08,-0.08 -0.01,-0.18 -0.01,-0.25 0.09,-0.08 0.19,-0.2 0.35,-0.15 0.11,0.01 0.24,0.02 0.32,-0.05 0.11,0.02 0.15,-0.07 0.26,-0.06 0.1,-0.04 0.19,-0.12 0.27,-0.19 0.12,-0.08 0.14,-0.23 0.28,-0.31 0.1,-0.06 0.12,-0.15 0.15,-0.25 0.11,-0.07 0.2,-0.18 0.3,-0.26 -0.05,-0.16 0.17,-0.23 0.16,-0.37 -0.07,-0.15 0.15,-0.18 0.11,-0.32 0.14,-0.1 -0.05,-0.2 -0.01,-0.32 0.05,-0.16 -0.13,-0.24 -0.23,-0.34 -0.09,-0.09 -0.16,-0.19 -0.3,-0.18 -0.1,-0.07 -0.29,-0.05 -0.37,0.01 -0.13,0.03 -0.24,-0.02 -0.34,-0.07 -0.04,-0.07 -0.13,-0.08 -0.19,-0.08 -0.11,-0.07 -0.3,-0.05 -0.4,-0.01 -0.14,0.06 -0.33,-0.01 -0.49,0.03 -0.08,0.07 -0.22,0.01 -0.26,0.12 -0.15,0.04 -0.33,0.03 -0.48,-0 -0.08,-0.05 -0.26,-0.01 -0.29,-0.14 -0.07,-0.07 -0.02,-0.24 -0.01,-0.29 0.12,-0.11 0.33,-0.02 0.5,-0.05 0.14,0.04 0.2,-0.12 0.29,-0.18 -0.01,-0.11 0.18,-0.14 0.17,-0.26 0.07,-0.06 0.04,-0.13 0.13,-0.17 0.1,-0.06 0.07,-0.21 0.22,-0.2 0.17,0.03 0.19,-0.13 0.17,-0.25 10e-4,-0.1 -0.03,-0.19 0.07,-0.24 0.05,-0.04 0.06,-0.11 0.1,-0.17 0,-0.12 0.17,-0.08 0.26,-0.1 0.09,-0.06 0.16,-0.2 0.09,-0.29 -0.08,-0.08 -0.02,-0.21 0.06,-0.26 0.06,-0.06 0.19,-0.15 0.24,-0.25 -0.05,-0.06 -0.07,-0.11 -0.07,-0.18 -0.08,-0.04 -0.02,-0.11 -0.11,-0.14 -0.05,-0.08 -0.08,-0.14 -0.12,-0.23 -0.05,-0.03 -0.12,-0.1 -0.18,-0.11 -0.05,-0.13 0.04,-0.24 0.17,-0.25 0.05,-0.06 0.12,-0.11 0.04,-0.16 0.03,-0.04 0.13,0.01 0.12,-0.07 0.16,0.03 0.21,-0.2 0.09,-0.27 -0.05,-0.1 0.05,-0.15 0.13,-0.14 0.11,-0.06 0.29,-0.07 0.38,0.01 0.12,0 0.16,0.18 0.31,0.16 0.07,0.06 0.18,0.03 0.24,0.09 0.15,-6.9e-4 0.32,0.03 0.45,-0.05 0.14,-0.04 0.24,0.1 0.38,0.05 0.06,-0.04 0.06,-0.05 0.11,-0 0.12,0.01 0.27,0.04 0.35,-0.06 0.03,-0.09 0.15,-0.08 0.19,-0.13 0.1,0.03 0.15,-0.19 0.25,-0.06 0.11,0.06 0.28,-0.02 0.27,-0.13 0.11,-0.08 0.1,-0.19 0.22,-0.25 0.06,-0.1 0.04,-0.24 -0.03,-0.3 0.05,-0.12 -0.14,-0.15 -0.12,-0.25 -0.12,-0.09 0.02,-0.21 0.14,-0.15 0.11,0.05 0.18,-0.11 0.24,0.01 0.02,0.07 0.02,0.1 0.1,0.1 0.08,0.1 0.17,-0.1 0.24,-0.13 0.08,-0.07 0.09,-0.22 0.2,-0.28 0,-0.11 0.08,-0.2 0.13,-0.3 -9.8e-4,-0.05 0.09,-0.1 0.05,-0.17 -0.03,-0.13 0.02,-0.26 -0.01,-0.38 -0.08,-0.11 -0.11,-0.24 -0.24,-0.33 -0.12,-0.08 -0.23,-0.09 -0.33,-0.2 -0.11,-0.03 -0.16,0.08 -0.28,0.05 -0.13,0.04 -0.22,-0.06 -0.24,-0.16 -0.1,-0.09 -0.24,-0.11 -0.3,-0.23 -0.03,-0.15 0.14,-0.13 0.21,-0.21 0.08,-0.12 0.2,0.11 0.3,-0.02 0.02,-0.04 0.08,0.08 0.14,0.03 -0.01,0.1 0.18,-0 0.18,0.1 0.07,0 0.15,0.06 0.18,0.08 0.12,0.01 0.17,0.16 0.31,0.12 0.12,-0.02 0.32,0.03 0.39,-0.03 0.04,-0.03 0.12,-0.03 0.16,-0.07 0.09,0.01 0.13,0.16 0.24,0.09 0.08,0.12 0.17,0.01 0.23,-0.05 0.06,-0.09 0.25,0.01 0.34,-0.07 0.08,-0.07 0.16,-0.17 0.26,-0.23 0.1,-0.02 0.17,-0.13 0.19,-0.19 0.07,-0.07 0.15,-0.15 0.14,-0.23 -0.14,-0.06 0.03,-0.24 -0.09,-0.32 -0.03,-0.08 -10e-4,-0.19 -0.07,-0.25 0.04,-0.09 -0.11,-0.12 -0.01,-0.17 0.02,-0.13 0.1,-0.25 0.06,-0.39 -0.02,-0.05 0.11,-0.05 0.02,-0.1 -0.03,-0.04 0.14,-0.14 0.17,-0.18 0.09,-0.02 0.16,-0.08 0.26,-0.06 0.13,-0.06 0.16,-0.21 0.14,-0.34 -0.02,-0.14 0.03,-0.25 0.11,-0.36 0.01,-0.13 0.25,0.01 0.3,-0.1 0.1,0.01 0.21,0.01 0.28,-0.05 0.11,0.02 0.15,-0.07 0.26,-0.06 0.1,-0.07 0.23,-0.08 0.31,-0.18 0.11,0.02 0.13,-0.1 0.17,-0.14 0.16,-0.03 0.02,-0.19 0.14,-0.26 -0.04,-0.11 0.02,-0.19 0.06,-0.28 -0.02,-0.08 -0.13,-0.13 -0.14,-0.21 -0.11,0.01 -0.18,-0.04 -0.14,-0.14 -0.02,-0.11 0.03,-0.2 0.1,-0.26 0.07,0.02 0.1,0.05 0.17,0.07 0.05,0.06 0.08,0.12 0.15,0.03 0.09,0.08 0.2,0.09 0.3,0.16 0.16,-0.05 0.35,0.04 0.5,-0.05 0.04,-0.06 0.01,-0.16 0.08,-0.19 -0,-0.13 0.13,-0.12 0.22,-0.15 0.08,-0.05 0.29,-10e-4 0.27,-0.16 0.05,-0.06 0.09,-0.16 0.13,-0.22 0.1,-0.06 0.18,-0.17 0.22,-0.24 0.01,-0.09 0.08,-0.12 0.13,-0.2 10e-4,-0.05 0.08,-0.08 0.05,-0.16 0.04,-0.08 0.18,-0.22 0.26,-0.08 0.07,0.07 0.1,0.19 0.2,0.23 0.11,-0 0.07,0.15 0.19,0.17 0.02,0.1 -6.7e-4,0.24 -0.15,0.18 -0.13,-0.01 -0.1,0.18 -0.2,0.17 -0.08,0.07 -0.23,-0.01 -0.29,0.11 -0.07,0.07 -0.19,0.14 -0.16,0.26 -0.03,0.09 -0.08,0.16 -0.05,0.27 0,0.11 0,0.23 0,0.34 0.12,0.04 0.14,0.16 0.27,0.17 0.04,0.14 0.25,0.04 0.32,0.14 0.08,-0.01 0.14,-0.18 0.22,-0.06 -0.05,0.1 -0.17,0.18 -0.18,0.31 -0.12,0.11 -0.3,0.03 -0.45,0.05 -0.18,0 -0.37,0 -0.55,0 -0.04,0.11 -0.25,-0.01 -0.29,0.14 -0.06,0.07 -0.14,0.07 -0.22,0.12 -0.14,-0.05 -0.21,0.05 -0.34,0.05 -0.04,0.06 -0.16,0.03 -0.21,0.09 -0.08,0.02 -0.14,0.13 -0.22,0.12 -0.06,0.12 -0.22,0.04 -0.29,0.17 -0.11,4.1e-4 -0.15,0.15 -0.29,0.11 -0.13,-0.04 -0.17,0.12 -0.29,0.12 -0.09,0.09 -0.2,0.2 -0.15,0.34 0.06,0.11 0.19,0.17 0.27,0.27 0.1,0.07 0.19,-0.07 0.32,-0.03 0.11,0.01 0.18,0.08 0.3,0.05 0.09,0.06 0.2,0.06 0.32,0.05 0.11,0 0.23,-4.5e-4 0.34,0 0.03,0.08 0.15,0.13 0.12,0.22 0.09,0.08 -0.01,0.22 0.11,0.26 0.12,0.05 0.29,-0.02 0.43,0.02 0.08,0.07 0.21,0.02 0.26,0.13 0.05,0.03 0.15,0.02 0.06,0.08 -0.03,0.06 0.13,0.14 0.18,0.04 0.08,0.02 0.11,-0.1 0.19,-0.04 0.05,-0.04 0.09,-0.07 0.12,-0.01 0.08,-0.01 0.26,0 0.13,0.09 0.03,0.09 -0.01,0.19 -0.11,0.18 -0.07,0.05 -0.11,0.13 -0.13,0.18 -0.08,0.07 -0.15,0.15 -0.26,0.18 -0.07,0.12 -0.04,0.32 -0.02,0.42 0.11,0.04 0.07,0.21 0.22,0.21 0.12,-0.05 0.25,-0.08 0.39,-0.05 0.15,0.03 0.25,-0.12 0.4,-0.03 0.03,0.04 0.21,-0 0.15,0.12 -0.02,0.11 0,0.22 0.11,0.29 -0.01,0.16 0.23,0.11 0.34,0.12 0.14,-0.05 0.19,0.12 0.29,0.12 0.01,0.14 0.24,0.18 0.23,0.32 0.03,0.11 -0.11,0.12 -0.17,0.13 -0.07,0.1 -0.25,0.08 -0.22,0.23 0.01,0.07 -0.02,0.14 0.05,0.16 -0.01,0.07 0.02,0.14 0.05,0.18 0.01,0.13 0.1,0.22 0.19,0.31 0.09,0.06 0.1,0.18 0.17,0.27 0.07,0.05 0.16,0.01 0.21,0.08 0.08,0.04 0.19,0.06 0.3,0.05 0.11,0.05 0.19,0.13 0.29,0.2 0.1,0.01 0.24,-0.03 0.28,0.09 0.08,-0 0.13,0.04 0.05,0.08 0.04,0.14 0.24,0.03 0.3,0.13 0.13,-0.02 0.23,0.02 0.33,0.07 0.03,0.07 0.13,0.08 0.16,0.1 0.11,0.05 0.19,0.09 0.29,0.13 0.12,-0.05 0.2,0.02 0.28,0.08 0.1,-0.02 0.18,0.03 0.25,0.06 0.12,-0.04 0.08,-0.23 0.25,-0.21 0.07,0.03 0.1,0.06 0.19,0.06 0.08,0.1 0.01,0.27 0.03,0.4 -0.01,0.12 0.03,0.31 -0.02,0.39 -0.14,0.02 -0.27,0.01 -0.38,-0.05 -0.09,-0.05 -0.15,-0.21 -0.25,-0.09 -0.04,-0.04 -0.14,-0.11 -0.17,-0.01 -0.11,-0.03 -0.15,0.13 -0.25,0.12 -0.08,0.09 -0.12,0.16 -0.12,0.27 -0.1,0.03 -0.02,0.19 -0.04,0.28 0.04,0.13 -0.15,0.27 -0,0.37 -0.02,0.11 -0,0.22 0.11,0.29 0.05,0.09 0.16,0.05 0.19,0.13 0.09,0.05 0.12,0.15 0.22,0.15 0.07,0.08 0.17,0.15 0.24,0.23 0.13,0.02 0.19,0.14 0.24,0.23 0.09,0.03 0.16,0.05 0.12,0.15 -0.02,0.12 0.1,0.18 0.06,0.31 0.01,0.13 -0.04,0.25 0.08,0.33 0.07,0.02 -0.08,0.07 0.02,0.11 0.01,0.1 0.18,0.17 0.12,0.3 -0.05,0.17 0.16,0.21 0.25,0.29 0.04,0.11 0.12,-0.09 0.12,0.03 -0.01,0.07 0.12,0.05 0.14,0.1 0.16,-0.04 0.25,0.14 0.09,0.21 -0.02,0.05 -0.02,0.14 -0.06,0.18 0.08,0.11 0.25,0.07 0.32,0.01 0.06,-0 0.12,-0.11 0.16,-0.01 -0.01,0.09 0.1,0.04 0.14,0.11 0.09,-0.01 0.18,-0 0.24,0.05 0.08,-0.02 0.16,-0.11 0.21,-0.08 0.1,0.08 0.27,-0.01 0.4,0.04 0.07,0.07 0.19,0.03 0.24,0.1 0.11,-0.01 0.17,-0.07 0.28,-0.06 0.14,-0.02 0.07,-0.2 0.14,-0.23 -0.13,-0.1 0.2,-0.1 0.12,0.03 -0.02,0.14 0.17,0.18 0.24,0.24 0.07,0 0.15,0 0.17,0.05 0.1,-0.03 0.18,0.03 0.25,0.05 0.09,10e-4 0.14,0.05 0.21,0.09 0.04,0.05 0.04,0.11 0.09,0.15 -0.16,0.06 -0.09,0.22 -0.11,0.34 -0.02,0.15 0.08,0.31 0.23,0.35 0.07,0.09 0.18,0.06 0.25,0.12 0.11,-0.02 0.14,0.08 0.25,0.05 0.14,0.05 0.24,-0.06 0.37,-0.05 0.09,0.01 0.12,-0.05 0.19,-0.07 0.08,-0.05 0.05,-0.14 0.15,-0.18 0.03,-0.07 0.14,-0.09 0.14,-0.19 0.07,-0.04 0.03,-0.1 0.09,-0.14 0.02,-0.15 0.24,-0.2 0.28,-0.34 0.08,-0.06 10e-4,-0.2 0.09,-0.24 0.09,0.02 0.06,-0.17 0.2,-0.15 0.01,-0.06 0.13,-0.03 0.15,-0.09 0.07,0.1 0.3,0.06 0.3,-0.08 -0.03,-0.08 0.03,-0.15 0.11,-0.15 0.1,-0.07 0.04,-0.17 -0.02,-0.23 0.07,-0.16 -0.09,-0.27 -0.21,-0.36 -0.11,-0.08 -0.09,-0.19 -0.21,-0.25 -0.05,-0.15 0.12,-0.19 0.24,-0.21 0.04,-0.1 0.23,-0.08 0.2,-0.22 0.01,-0.12 0.23,-0.03 0.16,0.07 -0.06,0.14 0.11,0.2 0.23,0.18 0.07,0.06 0.19,0.13 0.2,0.24 0.01,0.11 0.23,0.19 0.23,0.3 0.18,0 0.12,0.18 0.17,0.27 0.04,0.09 0.11,0.21 0.25,0.19 0.13,0.05 0.22,0.17 0.35,0.25 0.1,0.01 0.17,0.14 0.26,0.21 0.06,0.08 0.16,0.09 0.21,0.14 0.2,9.7e-4 0.41,6.4e-4 0.61,9.3e-4 0.07,-0.12 0.26,-0.01 0.39,-0.05 0.08,-0.05 0.2,-0.14 0.21,-0.24 0.13,-5.6e-4 0.2,-0.1 0.33,-0.06 0.07,0.06 0.28,0.04 0.25,0.2 0.08,0.05 0.2,0.18 0.3,0.05 0.22,0 0.44,4.1e-4 0.66,4.5e-4 0.06,0.12 0.19,0.19 0.32,0.2 0.12,-0.04 0.2,0.06 0.27,0.12 0.03,0.05 0.06,0.05 0.05,0.11 0.08,0.03 0.16,0.03 0.22,0.08 0.07,-0.04 0.12,0.05 0.14,0.03 0.07,-0.06 0.16,-0.01 0.21,-0.08 0.09,4.1e-4 0.09,-0.07 0.2,-0.06 0.1,-0.05 0.25,-0.07 0.36,-0.02 -0.12,0.06 0,0.22 0.13,0.18 0.08,-0.07 0.19,-0.16 0.23,-0.25 0.08,0.03 0.2,-0.03 0.22,-0.03 0.06,0.14 0.26,0.05 0.34,0.12 0.08,0.04 0.18,0.09 0.27,0.12 0.14,0.04 0.14,0.21 0.27,0.28 0.04,0.02 0.13,0.03 0.1,0.11 -0.05,0.15 0.12,0.16 0.22,0.18 0.03,0.03 0.11,0.05 0.16,0.08 0.1,-0.01 0.24,0.01 0.29,-0.05 0.09,0.11 0.24,0.01 0.18,-0.11 0.01,-0.1 0.19,-0.13 0.18,-0.25 0.11,0.02 0.31,-0.04 0.36,0.03 -0.02,0.1 -0.01,0.19 0.06,0.26 -0.01,0.1 -0.1,0.18 -0.06,0.28 -0.07,0.05 -0.04,0.11 -0.1,0.15 0,0.07 -0.07,0.08 -0.06,0.15 -0.06,0.04 -0.11,0.01 -0.14,0.08 -0.08,0.06 -0.21,0.18 -0.08,0.26 0.03,0.05 0.13,0.01 0.14,0.08 0.06,0.07 0.17,0.03 0.13,0.14 0.01,0.06 0.07,0.06 0.06,0.13 0.1,0.04 0.18,0.09 0.31,0.07 0.06,0.04 0.04,0.05 0.1,-0 0.12,-0.05 0.17,0.1 0.29,0.05 0.14,-0.02 0.28,0.03 0.37,0.12 0.14,0.07 0.13,0.22 0.23,0.31 0.05,0.06 0.21,-0.02 0.23,0.07 0.09,0.02 0.18,-0 0.24,-0.04 0.1,0.02 0.13,-0.06 0.21,-0.06 0.11,-0.1 0.28,-0.02 0.38,0.03 0.01,0.13 0.18,0.17 0.19,0.29 0.05,0.05 0.03,0.1 0.12,0.1 0.03,0.06 0,0.14 0.08,0.19 -0.05,0.11 0.1,0.15 0.15,0.18 0.11,0.01 0.14,0.11 0.24,0.13 0.05,-0 0.01,0.11 0.08,0.11 0.08,0.08 0.15,0.18 0.26,0.19 0.09,0.11 0.2,0.16 0.33,0.21 0.03,0.06 0.1,-0.07 0.19,-0.02 0.09,0.01 0.22,-0.04 0.2,0.09 0.08,0.06 0.16,0.14 0.24,0.21 0.03,0.05 0.04,0.11 0.08,0.14 -0.02,0.11 0.1,0.15 0.06,0.27 -0,0.11 -0.02,0.23 0.02,0.34 0.08,0.08 -0.02,0.23 0.08,0.3 -0,0.1 0.06,0.18 0.13,0.26 0.11,-0.04 0.07,0.12 0.15,0.14 0.07,0.06 0.13,0.19 0.08,0.29 -0.1,0.07 -0.16,0.21 -0.3,0.22 -0.1,-0.05 -0.14,0.08 -0.24,0.04 -0.13,0.05 -0.16,0.17 -0.16,0.29 -0.13,0.09 0.06,0.19 0.01,0.31 0.02,0.11 -0.14,0.16 -0.13,0.25 -0.14,0.05 -0.04,0.24 -0.14,0.28 0.07,0.06 0.07,0.21 0.01,0.29 -0.04,0.1 -0.11,0.19 -0.15,0.29 -0.1,-0.01 -0.22,0.01 -0.29,-0.06 -0.12,0.06 -0.31,0.12 -0.27,0.28 0.1,0.07 0.15,0.16 0.26,0.22 0.13,0.01 0.03,0.16 -8.9e-4,0.2 0.11,0.07 -0,0.3 0.16,0.28 0.09,-0.09 0.22,-0.02 0.29,0.05 0.08,0.04 0.19,-0.02 0.23,0.06 0.14,-0.02 0.12,0.15 0.18,0.18 -0.02,0.14 0.23,0.09 0.16,0.23 0.05,0.11 0.07,0.21 0.06,0.33 0,0.1 0,0.2 4.4e-4,0.3 -0.09,0.01 -0.05,0.17 -0.18,0.15 -0.07,0 -0.04,0.06 -0.11,0.05 -0.1,0.09 -0.26,0.04 -0.39,0.04 -0.12,-0.06 -0.13,-0.19 -0.24,-0.27 -0.12,-0.07 -0.27,-0.03 -0.35,0.07 -0.08,0.1 -0.18,0.17 -0.31,0.18 -0.04,0.14 -0.21,0.05 -0.31,0.08 -0.04,-0.04 -0.09,-0.09 -0.12,-4.1e-4 -0.09,0.06 -0.15,0.08 -0.25,0.11 -0.05,0.05 -0.03,0.17 -0.15,0.13 -0.09,-0.02 -0.19,0.01 -0.18,0.09 -0.15,-0 -0.2,0.19 -0.22,0.25 -0.14,0.01 -0.18,0.16 -0.29,0.22 -0.1,0.14 -0.28,0.06 -0.42,0.08 -0.1,0.04 -0.19,0.08 -0.27,0.16 -0.13,-0 -0.11,0.16 -0.21,0.21 -0.03,0.08 -0.02,0.12 -0.07,0.18 0.01,0.08 -0.01,0.15 -0.06,0.21 0.05,0.06 0.09,0.13 0.01,0.19 -0.02,0.13 0.01,0.27 -0.01,0.4 0.01,0.07 0.08,0.07 0.01,0.12 -0.02,0.1 0.02,0.21 -0.07,0.28 0.05,0.12 -0.06,0.19 -0.13,0.25 -0.11,-0.01 -0.22,-0 -0.3,0.05 -0.07,0.04 -0.13,0.12 -0.2,0.12 -0.06,0.1 -0.19,0.09 -0.26,0.19 -0.02,0.05 -0.01,0.11 -0.11,0.1 -0.04,0.05 0.04,0.16 -0.09,0.15 -0.07,0.04 0.01,0.14 -0.08,0.18 0.01,0.06 -0.07,0.08 -0.06,0.16 -0.08,-0.01 -0.14,0.08 -0.23,0.05 -0.07,0.06 -0.14,0.04 -0.19,0.13 -0.1,0.05 -0.11,0.15 -0.17,0.22 0.05,0.07 -0.07,0.13 -0.06,0.18 -0.07,0.06 -0.01,0.18 -0.12,0.21 -0.07,0.12 -0.11,0.23 -0.19,0.34 0.04,0.12 -0.17,0.18 -0.1,0.32 0.02,0.12 -0.18,0.15 -0.17,0.27 -0.02,0.12 0.04,0.18 0.11,0.25 -0.08,0.04 -0.03,0.19 -0.16,0.18 -0.07,0.12 -0.23,0.08 -0.35,0.08 -0.07,0.11 -0.25,-0.02 -0.32,0.1 -0.14,0 -0.2,0.12 -0.32,0.15 -0.06,0.02 -0.1,0.12 -0.19,0.11 -0.05,0.07 -0.14,0.01 -0.12,0.11 -0.07,0.03 -0,0.12 -0.12,0.12 -0.1,0.05 -0.16,0.13 -0.17,0.24 -0.04,0.11 -0.15,0.16 -0.17,0.27 -0.12,0.04 -0.04,0.17 -0.13,0.22 -0.04,0.12 0.06,0.28 0.16,0.29 0.07,0.08 0.23,-0.03 0.29,0.07 0.15,0.03 0.31,-0.02 0.45,0.02 0.07,0.11 -0.06,0.2 -0.16,0.22 -0.06,0.1 -0.24,0.17 -0.21,0.3 -0.04,0.07 -0.06,0.14 -0.14,0.14 -0.08,0.09 -0.24,0.11 -0.25,0.23 -0.15,0.01 -0.1,0.21 -0.22,0.26 -0.1,0.04 -0.05,0.15 -0.12,0.21 -0.02,0.04 -0.01,0.14 -0.07,0.18 0.04,0.12 -0.05,0.21 -0.05,0.31 -0.03,0.09 0.03,0.17 0.11,0.16 0.07,0.05 0.11,0.13 0.13,0.18 0.1,0.06 0.08,0.16 0.18,0.22 0.1,0.05 0.18,0.08 0.29,0.14 0.1,0.01 0.01,0.15 -0.01,0.2 -0.05,0.12 -0.17,0.12 -0.25,0.19 -0.09,0.13 0.06,0.21 0.03,0.34 -0,0.09 0.14,0.1 0.11,0.19 0.08,0.02 0.13,0.04 0.05,0.1 0.14,0.07 0.12,0.2 0.21,0.3 -0.05,0.13 0.16,0.16 0.11,0.3 -0.02,0.11 -0.01,0.3 0.15,0.27 0.18,-0.01 0.04,-0.24 0.21,-0.21 0.05,-0.09 0.3,-0.05 0.28,0.09 0.08,0.09 0.09,0.21 0.19,0.28 -0,0.1 0.12,0.14 0.17,0.15 -0.1,0.09 -0.04,0.23 -0.05,0.35 0.05,0.08 0.07,0.2 0.21,0.19 0.06,0.13 0.23,0.06 0.29,0.18 0.08,0.07 0.15,0.17 0.25,0.21 0.09,0.01 0.13,-0.11 0.18,4.1e-4 0.08,0.09 0.18,0.18 0.32,0.15 0.1,-0.04 0.05,-0.18 0.19,-0.15 0.07,0.02 0.16,-0.02 0.18,0.05 0.14,-0 0.23,0.05 0.31,0.14 0.05,0.06 0.05,0.15 0.1,0.22 -0.07,0.08 -0.18,0.15 -0.19,0.24 -0.12,0.09 -0.21,0.21 -0.19,0.36 0.02,0.13 -0.09,0.2 -0.05,0.34 0.05,0.09 0.17,0.16 0.2,0.26 0.1,0.1 0.21,0.1 0.29,0.22 0.09,0.01 0.12,0.08 0.19,0.11 0.05,-0.07 0.2,-0.03 0.25,-0.14 0.06,-0.01 0.15,-0.01 0.18,-0.06 0.06,-0.01 0.13,-0.07 0.17,-0.07 0.05,-0.06 0.18,-0.02 0.21,-0.08 0.08,-0.02 0.15,-0.09 0.24,-0.05 0.1,0 0.15,0.09 0.26,0.05 0.15,-0.04 0.25,0.09 0.21,0.21 -0.01,0.12 0.01,0.24 -0,0.36 -0.09,0.09 -0.12,0.21 -0.1,0.34 -0.07,0.12 -0.19,-0.08 -0.31,-0.01 -0.11,0.01 -0.19,-0.01 -0.24,0.08 -0.1,0.06 -0.01,0.18 -0.14,0.23 -0.04,0.09 0.04,0.27 -0.11,0.26 -0.02,0.11 -0.09,0.19 -0.17,0.27 0.02,0.1 -0.09,0.16 -0.05,0.26 -0.04,0.13 0.02,0.25 0.17,0.27 0.03,0.03 0.1,0.03 0.14,0.07 0.03,-0.11 0.1,0.04 0.17,0.02 -0.05,0.09 -0.09,0.15 -0.13,0.25 -0.04,0.02 -0.02,0.09 -0.08,0.12 0,0.07 -0.06,0.09 -0.07,0.17 -0.17,0.1 -0.38,0.02 -0.56,0.04 -0.01,0.05 -0.08,0.09 -0.07,0.14 -0.17,-0.02 -0.22,0.13 -0.33,0.2 -0.12,0.05 -0.04,0.18 -0.11,0.26 -0.04,0.04 0,0.15 -0.09,0.18 -0.08,0.08 -0.22,0.09 -0.28,0.16 -0.11,4.1e-4 -0.14,0.15 -0.28,0.1 -0.11,-0.03 -0.13,0.08 -0.25,0.05 -0.04,0.06 -0.14,0.05 -0.17,0.1 -0.14,0.02 -0.34,-0.06 -0.44,0.07 -0.03,0.1 -0.11,0.25 -0.21,0.27 -0.06,-0.12 -0.2,-0.11 -0.28,-0.04 -0.11,-0.02 -0.19,-0 -0.27,0.05 -0.1,0.07 -0.26,0.17 -0.27,0.29 -0.13,0.06 -0.01,0.21 0.01,0.3 -0.02,0.1 0.03,0.21 -0.08,0.25 -0.07,0.08 -0.21,0.13 -0.2,0.27 0.02,0.1 -0.02,0.18 0.07,0.22 0.12,0.1 -0.07,0.21 -0.01,0.33 0,0.11 -0.04,0.24 0.03,0.34 0.08,0.09 0.19,0.15 0.21,0.26 0.06,0.08 -0.02,0.19 0.09,0.23 0.12,-0 0.09,0.06 0.01,0.1 -0.04,0.08 -0.08,0.12 -0.1,0.21 -0.14,0.04 -0.09,0.22 -0.03,0.3 -0.03,0.12 0.01,0.28 0.18,0.25 0.1,0.04 0.18,0.1 0.27,0.19 0.11,0 0.08,0.15 0.19,0.17 0.04,0.03 0.05,0.08 0.07,0.14 0.09,0.04 0.13,0.16 0.24,0.16 0.1,0.06 0.12,0.15 0.14,0.25 0.09,0.1 0.26,-0.02 0.33,0.09 0.14,0.03 0.33,-0.06 0.4,0.08 0.07,0.07 0.25,0.17 0.1,0.27 0.02,0.11 -0.21,0.06 -0.25,0.01 -0.12,0.01 -0.17,-0.09 -0.3,-0.05 -0.1,-0.02 -0.15,-0.09 -0.27,-0.05 -0.1,-0.01 -0.15,-0.08 -0.27,-0.05 -0.07,-0.08 -0.2,-0.04 -0.31,-0.05 -0.09,-0.02 -0.24,0.04 -0.27,-0.04 -0.07,-0.02 -0.16,0 -0.19,-0.06 -0.1,0.02 -0.17,-0.03 -0.25,-0.05 -0.12,-0.01 -0.2,-0.1 -0.31,-0.12 -0.05,-0.1 -0.26,-0.08 -0.21,-0.23 -0.05,-0.01 -0.09,0.1 -0.12,0.01 -0.09,-0.01 -0.15,-0.08 -0.24,-0.06 -0.09,-0.09 -0.24,-0.02 -0.36,-0.04 -0.1,-0.02 -0.21,0.02 -0.29,0.04 -0.05,-0.06 -0.11,-0.04 -0.17,-0.09 -0.09,0.01 -0.22,-0.02 -0.25,0.05 -0.11,-5.3e-4 -0.17,0.12 -0.28,0.1 -0.01,0.08 -0.14,0.03 -0.15,0.1 -0.02,0.05 -0.03,0.11 -0.06,0.13 -0.02,0.07 -0.09,0.13 -0.06,0.22 -0.03,0.06 -0.1,0.11 -0.01,0.17 0.02,0.06 -0,0.13 0.07,0.17 -0.06,0.12 0.08,0.18 0.04,0.29 0.01,0.07 0.11,0.12 0.01,0.18 0.01,0.17 -0.25,0.01 -0.34,0.11 -0.05,0.03 -0.16,0.01 -0.19,0.07 -0.08,0.01 -0.18,-0.01 -0.21,-0.04 -0.07,0.09 -0.3,-0.01 -0.28,0.15 -0.06,0.05 -0.19,0.06 -0.18,0.18 -0.06,0.01 -0.11,0.01 -0.1,0.09 -0.06,0.04 -0.02,0.12 -0.13,0.13 -0.08,0.04 0.04,0.17 -0.07,0.21 0.03,0.1 -0.16,0.12 -0.11,0.22 -0.08,0.01 -0.05,0.12 -0.11,0.15 0.04,0.13 -0.09,0.21 -0.05,0.34 -0.01,0.09 0.15,0.11 0.11,0.2 0.09,0.03 0.06,0.19 0.19,0.16 0.06,0.05 0.17,0.06 0.22,0.16 0.15,0.05 0.11,0.21 0.17,0.3 0.14,0.07 -0.01,0.25 0.12,0.31 0.04,0.08 -0.11,0.1 -0.01,0.16 0.06,0.11 -0.09,0.15 -0.04,0.25 -0.03,0.12 0.01,0.25 0.13,0.31 0.12,0.14 -0.13,0.12 -0.22,0.1 -0.07,-0.04 -0.15,-0.08 -0.22,-0.15 -0.08,0.02 -0.08,-0.07 -0.17,-0.06 -0.09,-0.08 -0.22,-0.1 -0.36,-0.08 -0.13,-0.04 -0.26,-0.15 -0.43,-0.1 -0.06,0.08 -0.22,0.01 -0.28,0.09 -0.1,-0.01 -0.13,0.06 -0.22,0.07 -0.05,0.07 -0.09,0.14 -0.11,0.21 -0.02,0.01 -0.07,0.06 -0.06,0.11 -0.04,0.05 -0.09,0.11 -0.1,0.18 -0.08,0.05 -0.06,0.23 -0.02,0.28 0.04,0.06 0.14,0.1 0.18,0.12 0.02,0.15 -0.01,0.31 0.01,0.46 0.12,0.06 0.1,0.17 0.2,0.24 0.06,0.08 0.17,0.14 0.26,0.14 0.05,0.06 0.13,0.01 0.16,0.09 0.02,0.08 0.01,0.17 0.14,0.14 0.07,0.05 0.22,0.1 0.25,0.2 0.05,0.06 0.07,0.12 0.07,0.18 0.07,0.04 0.03,0.1 0.09,0.14 -0.02,0.1 0.18,0.13 0.06,0.2 -0.02,0.18 0.01,0.35 -0.01,0.53 0.02,0.1 0.09,0.16 0.06,0.27 0.03,0.1 0.09,0.17 0.17,0.25 -0.03,0.09 0.12,0.05 0.13,0.11 0.11,-0 0.13,0.15 0.25,0.1 0.07,0.03 0.11,0.12 0.2,0.11 0.11,0.09 0.2,0.28 0.38,0.23 0.13,0.04 0.11,0.19 0.23,0.25 0.12,-0.02 0.09,0.19 0.24,0.16 0.08,-0.03 0.13,-0.07 0.23,-0.06 0.11,0 0.2,-0.01 0.27,0.06 0.13,-0.01 0.27,-0.01 0.4,-0.01 0.15,0.03 0.22,0.18 0.24,0.3 0.13,0.05 0.12,0.21 0.21,0.29 0.1,0.07 0.18,0.17 0.28,0.25 0.11,0.01 0.17,0.16 0.31,0.11 0.11,-10e-4 0.3,0.03 0.31,-0.11 0.02,-0.14 0.21,-0.05 0.29,-0.12 0.08,-0.04 0.28,0.02 0.33,-0.05 0.1,0.07 0.26,0.05 0.34,-0.02 0.11,-0.01 0.15,0.1 0.27,0.06 0.13,-0.03 0.31,0.03 0.27,0.18 0.02,0.12 -0.07,0.17 -0.17,0.22 -0.15,-0.01 -0.05,0.2 -0.17,0.22 -0.06,0.08 -0.11,0.12 -0.21,0.14 -0.07,0.09 -0.19,0.2 -0.16,0.33 0.08,0.07 0.08,0.24 -0.06,0.25 -0.05,0 -0.09,0.1 -0.12,-4e-4 -0.06,0.09 -0.17,0.02 -0.24,0.11 -0.08,-0.02 -0.05,0.07 -0.15,0.05 -0.04,0.04 -0.01,0.11 -0.1,0.14 -0.04,0.08 -0.08,0.12 -0.1,0.21 -0.03,0.08 -0.2,-0.01 -0.19,0.09 -0.14,-0.04 -0.22,0.06 -0.24,0.16 -0.06,0.05 0.01,0.18 -0.08,0.22 0.02,0.12 -10e-4,0.26 -0.14,0.31 -0.08,0.01 -0.1,-0.09 -0.19,-0.04 -0.13,-8.6e-4 -0.21,-0.13 -0.35,-0.11 -0.09,-0.06 0.13,-0.15 -0.03,-0.15 -0.06,-0.02 -0.08,-0.07 -0.16,-0.05 -0.13,6.9e-4 -0.18,-0.16 -0.33,-0.1 -0.16,0.05 -0.25,-0.07 -0.35,-0.17 -0.03,-0.07 -0.16,0.01 -0.2,-0.09 -0.12,0.03 -0.17,-0.08 -0.3,-0.05 -0.1,0 -0.15,0.07 -0.26,0.05 -0.11,0.01 -0.1,0.14 -0.22,0.1 -0.08,0.05 -0.22,0.07 -0.22,0.2 -0.08,-0.01 -0.01,0.12 -0.1,0.11 0.05,0.11 -0.13,0.17 -0.01,0.26 0.04,0.07 -0.08,0.1 -0.05,0.18 -0.08,0.11 -0.19,0.19 -0.22,0.32 0.01,0.09 -0.03,0.21 0.06,0.25 -0.02,0.14 0.17,0.1 0.22,0.16 -0.05,0.1 0.14,0.22 -0.02,0.3 -0.1,0.03 -0.19,0.01 -0.27,0.07 -0.1,-0 -0.17,0.09 -0.29,0.05 -0.1,0.02 -0.17,0.09 -0.29,0.04 -0.11,-0.04 -0.01,-0.18 -0.11,-0.2 -0.01,-0.16 -4.5e-4,-0.32 -0,-0.48 -0.16,-0.03 -0.09,-0.2 -0.11,-0.31 -0.06,-0.11 -0.13,-0.21 -0.1,-0.34 0,-0.13 0,-0.27 4.4e-4,-0.4 0.11,-0.02 0.05,-0.21 0.03,-0.25 -0.1,-0.05 -0.08,-0.17 -0.19,-0.23 0,-0.09 -0.12,-0.13 -0.13,-0.22 -0.04,-0.05 -0.03,-0.12 -0.09,-0.14 -0.12,-0.08 -0.12,-0.2 -0.1,-0.32 0.03,-0.15 -0.05,-0.29 -0.17,-0.38 -0.08,-0.09 -0.22,-0.11 -0.31,-0.17 -0.1,0.01 -0.14,-0.06 -0.23,-0.06 -0.07,-0.06 -0.12,-0.11 -0.22,-0.1 -0.05,-0.03 -0.01,-0.14 -0.11,-0.09 -0.06,0.07 -0.13,0.03 -0.16,0.09 -0.1,0.01 -0.19,0.1 -0.19,0.18 -0.09,0.01 -0.12,0.06 -0.12,0.12 -0.07,0.08 -0.18,0.03 -0.24,0.11 -0.09,10e-4 -0.15,0.14 -0.27,0.09 -0.03,0.14 -0.23,0.06 -0.3,0.2 -0.08,0.1 -0.2,0.11 -0.28,0.2 -0.14,-0.01 -0.17,0.19 -0.04,0.25 0.05,0.07 0.02,0.13 0.08,0.2 0.02,0.12 -0.04,0.26 0.06,0.36 -0.03,0.11 -0.01,0.22 0.05,0.3 -0.02,0.11 0.05,0.27 -0.06,0.32 -0.02,0.06 0.11,0.1 0.01,0.12 -0.01,0.14 -0.18,0.18 -0.24,0.29 -0.07,0.03 -0.01,0.16 -0.09,0.19 0.01,0.15 -0.24,0.05 -0.22,0.19 -0.02,0.1 -0.21,0.03 -0.15,0.16 0.03,0.1 -0.08,0.14 -0.06,0.24 -0.1,0.06 -0.01,0.2 -0.1,0.26 -0.02,0.13 -0.17,0.14 -0.25,0.21 -0.04,0.08 0.01,0.17 -0.12,0.16 -0.02,0.1 -0.15,0.09 -0.22,0.11 -0.01,0.03 0.01,0.06 0,0.09 z m -2.2,-10e-4 c 0.04,0.12 -0.09,0.08 -0.05,0.2 -0.03,0.11 0.04,0.14 0.05,0.21 -0.01,0.08 0.03,0.2 -0.05,0.21 0.04,0.12 -0.06,0.12 -0.05,0.21 -0.05,0.03 -0.06,0.11 -0.05,0.2 0,0.09 -0.04,0.13 -0.13,0.13 -0.01,-0.06 -0.15,-0.02 -0.14,-0.1 -0.09,10e-4 -0.07,-0.09 -0.15,-0.1 0.02,-0.1 -0.08,-0.08 -0.06,-0.18 0.04,-0.04 0.12,-0.05 0.11,-0.14 0.02,-0.07 -0.04,-0.21 0.03,-0.23 4.4e-4,-0.08 0.17,-0.01 0.13,-0.12 0.02,-0.06 0.11,-0.05 0.11,-0.14 0.03,-0.06 0.08,-0.09 0.05,-0.19 -0.03,-0.11 0.14,-0.04 0.21,-0.06 0,0.03 0,0.07 0,0.1 z"
					}
				}
			}
		}
	);
})(jQuery);