/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks.internal;

import groovy.util.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;
import org.gradle.util.internal.VersionNumber;

public class VisualStudioProjectFile
extends XmlPersistableConfigurationObject {
    private final Transformer<String, File> fileLocationResolver;
    private String gradleCommand = "gradle";
    private VersionNumber visualStudioVersion;

    public VisualStudioProjectFile(XmlTransformer xmlTransformer, Transformer<String, File> fileLocationResolver) {
        super(xmlTransformer);
        this.fileLocationResolver = fileLocationResolver;
    }

    protected String getDefaultResourceName() {
        return "default.vcxproj";
    }

    public void setGradleCommand(String gradleCommand) {
        this.gradleCommand = gradleCommand;
    }

    public void setProjectUuid(String uuid) {
        this.getPropertyGroupForLabel("Globals").appendNode((Object)"ProjectGUID", (Object)uuid);
    }

    public void setVisualStudioVersion(VersionNumber version) {
        this.visualStudioVersion = version;
        this.getXml().attributes().put("ToolsVersion", version.getMajor() >= 12 ? version.getMajor() + ".0" : "4.0");
    }

    public void setSdkVersion(VersionNumber version) {
        this.getPropertyGroupForLabel("Globals").appendNode((Object)"WindowsTargetPlatformVersion", version.getMicro() != 0 ? version : version.getMajor() + "." + version.getMinor());
    }

    public void addSourceFile(File file) {
        this.getItemGroupForLabel("Sources").appendNode((Object)"ClCompile", Collections.singletonMap("Include", this.toPath(file)));
    }

    public void addResource(File file) {
        this.getItemGroupForLabel("References").appendNode((Object)"ResourceCompile", Collections.singletonMap("Include", this.toPath(file)));
    }

    public void addHeaderFile(File file) {
        this.getItemGroupForLabel("Headers").appendNode((Object)"ClInclude", Collections.singletonMap("Include", this.toPath(file)));
    }

    public void addConfiguration(ConfigurationSpec configuration) {
        Node configNode = this.getItemGroupForLabel("ProjectConfigurations").appendNode((Object)"ProjectConfiguration", Collections.singletonMap("Include", configuration.getName()));
        configNode.appendNode((Object)"Configuration", (Object)configuration.configurationName);
        configNode.appendNode((Object)"Platform", (Object)configuration.platformName);
        final String configCondition = "'$(Configuration)|$(Platform)'=='" + configuration.getName() + "'";
        String vsOutputDir = ".vs\\" + configuration.projectName + "\\$(Configuration)\\";
        Node configGroup = VisualStudioProjectFile.appendDirectSibling(this.getImportsForProject("$(VCTargetsPath)\\Microsoft.Cpp.Default.props"), "PropertyGroup", new LinkedHashMap<String, String>(){
            {
                this.put("Label", "Configuration");
                this.put("Condition", configCondition);
            }
        });
        configGroup.appendNode((Object)"ConfigurationType", (Object)configuration.type);
        if (configuration.buildable) {
            configGroup.appendNode((Object)"UseDebugLibraries", (Object)configuration.debuggable);
            configGroup.appendNode((Object)"OutDir", (Object)vsOutputDir);
            configGroup.appendNode((Object)"IntDir", (Object)vsOutputDir);
        }
        if (this.visualStudioVersion.getMajor() > 14) {
            configGroup.appendNode((Object)"PlatformToolset", (Object)"v141");
        } else if (this.visualStudioVersion.getMajor() >= 11) {
            configGroup.appendNode((Object)"PlatformToolset", (Object)("v" + this.visualStudioVersion.getMajor() + "0"));
        }
        String includePath = String.join((CharSequence)";", this.toPath(configuration.buildable ? configuration.includeDirs : Collections.emptySet()));
        Node nMakeGroup = VisualStudioProjectFile.appendDirectSibling(this.getPropertyGroupForLabel("UserMacros"), "PropertyGroup", new LinkedHashMap<String, String>(){
            {
                this.put("Label", "NMakeConfiguration");
                this.put("Condition", configCondition);
            }
        });
        if (configuration.buildable) {
            nMakeGroup.appendNode((Object)"NMakeBuildCommandLine", (Object)(this.gradleCommand + " " + configuration.buildTaskPath));
            nMakeGroup.appendNode((Object)"NMakeCleanCommandLine", (Object)(this.gradleCommand + " " + configuration.cleanTaskPath));
            nMakeGroup.appendNode((Object)"NMakeReBuildCommandLine", (Object)(this.gradleCommand + " " + configuration.cleanTaskPath + " " + configuration.buildTaskPath));
            nMakeGroup.appendNode((Object)"NMakePreprocessorDefinitions", (Object)String.join((CharSequence)";", configuration.compilerDefines));
            nMakeGroup.appendNode((Object)"NMakeIncludeSearchPath", (Object)includePath);
            nMakeGroup.appendNode((Object)"NMakeOutput", (Object)this.toPath(configuration.outputFile));
        } else {
            String errorCommand = "echo '" + configuration.projectName + "' project is not buildable. && exit /b -42";
            nMakeGroup.appendNode((Object)"NMakeBuildCommandLine", (Object)errorCommand);
            nMakeGroup.appendNode((Object)"NMakeCleanCommandLine", (Object)errorCommand);
            nMakeGroup.appendNode((Object)"NMakeReBuildCommandLine", (Object)errorCommand);
        }
        if (configuration.languageStandard != null && configuration.languageStandard != VisualStudioTargetBinary.LanguageStandard.NONE) {
            this.getXml().appendNode((Object)"ItemDefinitionGroup", Collections.singletonMap("Condition", configCondition)).appendNode((Object)"ClCompile").appendNode((Object)"LanguageStandard", (Object)configuration.languageStandard.getValue());
        }
    }

    private Node getItemGroupForLabel(String label) {
        return this.getSingleNodeWithAttribute("ItemGroup", "Label", label);
    }

    private Node getPropertyGroupForLabel(String label) {
        return this.getSingleNodeWithAttribute("PropertyGroup", "Label", label);
    }

    private Node getImportsForProject(String project) {
        return this.getSingleNodeWithAttribute("Import", "Project", project);
    }

    private Node getSingleNodeWithAttribute(String nodeName, String attributeName, String attributeValue) {
        return Objects.requireNonNull(VisualStudioProjectFile.findFirstChildWithAttributeValue((Node)this.getXml(), (String)nodeName, (String)attributeName, (String)attributeValue), "No '" + nodeName + "' with attribute '" + attributeName + " = " + attributeValue + "' found");
    }

    private List<String> toPath(Set<File> files) {
        return files.stream().map(this::toPath).collect(Collectors.toList());
    }

    private String toPath(File file) {
        return (String)this.fileLocationResolver.transform((Object)file);
    }

    private static Node appendDirectSibling(Node node, String siblingName, LinkedHashMap<String, String> siblingAttributes) {
        if (node.parent() == null) {
            throw new UnsupportedOperationException("Adding sibling nodes to the root node is not supported");
        }
        List parentChildren = node.parent().children();
        int afterIndex = parentChildren.indexOf(node);
        ArrayList tail = new ArrayList(parentChildren.subList(afterIndex + 1, parentChildren.size()));
        parentChildren.subList(afterIndex + 1, parentChildren.size()).clear();
        Node sibling = node.parent().appendNode((Object)siblingName, siblingAttributes);
        node.parent().children().addAll(tail);
        return sibling;
    }

    public static class ConfigurationSpec {
        private final String name;
        private final String configurationName;
        private final String projectName;
        private final String platformName;
        private final String type;
        private final boolean buildable;
        private final boolean debuggable;
        private final Set<File> includeDirs;
        private final String buildTaskPath;
        private final String cleanTaskPath;
        private final List<String> compilerDefines;
        private final File outputFile;
        private final VisualStudioTargetBinary.LanguageStandard languageStandard;

        public ConfigurationSpec(String name, String configurationName, String projectName, String platformName, String type, boolean buildable, boolean debuggable, Set<File> includeDirs, @Nullable String buildTaskPath, @Nullable String cleanTaskPath, List<String> compilerDefines, @Nullable File outputFile, @Nullable VisualStudioTargetBinary.LanguageStandard languageStandard) {
            this.name = name;
            this.configurationName = configurationName;
            this.projectName = projectName;
            this.platformName = platformName;
            this.type = type;
            this.buildable = buildable;
            this.debuggable = debuggable;
            this.includeDirs = includeDirs;
            this.buildTaskPath = buildTaskPath;
            this.cleanTaskPath = cleanTaskPath;
            this.compilerDefines = compilerDefines;
            this.outputFile = outputFile;
            this.languageStandard = languageStandard;
        }

        @Input
        public String getName() {
            return this.name;
        }

        @Input
        public String getConfigurationName() {
            return this.configurationName;
        }

        @Input
        public String getProjectName() {
            return this.projectName;
        }

        @Input
        public String getPlatformName() {
            return this.platformName;
        }

        @Input
        public String getType() {
            return this.type;
        }

        @Input
        public boolean isBuildable() {
            return this.buildable;
        }

        @Input
        public boolean isDebuggable() {
            return this.debuggable;
        }

        @Input
        @Optional
        @Nullable
        public String getBuildTaskPath() {
            return this.buildTaskPath;
        }

        @Input
        @Optional
        @Nullable
        public String getCleanTaskPath() {
            return this.cleanTaskPath;
        }

        @Input
        public List<String> getCompilerDefines() {
            return this.compilerDefines;
        }

        @Input
        @Optional
        @Nullable
        public VisualStudioTargetBinary.LanguageStandard getLanguageStandard() {
            return this.languageStandard;
        }

        @Input
        public Collection<String> getIncludeDirPaths() {
            return this.includeDirs.stream().map(File::getAbsolutePath).collect(Collectors.toList());
        }

        @Input
        @Optional
        @Nullable
        public String getOutputFilePath() {
            if (this.outputFile != null) {
                return this.outputFile.getAbsolutePath();
            }
            return null;
        }
    }
}

