/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.query;

import ca.sqlpower.query.Container;
import ca.sqlpower.query.ContainerChildEvent;
import ca.sqlpower.query.ContainerChildListener;
import ca.sqlpower.query.Item;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

public class ItemContainer
implements Container {
    private static final Logger logger = Logger.getLogger(ItemContainer.class);
    private String name;
    private final List<Item> itemList;
    private String alias;
    private Point2D position;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String uuid;
    private final List<ContainerChildListener> childListeners = new ArrayList<ContainerChildListener>();

    public ItemContainer(String name) {
        this(name, null);
    }

    public ItemContainer(String name, String uuid) {
        this.uuid = uuid == null ? "w" + UUID.randomUUID() : uuid;
        this.name = name;
        this.itemList = new ArrayList<Item>();
        logger.debug((Object)"Container created.");
        this.position = new Point(0, 0);
    }

    @Override
    public Object getContainedObject() {
        return Collections.unmodifiableList(this.itemList);
    }

    @Override
    public Item getItem(Object item) {
        for (Item i : this.itemList) {
            if (!i.getItem().equals(item)) continue;
            return i;
        }
        return null;
    }

    @Override
    public void addItem(Item item) {
        this.addItem(item, this.itemList.size());
    }

    @Override
    public void addItem(Item item, int index) {
        this.itemList.add(index, item);
        item.setParent(this);
        this.fireChildAdded(item, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildAdded(Item item, int index) {
        List<ContainerChildListener> list = this.childListeners;
        synchronized (list) {
            for (int i = this.childListeners.size() - 1; i >= 0; --i) {
                this.childListeners.get(i).containerChildAdded(new ContainerChildEvent(this, item, index));
            }
        }
    }

    @Override
    public void removeItem(Item item) {
        int index = this.itemList.indexOf(item);
        this.itemList.remove(item);
        this.fireChildRemoved(item, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildRemoved(Item item, int index) {
        List<ContainerChildListener> list = this.childListeners;
        synchronized (list) {
            for (int i = this.childListeners.size() - 1; i >= 0; --i) {
                this.childListeners.get(i).containerChildRemoved(new ContainerChildEvent(this, item, index));
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Item> getItems() {
        return Collections.unmodifiableList(this.itemList);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        String oldAlias = this.alias;
        this.alias = alias;
        this.pcs.firePropertyChange("alias", oldAlias, alias);
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D position) {
        Point2D oldPosition = this.position;
        this.position = position;
        this.pcs.firePropertyChange("position", oldPosition, position);
    }

    public boolean equals(Object obj) {
        return obj instanceof ItemContainer && ((ItemContainer)obj).getUUID().equals(this.getUUID());
    }

    public int hashCode() {
        return 527 + this.getUUID().hashCode();
    }

    @Override
    public void addChildListener(ContainerChildListener l) {
        this.childListeners.add(l);
    }

    @Override
    public void removeChildListener(ContainerChildListener l) {
        this.childListeners.remove(l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(String id) {
        String oldUUID = this.uuid;
        this.uuid = id;
        this.pcs.firePropertyChange("uuid", oldUUID, id);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Container createCopy() {
        ItemContainer copy = new ItemContainer(this.getName());
        copy.setAlias(this.getAlias());
        copy.setPosition(new Point2D.Double(this.getPosition().getX(), this.getPosition().getY()));
        for (Item item : this.getItems()) {
            copy.addItem(item.createCopy());
        }
        return copy;
    }

    @Override
    public void removeItem(int i) {
        Item removed = this.itemList.remove(i);
        this.fireChildRemoved(removed, i);
    }
}

