"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const m = __importStar(require("../lib/modernExtend"));
const measurementIntervalMin = 5;
const measurementIntervalMax = 4 * 60 * 60;
exports.definitions = [
    {
        zigbeeModel: ["Soil Pro"],
        model: "Soil Pro",
        vendor: "Simpla Home",
        description: "Soil Pro",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, z1_top: 2, z2_bottom: 3 } }),
            m.identify(),
            m.temperature({
                // the device allows to set the internal measurement interval in the specified range
                // the Min/Max reporting interval needs to be aligned in order to synchronize the
                // value reporting interval to the measurements
                reporting: { min: measurementIntervalMin, max: measurementIntervalMax, change: 10 },
            }),
            m.soilMoisture({
                description: "Soil Moisture of Zone 1 (Top Zone)",
                endpointNames: ["z1_top"],
                reporting: { min: measurementIntervalMin, max: measurementIntervalMax, change: 100 },
            }),
            m.soilMoisture({
                description: "Soil Moisture of Zone 2 (Bottom Zone)",
                endpointNames: ["z2_bottom"],
                reporting: { min: measurementIntervalMin, max: measurementIntervalMax, change: 100 },
            }),
            m.battery(),
            m.numeric({
                name: "measurement_interval",
                access: "ALL",
                unit: "s",
                cluster: "genAnalogOutput",
                attribute: "presentValue",
                scale: 1,
                valueMin: measurementIntervalMin,
                valueMax: measurementIntervalMax,
                description: "Defines how often the device performs measurements",
                reporting: { min: measurementIntervalMin, max: measurementIntervalMax, change: 100 },
                entityCategory: "config",
            }),
            m.binary({
                name: "linear_mode",
                cluster: "genBinaryOutput",
                attribute: "presentValue",
                description: "Soil moisture measurement mode: Volumetric Water Content (VWC) (0-45 %) or linear (0-100 %)",
                valueOn: ["linear", 1],
                valueOff: ["VWC", 0],
                access: "ALL",
                entityCategory: "config",
            }),
            m.illuminance({
                reporting: { min: measurementIntervalMin, max: measurementIntervalMax, change: 5 },
            }),
        ],
        meta: { multiEndpoint: true },
        ota: true,
    },
];
//# sourceMappingURL=simpla_home.js.map