/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.openjdk.jmc.common.unit.LongPreOffsetTransform;
import org.openjdk.jmc.common.unit.ScalarQuantity;
import org.openjdk.jmc.common.unit.SimpleAffineTransform;

public abstract class ScaleFactor
implements IScalarAffineTransform,
Comparable<ScaleFactor> {
    @Override
    public final IScalarAffineTransform concat(IScalarAffineTransform innerTransform) {
        if (innerTransform.isUnity()) {
            return this;
        }
        if (innerTransform instanceof ScaleFactor) {
            return this.concat((ScaleFactor)innerTransform);
        }
        if (innerTransform instanceof LongPreOffsetTransform) {
            LongPreOffsetTransform preOT = (LongPreOffsetTransform)innerTransform;
            return new LongPreOffsetTransform(preOT.preOffset, preOT.getMultiplier() * this.getMultiplier());
        }
        return SimpleAffineTransform.createWithPostOffset(innerTransform.getMultiplier() * this.getMultiplier(), this.targetNumber(innerTransform.getOffset()));
    }

    public abstract ScaleFactor concat(ScaleFactor var1);

    @Override
    public final IScalarAffineTransform invertAndConcat(IScalarAffineTransform innerTransform) {
        if (innerTransform instanceof ScaleFactor) {
            return this.invertAndConcat((ScaleFactor)innerTransform);
        }
        return this.invert().concat(innerTransform);
    }

    public ScaleFactor invertAndConcat(ScaleFactor innerFactor) {
        if (this.equals(innerFactor)) {
            return DecimalScaleFactor.get(0);
        }
        return this.invert().concat(innerFactor);
    }

    @Override
    public abstract ScaleFactor invert();

    @Override
    public final Number getOffset() {
        return 0;
    }

    @Override
    public double targetFloor(double srcNumericalValue) {
        return Math.floor(this.targetValue(srcNumericalValue));
    }

    @Override
    public int targetIntFloor(Number srcNumericalValue) {
        if (srcNumericalValue instanceof Long || srcNumericalValue instanceof ScalarQuantity.LongStored) {
            long longRes = this.targetFloor(srcNumericalValue.longValue());
            int intRes = (int)longRes;
            if ((long)intRes != longRes) {
                return longRes >= 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            }
            return intRes;
        }
        return (int)this.targetFloor(srcNumericalValue.doubleValue());
    }

    @Override
    public Number targetNumber(long srcNumericalValue) {
        if (this.isInteger() && !this.targetOutOfRange(srcNumericalValue, Long.MAX_VALUE)) {
            return this.targetValue(srcNumericalValue);
        }
        return this.targetValue((double)srcNumericalValue);
    }

    @Override
    public Number targetNumber(Number srcNumericalValue) {
        if (srcNumericalValue instanceof Long) {
            return this.targetNumber(srcNumericalValue.longValue());
        }
        return this.targetValue(srcNumericalValue.doubleValue());
    }

    @Override
    public int compareTo(ScaleFactor other) {
        return Double.compare(this.getMultiplier(), other.getMultiplier());
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

