/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class MimePathLookup
extends ProxyLookup
implements LookupListener {
    private static final Logger LOG = Logger.getLogger(MimePathLookup.class.getName());
    private static final RequestProcessor WORKER = new RequestProcessor("MimePathLookupFiring", 1);
    private final MimePath mimePath;
    private final boolean mimePathBanned;
    private final Lookup.Result<MimeDataProvider> dataProviders;
    private final Lookup.Result<MimeLookupInitializer> mimeInitializers;
    private boolean initialized = false;

    public MimePathLookup(MimePath mimePath) {
        if (mimePath == null) {
            throw new NullPointerException("Mime path can't be null.");
        }
        this.mimePath = mimePath;
        this.mimePathBanned = mimePath.size() > 0 && mimePath.getMimeType(0).contains("text/base");
        class R
        implements Runnable {
            Lookup.Result<MimeDataProvider> dataProviders;
            Lookup.Result<MimeLookupInitializer> mimeInitializers;

            R() {
            }

            @Override
            public void run() {
                this.dataProviders = Lookup.getDefault().lookup(new Lookup.Template(MimeDataProvider.class));
                this.dataProviders.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)MimePathLookup.this), this.dataProviders));
                this.mimeInitializers = Lookup.getDefault().lookup(new Lookup.Template(MimeLookupInitializer.class));
                this.mimeInitializers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)MimePathLookup.this), this.mimeInitializers));
            }
        }
        R r = new R();
        Lookups.executeWith(null, (Runnable)r);
        this.dataProviders = r.dataProviders;
        this.mimeInitializers = r.mimeInitializers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeLookup(Lookup.Template<?> template) {
        MimePathLookup mimePathLookup = this;
        synchronized (mimePathLookup) {
            if (!this.initialized) {
                this.initialized = true;
                this.rebuild();
            }
        }
    }

    public MimePath getMimePath() {
        return this.mimePath;
    }

    private void rebuild() {
        MimePath mimePath;
        Object object2;
        ArrayList<MimePath> arrayList = new ArrayList<MimePath>();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Rebuilding MimeLookup for '" + this.mimePath.getPath() + "'...");
        }
        for (Object object2 : this.dataProviders.allInstances()) {
            if (this.mimePathBanned && !this.isDefaultProvider((MimeDataProvider)object2)) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("- Querying MimeDataProvider(" + this.mimePath.getPath() + "): " + object2);
            }
            if ((mimePath = object2.getLookup(this.mimePath)) == null) continue;
            arrayList.add(mimePath);
        }
        List<MimePath> list = this.mimePath.getIncludedPaths();
        object2 = list.iterator();
        while (object2.hasNext()) {
            Lookup lookup;
            Object object3;
            mimePath = (MimePath)object2.next();
            Object object4 = this.mimeInitializers.allInstances();
            for (int i = 0; i < mimePath.size(); ++i) {
                object3 = new ArrayList(object4.size());
                lookup = object4.iterator();
                while (lookup.hasNext()) {
                    MimeLookupInitializer mimeLookupInitializer = (MimeLookupInitializer)lookup.next();
                    object3.addAll(mimeLookupInitializer.child(mimePath.getMimeType(i)).allInstances());
                }
                object4 = object3;
            }
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (MimeLookupInitializer)iterator.next();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("- Querying MimeLookupInitializer(" + mimePath.getPath() + "): " + object3);
                }
                if ((lookup = object3.lookup()) == null) continue;
                arrayList.add((MimePath)lookup);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("MimeLookup for '" + this.mimePath.getPath() + "' rebuilt.");
        }
        this.setLookups((Executor)WORKER, arrayList.toArray(new Lookup[0]));
    }

    private boolean isDefaultProvider(MimeDataProvider mimeDataProvider) {
        return mimeDataProvider.getClass().getName().equals("org.netbeans.modules.editor.mimelookup.impl.DefaultMimeDataProvider");
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        this.rebuild();
    }
}

