/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.cloud;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirestoreClient {
    private static final Logger logger = LoggerFactory.getLogger(FirestoreClient.class);
    private final Firestore firestore;
    private static final String SERVICE_ID = FirestoreClient.class.getName();

    private FirestoreClient(FirebaseApp app, String databaseId) {
        Preconditions.checkNotNull((Object)app, (Object)"FirebaseApp must not be null");
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required for accessing Firestore. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        FirestoreOptions userOptions = ImplFirebaseTrampolines.getFirestoreOptions(app);
        FirestoreOptions.Builder builder = userOptions != null ? userOptions.toBuilder() : FirestoreOptions.newBuilder();
        this.firestore = (Firestore)((FirestoreOptions.Builder)builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)ImplFirebaseTrampolines.getCredentials(app))).setProjectId(projectId)).setDatabaseId(databaseId).build().getService();
    }

    @NonNull
    public static Firestore getFirestore() {
        return FirestoreClient.getFirestore(FirebaseApp.getInstance());
    }

    @NonNull
    public static Firestore getFirestore(FirebaseApp app) {
        FirestoreOptions firestoreOptions = ImplFirebaseTrampolines.getFirestoreOptions(app);
        return FirestoreClient.getFirestore(app, firestoreOptions == null ? null : firestoreOptions.getDatabaseId());
    }

    @NonNull
    public static Firestore getFirestore(FirebaseApp app, String database) {
        return FirestoreClient.getInstance((FirebaseApp)app, (String)database).firestore;
    }

    @NonNull
    public static Firestore getFirestore(String database) {
        return FirestoreClient.getFirestore(FirebaseApp.getInstance(), database);
    }

    private static synchronized FirestoreClient getInstance(FirebaseApp app, String database) {
        FirestoreClientService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirestoreClientService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirestoreClientService(app));
        }
        return ((FirestoreInstances)service.getInstance()).get(database);
    }

    private static class FirestoreInstances {
        private final FirebaseApp app;
        private final Map<String, FirestoreClient> clients = Collections.synchronizedMap(new HashMap());

        private FirestoreInstances(FirebaseApp app) {
            this.app = app;
        }

        FirestoreClient get(String databaseId) {
            return this.clients.computeIfAbsent(databaseId, id -> new FirestoreClient(this.app, (String)id));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            Map<String, FirestoreClient> map = this.clients;
            synchronized (map) {
                for (FirestoreClient client : this.clients.values()) {
                    try {
                        client.firestore.close();
                    }
                    catch (Exception e) {
                        logger.warn("Error while closing the Firestore instance", (Throwable)e);
                    }
                }
                this.clients.clear();
            }
        }
    }

    private static class FirestoreClientService
    extends FirebaseService<FirestoreInstances> {
        FirestoreClientService(FirebaseApp app) {
            super(SERVICE_ID, new FirestoreInstances(app));
        }

        @Override
        public void destroy() {
            ((FirestoreInstances)this.instance).destroy();
        }
    }
}

