/*
 * Decompiled with CFR 0.152.
 */
package xsbt;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.xsbt.DelegatingReporter;
import dotty.tools.xsbt.InterfaceCompileFailed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import xsbti.Logger;
import xsbti.Problem;
import xsbti.Reporter;

public class DottydocRunner {
    private final String[] args0;
    private final Logger log;
    private final Reporter delegate;

    public DottydocRunner(String[] stringArray, Logger logger, Reporter reporter) {
        this.args0 = stringArray;
        this.log = logger;
        this.delegate = reporter;
    }

    public void run() {
        this.log.debug(() -> {
            StringBuilder stringBuilder = new StringBuilder("Calling Dottydoc with arguments  (ScaladocInterface):");
            for (String string : this.args0) {
                stringBuilder.append("\n\t");
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        });
        ArrayList<String> arrayList = new ArrayList<String>(this.args0.length);
        for (String string : this.args0) {
            if ((string.endsWith(".scala") || string.endsWith(".java")) && Files.exists(Paths.get(string, new String[0]), new LinkOption[0])) continue;
            arrayList.add(string);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Contexts.FreshContext freshContext = new Contexts.ContextBase().initialCtx().fresh().setReporter((dotty.tools.dotc.reporting.Reporter)new DelegatingReporter(this.delegate, sourceFile -> sourceFile.file().absolutePath()));
        try {
            String string;
            Class<?> clazz = Class.forName("dotty.tools.dottydoc.Main");
            Method method = clazz.getMethod("process", stringArray.getClass(), Contexts.Context.class);
            string = (dotty.tools.dotc.reporting.Reporter)method.invoke(null, stringArray, freshContext);
            if (string.hasErrors()) {
                throw new InterfaceCompileFailed(stringArray, new Problem[0], "DottyDoc Compilation Failed");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

