"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveQueryById = exports.retrieveLiveQueries = void 0;
var _apiendpoints = require("./apiendpoints");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Utility function to fetch query by id and time range
const retrieveQueryById = async (core, dataSourceId, start, end, id, verbose) => {
  const nullResponse = {
    response: {
      top_queries: []
    }
  };
  const params = {
    query: {
      dataSourceId,
      from: start,
      to: end,
      id,
      verbose
    }
  };
  const fetchMetric = async endpoint => {
    try {
      var _response$response;
      const response = await core.http.get(endpoint, params);
      return {
        response: {
          top_queries: Array.isArray(response === null || response === void 0 || (_response$response = response.response) === null || _response$response === void 0 ? void 0 : _response$response.top_queries) ? response.response.top_queries : []
        }
      };
    } catch (error) {
      console.error('Error occurred while fetching the data:', error);
      return nullResponse;
    }
  };
  try {
    const endpoints = [`/api/top_queries/latency`, `/api/top_queries/cpu`, `/api/top_queries/memory`];
    for (const endpoint of endpoints) {
      const result = await fetchMetric(endpoint);
      if (result.response.top_queries.length > 0) {
        const records = result.response.top_queries || [];
        return records.find(q => q.id === id) || null;
      }
    }
    return null;
  } catch (error) {
    console.error('Error retrieving query details:', error);
    return null;
  }
};
exports.retrieveQueryById = retrieveQueryById;
const retrieveLiveQueries = async (core, dataSourceId, wlmGroupId) => {
  const nullResponse = {
    ok: true,
    response: {
      live_queries: []
    }
  };
  const errorResponse = {
    ok: false,
    response: {
      live_queries: []
    }
  };
  try {
    var _core$data, _response$response2;
    const http = dataSourceId && (_core$data = core.data) !== null && _core$data !== void 0 && _core$data.dataSources ? core.data.dataSources.get(dataSourceId) : core.http;
    const options = dataSourceId || wlmGroupId ? {
      query: {
        ...(dataSourceId ? {
          dataSourceId
        } : {}),
        ...(wlmGroupId ? {
          wlmGroupId
        } : {})
      }
    } : undefined;
    const response = await http.get(_apiendpoints.API_ENDPOINTS.LIVE_QUERIES, options);
    const liveQueries = response === null || response === void 0 || (_response$response2 = response.response) === null || _response$response2 === void 0 ? void 0 : _response$response2.live_queries;
    if (Array.isArray(liveQueries)) {
      return response;
    } else {
      console.warn('No live queries found in response');
      return nullResponse;
    }
  } catch (error) {
    console.error('Error retrieving live queries:', error);
    return errorResponse;
  }
};
exports.retrieveLiveQueries = retrieveLiveQueries;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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