"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlPlugin = mlPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Used during the plugin's setup() lifecycle phase to register various client actions
 * representing ML plugin APIs. These are then exposed and used on the
 * server-side when processing node APIs - see server/routes/ml_routes_service
 * for examples.
 */
function mlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.mlClient = components.clientAction.namespaceFactory();
  const mlClient = Client.prototype.mlClient.prototype;
  mlClient.searchModels = ca({
    url: {
      fmt: _common.ML_SEARCH_MODELS_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.searchConnectors = ca({
    url: {
      fmt: _common.ML_SEARCH_CONNECTORS_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.registerAgent = ca({
    url: {
      fmt: _common.ML_REGISTER_AGENT_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.updateAgent = ca({
    url: {
      fmt: `${_common.ML_AGENT_ROUTE_PREFIX}/<%=agent_id%>`,
      req: {
        agent_id: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  mlClient.searchAgents = ca({
    url: {
      fmt: _common.ML_SEARCH_AGENTS_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.getAgent = ca({
    url: {
      fmt: `${_common.ML_AGENT_ROUTE_PREFIX}/<%=agent_id%>`,
      req: {
        agent_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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