"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSelectableTemplateSitewideRenderOptions = exports.euiSelectableTemplateSitewideFormatOptions = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../../icon");
var _avatar = require("../../avatar");
var _highlight = require("../../highlight");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * The generic extension allows consumers to keep their data objects
 * intact without needing to do key lookups when using `renderOption`
 */

var euiSelectableTemplateSitewideFormatOptions = function euiSelectableTemplateSitewideFormatOptions(options) {
  return options.map(function (item) {
    var title = item.label;
    if (item.meta && item.meta.length) {
      title += " \u2022".concat(renderOptionMeta(item.meta, '', true));
    }
    return _objectSpread(_objectSpread({
      key: item.label,
      title: title
    }, item), {}, {
      className: (0, _classnames.default)('euiSelectableTemplateSitewide__listItem', item.className),
      prepend: item.icon ? /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, (0, _extends2.default)({
        color: "subdued",
        size: "l"
      }, item.icon)) : item.prepend,
      append: item.avatar ? /*#__PURE__*/_react.default.createElement(_avatar.EuiAvatar, (0, _extends2.default)({
        type: "space",
        size: "s"
      }, item.avatar)) : item.append
    });
  });
};
exports.euiSelectableTemplateSitewideFormatOptions = euiSelectableTemplateSitewideFormatOptions;
var euiSelectableTemplateSitewideRenderOptions = function euiSelectableTemplateSitewideRenderOptions(option, searchValue) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_highlight.EuiHighlight, {
    className: "euiSelectableTemplateSitewide__listItemTitle",
    search: searchValue
  }, option.label), renderOptionMeta(option.meta, searchValue));
};
exports.euiSelectableTemplateSitewideRenderOptions = euiSelectableTemplateSitewideRenderOptions;
function renderOptionMeta(meta) {
  var searchValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var stringsOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (!meta || meta.length < 1) return;
  var metas = meta.map(function (meta) {
    var text = meta.text,
      highlightSearchString = meta.highlightSearchString,
      className = meta.className,
      rest = (0, _objectWithoutProperties2.default)(meta, ["text", "highlightSearchString", "className"]);
    if (stringsOnly) {
      return " ".concat(text);
    }

    // Start with the base and custom classes
    var metaClasses = (0, _classnames.default)('euiSelectableTemplateSitewide__optionMeta', className);

    // If they provided a type, create the class and append
    if (meta.type) {
      metaClasses = (0, _classnames.default)(["euiSelectableTemplateSitewide__optionMeta--".concat(meta.type)], metaClasses);
    }
    return /*#__PURE__*/_react.default.createElement(_highlight.EuiHighlight, (0, _extends2.default)({
      search: highlightSearchString ? searchValue : '',
      className: metaClasses,
      key: text
    }, rest), text);
  });
  return stringsOnly ? metas : /*#__PURE__*/_react.default.createElement("span", {
    className: "euiSelectableTemplateSitewide__optionMetasList"
  }, metas);
}