/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.settings;

import lombok.Generated;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettings;
import org.opensearch.searchrelevance.stats.events.EventStatsManager;

public class SearchRelevanceSettingsAccessor {
    private volatile boolean isWorkbenchEnabled;
    private volatile boolean isStatsEnabled;
    private volatile int maxQuerySetAllowed;
    private volatile boolean isScheduledExperimentsEnabled;
    private volatile TimeValue scheduledExperimentsTimeout;
    private volatile TimeValue scheduledExperimentsMinimumInterval;

    @Inject
    public SearchRelevanceSettingsAccessor(ClusterService clusterService, Settings settings) {
        this.isWorkbenchEnabled = (Boolean)SearchRelevanceSettings.SEARCH_RELEVANCE_WORKBENCH_ENABLED.get(settings);
        this.isStatsEnabled = (Boolean)SearchRelevanceSettings.SEARCH_RELEVANCE_STATS_ENABLED.get(settings);
        this.maxQuerySetAllowed = (Integer)SearchRelevanceSettings.SEARCH_RELEVANCE_QUERY_SET_MAX_LIMIT.get(settings);
        this.isScheduledExperimentsEnabled = (Boolean)SearchRelevanceSettings.SEARCH_RELEVANCE_SCHEDULED_EXPERIMENTS_ENABLED.get(settings);
        this.scheduledExperimentsTimeout = (TimeValue)SearchRelevanceSettings.SEARCH_RELEVANCE_SCHEDULED_EXPERIMENTS_TIMEOUT.get(settings);
        this.scheduledExperimentsMinimumInterval = (TimeValue)SearchRelevanceSettings.SEARCH_RELEVANCE_SCHEDULED_EXPERIMENTS_MINIMUM_INTERVAL.get(settings);
        this.registerSettingsCallbacks(clusterService);
    }

    private void registerSettingsCallbacks(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchRelevanceSettings.SEARCH_RELEVANCE_WORKBENCH_ENABLED, value -> {
            this.isWorkbenchEnabled = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchRelevanceSettings.SEARCH_RELEVANCE_STATS_ENABLED, value -> {
            if (this.isStatsEnabled && !value.booleanValue()) {
                EventStatsManager.instance().reset();
            }
            this.isStatsEnabled = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchRelevanceSettings.SEARCH_RELEVANCE_QUERY_SET_MAX_LIMIT, value -> {
            this.maxQuerySetAllowed = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchRelevanceSettings.SEARCH_RELEVANCE_SCHEDULED_EXPERIMENTS_ENABLED, value -> {
            this.isScheduledExperimentsEnabled = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchRelevanceSettings.SEARCH_RELEVANCE_SCHEDULED_EXPERIMENTS_TIMEOUT, value -> {
            this.scheduledExperimentsTimeout = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchRelevanceSettings.SEARCH_RELEVANCE_SCHEDULED_EXPERIMENTS_MINIMUM_INTERVAL, value -> {
            this.scheduledExperimentsMinimumInterval = value;
        });
    }

    @Generated
    public boolean isWorkbenchEnabled() {
        return this.isWorkbenchEnabled;
    }

    @Generated
    public boolean isStatsEnabled() {
        return this.isStatsEnabled;
    }

    @Generated
    public int getMaxQuerySetAllowed() {
        return this.maxQuerySetAllowed;
    }

    @Generated
    public boolean isScheduledExperimentsEnabled() {
        return this.isScheduledExperimentsEnabled;
    }

    @Generated
    public TimeValue getScheduledExperimentsTimeout() {
        return this.scheduledExperimentsTimeout;
    }

    @Generated
    public TimeValue getScheduledExperimentsMinimumInterval() {
        return this.scheduledExperimentsMinimumInterval;
    }
}

