/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.httpclient.MLHttpClientFactory;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.threadpool.ThreadPool;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.internal.http.async.SimpleHttpContentPublisher;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

@ToolAnnotation(value="WebSearchTool")
public class WebSearchTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(WebSearchTool.class);
    public static final String TYPE = "WebSearchTool";
    public static final String DEFAULT_DESCRIPTION = "This tool performs a web search using the specified query or fetches the next page of a previous search. It accepts one mandatory argument: `query`, which is a search term used to initiate a new search, and one optional argument: `next_page`, which is a link to retrieve the next set of search results from a previous response. The tool returns the raw documents retrieved from the search engine, along with a `next_page` field for pagination.";
    private static final String USER_AGENT = "OpenSearchWebCrawler/1.0";
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"query\":{\"type\":\"string\",\"description\":\"The search term to query using the configured search engine. This is the primary input used to perform the search.\"},\"next_page\":{\"type\":\"string\",\"description\":\"URL to the next page of search results. If provided, the tool will fetch and return results from this page instead of executing a new search query.\"}},\"required\":[\"query\"]}";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\"type\":\"object\",\"properties\":{\"query\":{\"type\":\"string\",\"description\":\"The search term to query using the configured search engine. This is the primary input used to perform the search.\"},\"next_page\":{\"type\":\"string\",\"description\":\"URL to the next page of search results. If provided, the tool will fetch and return results from this page instead of executing a new search query.\"}},\"required\":[\"query\"]}", "strict", false);
    public static final String NEXT_PAGE = "next_page";
    public static final String ENGINE_ID = "engine_id";
    public static final String OFFSET = "offset";
    public static final String DUCKDUCKGO = "duckduckgo";
    public static final String GOOGLE = "google";
    public static final String BING = "bing";
    public static final String CUSTOM = "custom";
    public static final String ITEMS = "items";
    public static final String ENGINE = "engine";
    public static final String ENDPOINT = "endpoint";
    public static final String API_KEY = "api_key";
    public static final String CUSTOM_API = "custom_api";
    public static final String AUTHORIZATION = "Authorization";
    public static final String TITLE = "title";
    public static final String URL = "url";
    public static final String CONTENT = "content";
    public static final String QUERY = "query";
    public static final String QUESTION = "question";
    public static final String QUERY_KEY = "query_key";
    public static final String LIMIT_KEY = "limit_key";
    public static final String CUSTOM_RES_URL_JSONPATH = "custom_res_url_jsonpath";
    public static final String START = "start";
    private String name = "WebSearchTool";
    private String description = "This tool performs a web search using the specified query or fetches the next page of a previous search. It accepts one mandatory argument: `query`, which is a search term used to initiate a new search, and one optional argument: `next_page`, which is a link to retrieve the next set of search results from a previous response. The tool returns the raw documents retrieved from the search engine, along with a `next_page` field for pagination.";
    private String version;
    private final SdkAsyncHttpClient httpClient = MLHttpClientFactory.getAsyncHttpClient((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(3L), (int)30, (boolean)false);
    private final ThreadPool threadPool;
    private Map<String, Object> attributes;

    public WebSearchTool(ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put("input_schema", DEFAULT_INPUT_SCHEMA);
        this.attributes.put("strict", false);
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
            String query = parameters.getOrDefault(QUERY, (String)parameters.get(QUESTION)).replaceAll(" ", "+");
            String engine = parameters.getOrDefault(ENGINE, GOOGLE);
            String endpoint = parameters.getOrDefault(ENDPOINT, this.getDefaultEndpoint(engine));
            String apiKey = (String)parameters.get(API_KEY);
            String nextPage = (String)parameters.get(NEXT_PAGE);
            String engineId = (String)parameters.get(ENGINE_ID);
            String authorization = (String)parameters.get(AUTHORIZATION);
            String queryKey = parameters.getOrDefault(QUERY_KEY, "q");
            String offsetKey = parameters.getOrDefault("offset_key", OFFSET);
            String limitKey = parameters.getOrDefault(LIMIT_KEY, "limit");
            String customResUrlJsonpath = (String)parameters.get(CUSTOM_RES_URL_JSONPATH);
            this.threadPool.executor("websearch-crawler-threadpool").submit(() -> {
                if (DUCKDUCKGO.equalsIgnoreCase(engine)) {
                    if (nextPage != null) {
                        this.fetchDuckDuckGoResult(nextPage, listener);
                    } else {
                        this.fetchDuckDuckGoResult(this.buildDDGEndpoint(this.getDefaultEndpoint(engine), query), listener);
                    }
                } else {
                    String parsedNextPage;
                    SdkHttpFullRequest.Builder builder = SdkHttpFullRequest.builder().method(SdkHttpMethod.GET);
                    if (GOOGLE.equalsIgnoreCase(engine)) {
                        if (nextPage != null) {
                            builder.uri(nextPage);
                            parsedNextPage = this.buildGoogleNextPage(endpoint, engineId, query, apiKey, nextPage);
                        } else {
                            builder.uri(this.buildGoogleUrl(endpoint, engineId, query, apiKey, 0));
                            parsedNextPage = this.buildGoogleUrl(endpoint, engineId, query, apiKey, 10);
                        }
                    } else if (BING.equalsIgnoreCase(engine)) {
                        if (nextPage != null) {
                            builder.uri(nextPage);
                            parsedNextPage = this.buildBingNextPage(endpoint, query, nextPage);
                        } else {
                            builder.uri(this.buildBingUrl(endpoint, query, 0));
                            parsedNextPage = this.buildBingUrl(endpoint, query, 10);
                        }
                        builder.putHeader("Ocp-Apim-Subscription-Key", apiKey);
                    } else if (CUSTOM.equalsIgnoreCase(engine)) {
                        if (nextPage != null) {
                            builder.uri(nextPage);
                            parsedNextPage = this.buildCustomNextPage(endpoint, nextPage, queryKey, query, offsetKey, limitKey);
                        } else {
                            builder.uri(this.buildCustomUrl(endpoint, queryKey, query, offsetKey, 0, limitKey));
                            parsedNextPage = this.buildCustomUrl(endpoint, queryKey, query, offsetKey, 10, limitKey);
                        }
                        builder.putHeader(AUTHORIZATION, authorization);
                    } else {
                        listener.onFailure((Exception)new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported search engine: %s", engine)));
                        return;
                    }
                    SdkHttpFullRequest getRequest = builder.build();
                    AsyncExecuteRequest executeRequest = AsyncExecuteRequest.builder().request((SdkHttpRequest)getRequest).requestContentPublisher((SdkHttpContentPublisher)new SimpleHttpContentPublisher(getRequest)).responseHandler(new WebSearchResponseHandler(endpoint, authorization, parsedNextPage, engine, customResUrlJsonpath, listener)).build();
                    try {
                        this.httpClient.execute(executeRequest);
                    }
                    catch (Exception e) {
                        log.error("Web search failed!", (Throwable)e);
                        listener.onFailure((Exception)new IllegalStateException(String.format(Locale.ROOT, "Web search failed: %s", e.getMessage())));
                    }
                }
            });
        }
        catch (Exception e) {
            listener.onFailure((Exception)new IllegalStateException(String.format(Locale.ROOT, "Web search failed: %s", e.getMessage())));
        }
    }

    private String buildDDGEndpoint(String endpoint, String query) {
        return String.format(Locale.ROOT, "%s?q=%s", endpoint, query);
    }

    private String buildGoogleNextPage(String endpoint, String engineId, String query, String apiKey, String currentPage) {
        String[] offsetSplit = currentPage.split("&start=");
        int offset = NumberUtils.toInt((String)offsetSplit[1], (int)0) + 10;
        return this.buildGoogleUrl(endpoint, engineId, query, apiKey, offset);
    }

    private String buildGoogleUrl(String endpoint, String engineId, String query, String apiKey, int start) {
        return String.format(Locale.ROOT, "%s?q=%s&cx=%s&key=%s&start=%d", endpoint, query, engineId, apiKey, start);
    }

    private String buildBingNextPage(String endpoint, String query, String currentPage) {
        String[] offsetSplit = currentPage.split("&offset=");
        int offset = NumberUtils.toInt((String)offsetSplit[1], (int)0) + 10;
        return this.buildBingUrl(endpoint, query, offset);
    }

    private String buildCustomNextPage(String endpoint, String currentPage, String queryKey, String query, String offsetKey, String limitKey) {
        String[] pageSplit = currentPage.split(String.format(Locale.ROOT, "&%s=", offsetKey));
        int offsetValue = NumberUtils.toInt((String)pageSplit[1].split("&")[0], (int)0) + 10;
        return this.buildCustomUrl(endpoint, queryKey, query, offsetKey, offsetValue, limitKey);
    }

    private String buildCustomUrl(String endpoint, String queryKey, String query, String offsetKey, int offsetValue, String limitKey) {
        return String.format(Locale.ROOT, "%s?%s=%s&%s=%d&%s=10", endpoint, queryKey, query, offsetKey, offsetValue, limitKey);
    }

    private String getDefaultEndpoint(String engine) {
        return switch (engine.toLowerCase(Locale.ROOT)) {
            case GOOGLE -> "https://customsearch.googleapis.com/customsearch/v1";
            case BING -> "https://api.bing.microsoft.com/v7.0/search";
            case DUCKDUCKGO -> "https://duckduckgo.com/html";
            case CUSTOM -> null;
            default -> throw new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported search engine: %s", engine));
        };
    }

    private String buildBingUrl(String endpoint, String query, int offset) {
        return String.format(Locale.ROOT, "%s?q%s&textFormat=HTML&count=10&offset=%d", endpoint, query, offset);
    }

    private <T> void fetchDuckDuckGoResult(String endpoint, ActionListener<T> listener) {
        try {
            Document doc = Jsoup.connect((String)endpoint).timeout(10000).get();
            Optional<Elements> pageResult = Optional.of(doc).map(x -> x.getElementById("links")).map(x -> x.getElementsByClass("results_links"));
            if (pageResult.isEmpty()) {
                listener.onFailure((Exception)new IllegalStateException("Failed to fetch duckduckgo results!"));
                return;
            }
            String nextPage = this.getDDGNextPageLink(endpoint, doc);
            HashMap<String, Object> results = new HashMap<String, Object>();
            ArrayList<Map<String, String>> crawlResults = new ArrayList<Map<String, String>>();
            for (Element result : pageResult.get()) {
                Optional<Element> elementOptional = Optional.of(result).map(x -> x.getElementsByClass("links_main")).stream().findFirst().map(x -> Objects.requireNonNull(x.first()).getElementsByTag("a").first());
                if (elementOptional.isEmpty()) {
                    listener.onFailure((Exception)new IllegalStateException("Failed to fetch duckduckgo results as no valid link element found!"));
                    return;
                }
                String link = elementOptional.get().attr("href");
                Map<String, String> crawlResult = this.crawlPage(link, null);
                crawlResults.add(crawlResult);
            }
            results.put(NEXT_PAGE, nextPage);
            results.put(ITEMS, crawlResults);
            listener.onResponse((Object)StringUtils.gson.toJson(results));
        }
        catch (IOException e) {
            log.error("Failed to fetch duckduckgo results due to exception!");
            listener.onFailure((Exception)e);
        }
    }

    private String getDDGNextPageLink(String endpoint, Document doc) {
        Element navLinkDiv = doc.select("div.nav-link").first();
        if (navLinkDiv == null) {
            log.warn("Failed to find next page link div for duckduckgo");
            return null;
        }
        Element form = navLinkDiv.selectFirst("form");
        if (form == null) {
            log.warn("Failed to find next page link form for duckduckgo");
            return null;
        }
        String[] urlAndParams = endpoint.split("\\?q");
        if (urlAndParams.length != 2) {
            log.warn("Failed to find next page link url for duckduckgo");
            return null;
        }
        StringBuilder sb = new StringBuilder(urlAndParams[0]);
        Elements inputs = form.select("input:not([type=submit])");
        for (int i = 0; i < inputs.size(); ++i) {
            String name = ((Element)inputs.get(i)).attr("name");
            String value = ((Element)inputs.get(i)).attr("value");
            if ("q".equalsIgnoreCase(name)) {
                value = value.replaceAll(" ", "+");
            }
            if (i == 0) {
                sb.append("?").append(name).append("=").append(value);
                continue;
            }
            sb.append("&").append(name).append("=").append(value);
        }
        return sb.toString();
    }

    public String getType() {
        return TYPE;
    }

    public boolean validate(Map<String, String> parameters) {
        String engine = parameters.get(ENGINE);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)engine)) {
            return false;
        }
        boolean isQueryEmpty = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)parameters.getOrDefault(QUERY, parameters.get(QUESTION)));
        if (isQueryEmpty) {
            log.warn("Query is empty");
            return false;
        }
        boolean isEndpointEmpty = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)parameters.getOrDefault(ENDPOINT, this.getDefaultEndpoint(engine)));
        if (isEndpointEmpty) {
            log.warn("Endpoint is empty");
            return false;
        }
        if (GOOGLE.equalsIgnoreCase(engine)) {
            boolean hasEngineIdAndApiKey;
            boolean bl = hasEngineIdAndApiKey = parameters.containsKey(ENGINE_ID) && !parameters.get(ENGINE_ID).isEmpty() && parameters.containsKey(API_KEY) && !parameters.get(API_KEY).isEmpty();
            if (!hasEngineIdAndApiKey) {
                log.warn("Google searchengine_idor api_key is empty");
                return false;
            }
            return true;
        }
        if (DUCKDUCKGO.equalsIgnoreCase(engine)) {
            return true;
        }
        if (BING.equalsIgnoreCase(engine)) {
            boolean hasApiKey = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)parameters.get(API_KEY));
            if (!hasApiKey) {
                log.warn("Bing search api_key is empty");
                return false;
            }
            return true;
        }
        if (CUSTOM.equalsIgnoreCase(engine)) {
            String customApi = parameters.get(CUSTOM_API);
            String customResUrlJsonpath = parameters.get(CUSTOM_RES_URL_JSONPATH);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)customApi) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)customResUrlJsonpath)) {
                log.warn("custom search API is empty or result json path is empty");
                return false;
            }
            return true;
        }
        log.error("Unsupported search engine: {}", (Object)engine);
        return false;
    }

    public Map<String, String> crawlPage(String url, String authorization) {
        try {
            Connection connection = Jsoup.connect((String)url).timeout(10000).userAgent(USER_AGENT);
            if (authorization != null) {
                connection.header(AUTHORIZATION, authorization);
            }
            Document doc = connection.get();
            Elements parentElements = doc.select("body");
            if (this.isCaptchaOrLoginPage(doc)) {
                log.debug("Skipping {} - CAPTCHA required", (Object)url);
                return null;
            }
            Element bodyElement = (Element)parentElements.getFirst();
            String title = bodyElement.select(TITLE).text();
            String content = bodyElement.text();
            return ImmutableMap.of((Object)URL, (Object)url, (Object)TITLE, (Object)title, (Object)CONTENT, (Object)content);
        }
        catch (Exception e) {
            log.error("Failed to crawl link: {}", (Object)url);
            return null;
        }
    }

    private boolean isCaptchaOrLoginPage(Document doc) {
        String html = doc.html().toLowerCase(Locale.ROOT);
        return !doc.select("input[name*='captcha'], input[id*='captcha']").isEmpty() || !doc.select(".g-recaptcha, div[data-sitekey]").isEmpty() || !doc.select("img[src*='captcha'], img[src*='recaptcha']").isEmpty() || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)html, (CharSequence)"verify you are human") || !doc.select(".h-captcha").isEmpty();
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public SdkAsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    private final class WebSearchResponseHandler<T>
    implements SdkAsyncHttpResponseHandler {
        private final String endpoint;
        private final String authorization;
        private final String parsedNextPage;
        private final String engine;
        private final String customResUrlJsonpath;
        private final ActionListener<T> listener;

        public WebSearchResponseHandler(String endpoint, String authorization, String parsedNextPage, String engine, String customResUrlJsonpath, ActionListener<T> listener) {
            this.endpoint = endpoint;
            this.authorization = authorization;
            this.parsedNextPage = parsedNextPage;
            this.engine = engine;
            this.customResUrlJsonpath = customResUrlJsonpath;
            this.listener = listener;
        }

        public void onHeaders(SdkHttpResponse response) {
            SdkHttpFullResponse sdkResponse = (SdkHttpFullResponse)response;
            log.debug("received response headers: " + String.valueOf(sdkResponse.headers()));
            int statusCode = sdkResponse.statusCode();
            if (statusCode < 200 || statusCode > 300) {
                log.error("Received error from endpoint:{} with status code {}, response headers: {}", (Object)this.endpoint, (Object)statusCode, (Object)sdkResponse.headers());
                this.listener.onFailure((Exception)new OpenSearchStatusException(String.format(Locale.ROOT, "Failed to fetch results from endpoint: %s", this.endpoint), RestStatus.fromCode((int)statusCode), new Object[0]));
            }
        }

        public void onStream(Publisher<ByteBuffer> stream) {
            stream.subscribe((Subscriber)new Subscriber<ByteBuffer>(){
                private final StringBuilder responseBuilder = new StringBuilder();
                private Subscription subscription;

                public void onSubscribe(Subscription subscription) {
                    log.debug("Starting to fetch response...");
                    this.subscription = subscription;
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(ByteBuffer byteBuffer) {
                    this.responseBuilder.append(StandardCharsets.UTF_8.decode(byteBuffer));
                    this.subscription.request(Long.MAX_VALUE);
                }

                public void onError(Throwable throwable) {
                    log.error("Failed to fetch results from endpoint: {}", (Object)WebSearchResponseHandler.this.endpoint, (Object)throwable);
                    WebSearchResponseHandler.this.listener.onFailure((Exception)new RuntimeException(throwable));
                }

                public void onComplete() {
                    log.debug("Successfully fetched results from endpoint: {}", (Object)WebSearchResponseHandler.this.endpoint);
                    WebSearchResponseHandler.this.parseResponse(this.responseBuilder.toString(), WebSearchResponseHandler.this.authorization, WebSearchResponseHandler.this.parsedNextPage, WebSearchResponseHandler.this.engine, WebSearchResponseHandler.this.customResUrlJsonpath, WebSearchResponseHandler.this.listener);
                }
            });
        }

        public void onError(Throwable error) {
            log.error("Failed to fetch results from endpoint: {}", (Object)this.endpoint, (Object)error);
            this.listener.onFailure((Exception)new RuntimeException(error));
        }

        private <T> void parseResponse(String rawResponse, String authorization, String nextPage, String engine, String customResUrlJsonpath, ActionListener<T> listener) {
            JsonObject rawJson = JsonParser.parseString((String)rawResponse).getAsJsonObject();
            switch (engine.toLowerCase(Locale.ROOT)) {
                case "google": {
                    this.parseGoogleResults(rawJson, nextPage, listener);
                    break;
                }
                case "bing": {
                    this.parseBingResults(rawJson, nextPage, listener);
                    break;
                }
                case "custom": {
                    List urls = (List)JsonPath.read((String)rawResponse, (String)customResUrlJsonpath, (Predicate[])new Predicate[0]);
                    this.parseCustomResults(urls, authorization, nextPage, listener);
                    break;
                }
                default: {
                    listener.onFailure((Exception)new RuntimeException(String.format(Locale.ROOT, "Unsupported search engine: %s", engine)));
                }
            }
        }

        private <T> void parseGoogleResults(JsonObject googleResponse, String nextPage, ActionListener<T> listener) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put(WebSearchTool.NEXT_PAGE, nextPage);
            JsonArray items = googleResponse.getAsJsonArray(WebSearchTool.ITEMS);
            ArrayList<Map<String, String>> crawlResults = new ArrayList<Map<String, String>>();
            for (int i = 0; i < items.size(); ++i) {
                JsonObject item = items.get(i).getAsJsonObject();
                String link = item.get("link").getAsString();
                Map<String, String> crawlResult = WebSearchTool.this.crawlPage(link, null);
                crawlResults.add(crawlResult);
            }
            results.put(WebSearchTool.ITEMS, crawlResults);
            listener.onResponse((Object)StringUtils.gson.toJson(results));
        }

        private <T> void parseBingResults(JsonObject bingResponse, String nextPage, ActionListener<T> listener) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put(WebSearchTool.NEXT_PAGE, nextPage);
            ArrayList<Map<String, String>> crawlResults = new ArrayList<Map<String, String>>();
            JsonArray values = bingResponse.get("webPages").getAsJsonObject().getAsJsonArray("value");
            for (int i = 0; i < values.size(); ++i) {
                JsonObject value = values.get(i).getAsJsonObject();
                String link = value.get(WebSearchTool.URL).getAsString();
                Map<String, String> crawlResult = WebSearchTool.this.crawlPage(link, null);
                crawlResults.add(crawlResult);
            }
            results.put(WebSearchTool.ITEMS, crawlResults);
            listener.onResponse((Object)StringUtils.gson.toJson(results));
        }

        private <T> void parseCustomResults(List<String> urls, String authorization, String nextPage, ActionListener<T> listener) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put(WebSearchTool.NEXT_PAGE, nextPage);
            ArrayList<Map<String, String>> crawlResults = new ArrayList<Map<String, String>>();
            for (int i = 0; i < urls.size(); ++i) {
                String link = urls.get(i);
                Map<String, String> crawlResult = WebSearchTool.this.crawlPage(link, authorization);
                crawlResults.add(crawlResult);
            }
            results.put(WebSearchTool.ITEMS, crawlResults);
            listener.onResponse((Object)StringUtils.gson.toJson(results));
        }
    }

    public static class Factory
    implements Tool.Factory<WebSearchTool> {
        private static Factory INSTANCE;
        private ThreadPool threadPool;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Factory getInstance() {
            if (INSTANCE != null) return INSTANCE;
            Class<WebSearchTool> clazz = WebSearchTool.class;
            synchronized (WebSearchTool.class) {
                if (INSTANCE != null) return INSTANCE;
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        public WebSearchTool create(Map<String, Object> map) {
            return new WebSearchTool(this.threadPool);
        }

        public String getDefaultDescription() {
            return WebSearchTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return WebSearchTool.TYPE;
        }

        public String getDefaultVersion() {
            return "1.0";
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }
    }
}

