/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.ad.client.AnomalyDetectionNodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="SearchAnomalyResultsTool")
public class SearchAnomalyResultsTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchAnomalyResultsTool.class);
    public static final String TYPE = "SearchAnomalyResultsTool";
    private static final String DEFAULT_DESCRIPTION = "This is a tool that searches anomaly results. It takes 9 arguments named detectorId which defines the detector ID to filter for (default is null), and realtime which defines whether the anomaly results are from a realtime detector (set to false to only get results from historical analyses) (default is null), and anomalyGradeThreshold which defines the threshold for anomaly grade (a number between 0 and 1 that indicates how anomalous a data point is) (default is greater than 0), and dataStartTime which defines the start time of the anomaly data in epoch milliseconds (default is null), and dataEndTime which defines the end time of the anomaly data in epoch milliseconds (default is null), and sortOrder which defines the order of the results (options are asc or desc, and default is desc), and sortString which defines how to sort the results (default is data_start_time), and size which defines the number of anomalies to be returned (default is 20), and startIndex which defines the paginated index to start from (default is 0). The tool returns 2 values: a list of anomaly results (where each result contains the detector ID, the anomaly grade, and the confidence), and the total number of anomaly results.";
    private String name = "SearchAnomalyResultsTool";
    private String description = "This is a tool that searches anomaly results. It takes 9 arguments named detectorId which defines the detector ID to filter for (default is null), and realtime which defines whether the anomaly results are from a realtime detector (set to false to only get results from historical analyses) (default is null), and anomalyGradeThreshold which defines the threshold for anomaly grade (a number between 0 and 1 that indicates how anomalous a data point is) (default is greater than 0), and dataStartTime which defines the start time of the anomaly data in epoch milliseconds (default is null), and dataEndTime which defines the end time of the anomaly data in epoch milliseconds (default is null), and sortOrder which defines the order of the results (options are asc or desc, and default is desc), and sortString which defines how to sort the results (default is data_start_time), and size which defines the number of anomalies to be returned (default is 20), and startIndex which defines the paginated index to start from (default is 0). The tool returns 2 values: a list of anomaly results (where each result contains the detector ID, the anomaly grade, and the confidence), and the total number of anomaly results.";
    private String version;
    private Client client;
    private AnomalyDetectionNodeClient adClient;
    private Parser<?, ?> inputParser;
    private Parser<?, ?> outputParser;
    private Map<String, Object> attributes;

    public SearchAnomalyResultsTool(Client client, NamedWriteableRegistry namedWriteableRegistry) {
        this.client = client;
        this.adClient = new AnomalyDetectionNodeClient(client, namedWriteableRegistry);
        this.outputParser = new Parser<Object, Object>(this){

            public Object parse(Object o) {
                List mlModelOutputs = (List)o;
                return ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap().get("response");
            }
        };
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
        String detectorId = parameters.getOrDefault("detectorId", null);
        Boolean realTime = parameters.containsKey("realTime") ? Boolean.valueOf(Boolean.parseBoolean((String)parameters.get("realTime"))) : null;
        Double anomalyGradeThreshold = parameters.containsKey("anomalyGradeThreshold") ? Double.parseDouble((String)parameters.get("anomalyGradeThreshold")) : 0.0;
        Long dataStartTime = parameters.containsKey("dataStartTime") && StringUtils.isNumeric((CharSequence)((CharSequence)parameters.get("dataStartTime"))) ? Long.valueOf(Long.parseLong((String)parameters.get("dataStartTime"))) : null;
        Long dataEndTime = parameters.containsKey("dataEndTime") && StringUtils.isNumeric((CharSequence)((CharSequence)parameters.get("dataEndTime"))) ? Long.valueOf(Long.parseLong((String)parameters.get("dataEndTime"))) : null;
        String sortOrderStr = parameters.getOrDefault("sortOrder", "asc");
        SortOrder sortOrder = sortOrderStr.equalsIgnoreCase("asc") ? SortOrder.ASC : SortOrder.DESC;
        String sortString = parameters.getOrDefault("sortString", "data_start_time");
        int size = parameters.containsKey("size") ? Integer.parseInt((String)parameters.get("size")) : 20;
        int startIndex = parameters.containsKey("startIndex") ? Integer.parseInt((String)parameters.get("startIndex")) : 0;
        ArrayList<Object> mustList = new ArrayList<Object>();
        if (detectorId != null) {
            mustList.add(new TermQueryBuilder("detector_id", detectorId));
        }
        if (realTime != null) {
            BoolQueryBuilder boolQuery = new BoolQueryBuilder();
            ExistsQueryBuilder existsQuery = new ExistsQueryBuilder("task_id");
            if (realTime.booleanValue()) {
                boolQuery.mustNot((QueryBuilder)existsQuery);
            } else {
                boolQuery.must((QueryBuilder)existsQuery);
            }
            mustList.add(boolQuery);
        }
        if (anomalyGradeThreshold != null) {
            mustList.add(new RangeQueryBuilder("anomaly_grade").gt((Object)anomalyGradeThreshold));
        }
        if (dataStartTime != null || dataEndTime != null) {
            RangeQueryBuilder rangeQuery = new RangeQueryBuilder("anomaly_grade");
            if (dataStartTime != null) {
                rangeQuery.gte((Object)dataStartTime);
            }
            if (dataEndTime != null) {
                rangeQuery.lte((Object)dataEndTime);
            }
            mustList.add(rangeQuery);
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must().addAll(mustList);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).size(size).from(startIndex).sort(sortString, sortOrder);
        SearchRequest searchAnomalyResultsRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{".opendistro-anomaly-results*"});
        ActionListener searchAnomalyResultsListener = ActionListener.wrap(response -> this.processHits(response.getHits(), listener), e -> {
            if (e instanceof IndexNotFoundException) {
                this.processHits(SearchHits.empty(), listener);
            } else {
                log.error("Failed to search anomaly results.", (Throwable)e);
                listener.onFailure(e);
            }
        });
        this.adClient.searchAnomalyResults(searchAnomalyResultsRequest, searchAnomalyResultsListener);
    }

    public boolean validate(Map<String, String> parameters) {
        return true;
    }

    public String getType() {
        return TYPE;
    }

    private <T> void processHits(SearchHits searchHits, ActionListener<T> listener) {
        SearchHit[] hits = searchHits.getHits();
        StringBuilder sb = new StringBuilder();
        sb.append("AnomalyResults=[");
        for (SearchHit hit : hits) {
            sb.append("{");
            sb.append("detectorId=").append(hit.getSourceAsMap().get("detector_id")).append(",");
            sb.append("grade=").append(hit.getSourceAsMap().get("anomaly_grade")).append(",");
            sb.append("confidence=").append(hit.getSourceAsMap().get("confidence"));
            sb.append("}");
        }
        sb.append("]");
        sb.append("TotalAnomalyResults=").append(searchHits.getTotalHits().value());
        listener.onResponse((Object)sb.toString());
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser<?, ?> outputParser) {
        this.outputParser = outputParser;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public static class Factory
    implements Tool.Factory<SearchAnomalyResultsTool> {
        private Client client;
        private NamedWriteableRegistry namedWriteableRegistry;
        private AnomalyDetectionNodeClient adClient;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<SearchAnomalyResultsTool> clazz = SearchAnomalyResultsTool.class;
            synchronized (SearchAnomalyResultsTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, NamedWriteableRegistry namedWriteableRegistry) {
            this.client = client;
            this.namedWriteableRegistry = namedWriteableRegistry;
            this.adClient = new AnomalyDetectionNodeClient(client, namedWriteableRegistry);
        }

        public SearchAnomalyResultsTool create(Map<String, Object> map) {
            return new SearchAnomalyResultsTool(this.client, this.namedWriteableRegistry);
        }

        public String getDefaultDescription() {
            return SearchAnomalyResultsTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return SearchAnomalyResultsTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

