/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Hashtable;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.io.ModbusUDPTransport;
import net.wimpi.modbus.io.ModbusUDPTransportFactory;
import net.wimpi.modbus.net.UDPTerminal;
import net.wimpi.modbus.util.LinkedQueue;
import net.wimpi.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPSlaveTerminal
implements UDPTerminal {
    private static final Logger logger = LoggerFactory.getLogger(UDPSlaveTerminal.class);
    public static final int DEFAULT_DEACTIVATION_WAIT_MILLIS = 100;
    private DatagramSocket m_Socket;
    private int m_Timeout = 3000;
    private boolean m_Active;
    protected InetAddress m_LocalAddress;
    private int m_LocalPort = 502;
    protected ModbusTransport m_ModbusTransport;
    private int m_Retries = 3;
    private LinkedQueue m_SendQueue;
    private LinkedQueue m_ReceiveQueue;
    private PacketSender m_PacketSender;
    private PacketReceiver m_PacketReceiver;
    private Thread m_Receiver;
    private Thread m_Sender;
    protected Hashtable m_Requests;
    private ModbusUDPTransportFactory m_TransportFactory;
    private int m_DeactivationWaitMillis = 100;

    public UDPSlaveTerminal() {
        this(null);
    }

    public UDPSlaveTerminal(InetAddress localaddress) {
        this(localaddress, new ModbusUDPTransportFactoryImpl(), 100);
    }

    public UDPSlaveTerminal(InetAddress localaddress, ModbusUDPTransportFactory transportFactory, int deactivationWaitMillis) {
        this.m_LocalAddress = localaddress;
        this.m_TransportFactory = transportFactory;
        this.m_DeactivationWaitMillis = deactivationWaitMillis;
        this.m_SendQueue = new LinkedQueue();
        this.m_ReceiveQueue = new LinkedQueue();
        this.m_Requests = new Hashtable(342);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.m_LocalAddress;
    }

    @Override
    public int getLocalPort() {
        return this.m_LocalPort;
    }

    public void setLocalPort(int port) {
        this.m_LocalPort = port;
    }

    @Override
    public boolean isActive() {
        return this.m_Active;
    }

    @Override
    public synchronized void activate() throws Exception {
        if (!this.isActive()) {
            logger.debug("UDPSlaveTerminal::activate()");
            if (this.m_Socket == null) {
                if (this.m_LocalAddress != null && this.m_LocalPort != -1) {
                    this.m_Socket = new DatagramSocket(this.m_LocalPort, this.m_LocalAddress);
                } else {
                    this.m_Socket = new DatagramSocket();
                    this.m_LocalPort = this.m_Socket.getLocalPort();
                    this.m_LocalAddress = this.m_Socket.getLocalAddress();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("UDPSlaveTerminal::haveSocket():{}", (Object)this.m_Socket.toString());
                logger.debug("UDPSlaveTerminal::addr=:{}:port={}", (Object)this.m_LocalAddress.toString(), (Object)this.m_LocalPort);
            }
            this.m_Socket.setReceiveBufferSize(1024);
            this.m_Socket.setSendBufferSize(1024);
            this.m_PacketReceiver = new PacketReceiver();
            this.m_Receiver = new Thread(this.m_PacketReceiver);
            this.m_Receiver.start();
            logger.debug("UDPSlaveTerminal::receiver started()");
            this.m_PacketSender = new PacketSender();
            this.m_Sender = new Thread(this.m_PacketSender);
            this.m_Sender.start();
            logger.debug("UDPSlaveTerminal::sender started()");
            this.m_ModbusTransport = this.m_TransportFactory.create(this);
            logger.debug("UDPSlaveTerminal::transport created");
            this.m_Active = true;
        }
        logger.info("UDPSlaveTerminal::activated");
    }

    @Override
    public void deactivate() {
        try {
            if (this.m_Active) {
                this.m_PacketReceiver.stop();
                this.m_Receiver.join(this.m_DeactivationWaitMillis);
                this.m_Receiver.interrupt();
                this.m_PacketSender.stop();
                this.m_Sender.join(this.m_DeactivationWaitMillis);
                this.m_Sender.interrupt();
                this.m_Socket.close();
                this.m_ModbusTransport = null;
                this.m_Active = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public ModbusTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    protected boolean hasResponse() {
        return !this.m_ReceiveQueue.isEmpty();
    }

    public DatagramSocket getSocket() {
        return this.m_Socket;
    }

    protected void setSocket(DatagramSocket sock) {
        this.m_Socket = sock;
    }

    @Override
    public void sendMessage(byte[] msg) throws Exception {
        this.m_SendQueue.put(msg);
    }

    @Override
    public byte[] receiveMessage() throws Exception {
        return (byte[])this.m_ReceiveQueue.take();
    }

    class PacketReceiver
    implements Runnable {
        private boolean m_Continue = true;

        @Override
        public void run() {
            do {
                try {
                    byte[] buffer = new byte[256];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    UDPSlaveTerminal.this.m_Socket.receive(packet);
                    Integer tid = new Integer(ModbusUtil.registersToInt(buffer));
                    UDPSlaveTerminal.this.m_Requests.put(tid, packet);
                    UDPSlaveTerminal.this.m_ReceiveQueue.put(buffer);
                    logger.trace("Received package placed in queue");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } while (this.m_Continue);
        }

        public void stop() {
            this.m_Continue = false;
        }
    }

    class PacketSender
    implements Runnable {
        private boolean m_Continue = true;

        @Override
        public void run() {
            do {
                try {
                    byte[] message = (byte[])UDPSlaveTerminal.this.m_SendQueue.take();
                    DatagramPacket req = (DatagramPacket)UDPSlaveTerminal.this.m_Requests.remove(new Integer(ModbusUtil.registersToInt(message)));
                    DatagramPacket res = new DatagramPacket(message, message.length, req.getAddress(), req.getPort());
                    UDPSlaveTerminal.this.m_Socket.send(res);
                    logger.trace("Sent package from queue");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } while (this.m_Continue || !UDPSlaveTerminal.this.m_SendQueue.isEmpty());
        }

        public void stop() {
            this.m_Continue = false;
        }
    }

    public static class ModbusUDPTransportFactoryImpl
    implements ModbusUDPTransportFactory {
        @Override
        public ModbusTransport create(UDPTerminal terminal) {
            return new ModbusUDPTransport(terminal);
        }
    }
}

