/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;

public final class ApplicationMessage
implements DTLSMessage {
    private final byte[] data;

    public ApplicationMessage(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data must not be null!");
        }
        this.data = data;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_DATA;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        if (indent > 0) {
            sb.append(StringUtil.indentation((int)indent));
        }
        sb.append("Application Data: ").append(StringUtil.byteArray2HexString((byte[])this.data, (char)'\u0000', (int)32));
        if (indent > 0) {
            sb.append(StringUtil.lineSeparator());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public byte[] toByteArray() {
        return this.data;
    }

    public static DTLSMessage fromByteArray(byte[] byteArray) {
        return new ApplicationMessage(byteArray);
    }

    public byte[] getData() {
        return this.data;
    }
}

