/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkOffset2D;

public class VkRectLayerKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;
    public static final int LAYER;

    public VkRectLayerKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRectLayerKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkOffset2D offset() {
        return VkRectLayerKHR.noffset(this.address());
    }

    public VkExtent2D extent() {
        return VkRectLayerKHR.nextent(this.address());
    }

    @NativeType(value="uint32_t")
    public int layer() {
        return VkRectLayerKHR.nlayer(this.address());
    }

    public VkRectLayerKHR offset(VkOffset2D value) {
        VkRectLayerKHR.noffset(this.address(), value);
        return this;
    }

    public VkRectLayerKHR offset(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public VkRectLayerKHR extent(VkExtent2D value) {
        VkRectLayerKHR.nextent(this.address(), value);
        return this;
    }

    public VkRectLayerKHR extent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkRectLayerKHR layer(@NativeType(value="uint32_t") int value) {
        VkRectLayerKHR.nlayer(this.address(), value);
        return this;
    }

    public VkRectLayerKHR set(VkOffset2D offset, VkExtent2D extent, int layer) {
        this.offset(offset);
        this.extent(extent);
        this.layer(layer);
        return this;
    }

    public VkRectLayerKHR set(VkRectLayerKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRectLayerKHR malloc() {
        return (VkRectLayerKHR)VkRectLayerKHR.wrap(VkRectLayerKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkRectLayerKHR calloc() {
        return (VkRectLayerKHR)VkRectLayerKHR.wrap(VkRectLayerKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkRectLayerKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkRectLayerKHR)VkRectLayerKHR.wrap(VkRectLayerKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkRectLayerKHR create(long address) {
        return (VkRectLayerKHR)VkRectLayerKHR.wrap(VkRectLayerKHR.class, (long)address);
    }

    @Nullable
    public static VkRectLayerKHR createSafe(long address) {
        return address == 0L ? null : (VkRectLayerKHR)VkRectLayerKHR.wrap(VkRectLayerKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkRectLayerKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkRectLayerKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkRectLayerKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRectLayerKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkRectLayerKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkRectLayerKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkRectLayerKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkRectLayerKHR mallocStack() {
        return VkRectLayerKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRectLayerKHR callocStack() {
        return VkRectLayerKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRectLayerKHR mallocStack(MemoryStack stack) {
        return VkRectLayerKHR.malloc(stack);
    }

    @Deprecated
    public static VkRectLayerKHR callocStack(MemoryStack stack) {
        return VkRectLayerKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkRectLayerKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkRectLayerKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRectLayerKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRectLayerKHR.calloc(capacity, stack);
    }

    public static VkRectLayerKHR malloc(MemoryStack stack) {
        return (VkRectLayerKHR)VkRectLayerKHR.wrap(VkRectLayerKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRectLayerKHR calloc(MemoryStack stack) {
        return (VkRectLayerKHR)VkRectLayerKHR.wrap(VkRectLayerKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkRectLayerKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkRectLayerKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkOffset2D noffset(long struct) {
        return VkOffset2D.create(struct + (long)OFFSET);
    }

    public static VkExtent2D nextent(long struct) {
        return VkExtent2D.create(struct + (long)EXTENT);
    }

    public static int nlayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYER);
    }

    public static void noffset(long struct, VkOffset2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)VkOffset2D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)VkExtent2D.SIZEOF);
    }

    public static void nlayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYER, value);
    }

    static {
        Struct.Layout layout = VkRectLayerKHR.__struct((Struct.Member[])new Struct.Member[]{VkRectLayerKHR.__member((int)VkOffset2D.SIZEOF, (int)VkOffset2D.ALIGNOF), VkRectLayerKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkRectLayerKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
        LAYER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkRectLayerKHR, Buffer>
    implements NativeResource {
        private static final VkRectLayerKHR ELEMENT_FACTORY = VkRectLayerKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkRectLayerKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkOffset2D offset() {
            return VkRectLayerKHR.noffset(this.address());
        }

        public VkExtent2D extent() {
            return VkRectLayerKHR.nextent(this.address());
        }

        @NativeType(value="uint32_t")
        public int layer() {
            return VkRectLayerKHR.nlayer(this.address());
        }

        public Buffer offset(VkOffset2D value) {
            VkRectLayerKHR.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(VkExtent2D value) {
            VkRectLayerKHR.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        public Buffer layer(@NativeType(value="uint32_t") int value) {
            VkRectLayerKHR.nlayer(this.address(), value);
            return this;
        }
    }
}

