/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGCachedMeasurement;
import org.lwjgl.util.yoga.YGFloatOptional;

public class YGLayout
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITIONS;
    public static final int DIMENSIONS;
    public static final int MARGIN;
    public static final int BORDER;
    public static final int PADDING;
    public static final int FLAGS;
    public static final int COMPUTEDFLEXBASISGENERATION;
    public static final int COMPUTEDFLEXBASIS;
    public static final int GENERATIONCOUNT;
    public static final int LASTOWNERDIRECTION;
    public static final int NEXTCACHEDMEASUREMENTSINDEX;
    public static final int CACHEDMEASUREMENTS;
    public static final int MEASUREDDIMENSIONS;
    public static final int CACHEDLAYOUT;

    public YGLayout(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGLayout.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[4]")
    public FloatBuffer positions() {
        return YGLayout.npositions(this.address());
    }

    public float positions(int index) {
        return YGLayout.npositions(this.address(), index);
    }

    @NativeType(value="float[2]")
    public FloatBuffer dimensions() {
        return YGLayout.ndimensions(this.address());
    }

    public float dimensions(int index) {
        return YGLayout.ndimensions(this.address(), index);
    }

    @NativeType(value="float[4]")
    public FloatBuffer margin() {
        return YGLayout.nmargin(this.address());
    }

    public float margin(int index) {
        return YGLayout.nmargin(this.address(), index);
    }

    @NativeType(value="float[4]")
    public FloatBuffer border() {
        return YGLayout.nborder(this.address());
    }

    public float border(int index) {
        return YGLayout.nborder(this.address(), index);
    }

    @NativeType(value="float[4]")
    public FloatBuffer padding() {
        return YGLayout.npadding(this.address());
    }

    public float padding(int index) {
        return YGLayout.npadding(this.address(), index);
    }

    @NativeType(value="YGDirection")
    public int direction() {
        return YGLayout.ndirection(this.address());
    }

    @NativeType(value="bool")
    public boolean didUseLegacyFlag() {
        return YGLayout.ndidUseLegacyFlag(this.address());
    }

    @NativeType(value="bool")
    public boolean doesLegacyStretchFlagAffectsLayout() {
        return YGLayout.ndoesLegacyStretchFlagAffectsLayout(this.address());
    }

    @NativeType(value="bool")
    public boolean hadOverflow() {
        return YGLayout.nhadOverflow(this.address());
    }

    @NativeType(value="uint32_t")
    public int computedFlexBasisGeneration() {
        return YGLayout.ncomputedFlexBasisGeneration(this.address());
    }

    public YGFloatOptional computedFlexBasis() {
        return YGLayout.ncomputedFlexBasis(this.address());
    }

    @NativeType(value="uint32_t")
    public int generationCount() {
        return YGLayout.ngenerationCount(this.address());
    }

    @NativeType(value="YGDirection")
    public int lastOwnerDirection() {
        return YGLayout.nlastOwnerDirection(this.address());
    }

    @NativeType(value="uint32_t")
    public int nextCachedMeasurementsIndex() {
        return YGLayout.nnextCachedMeasurementsIndex(this.address());
    }

    @NativeType(value="YGCachedMeasurement[16]")
    public YGCachedMeasurement.Buffer cachedMeasurements() {
        return YGLayout.ncachedMeasurements(this.address());
    }

    public YGCachedMeasurement cachedMeasurements(int index) {
        return YGLayout.ncachedMeasurements(this.address(), index);
    }

    @NativeType(value="float[2]")
    public FloatBuffer measuredDimensions() {
        return YGLayout.nmeasuredDimensions(this.address());
    }

    public float measuredDimensions(int index) {
        return YGLayout.nmeasuredDimensions(this.address(), index);
    }

    public YGCachedMeasurement cachedLayout() {
        return YGLayout.ncachedLayout(this.address());
    }

    public static YGLayout create(long address) {
        return (YGLayout)YGLayout.wrap(YGLayout.class, (long)address);
    }

    @Nullable
    public static YGLayout createSafe(long address) {
        return address == 0L ? null : (YGLayout)YGLayout.wrap(YGLayout.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)YGLayout.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)YGLayout.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static FloatBuffer npositions(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)POSITIONS), (int)4);
    }

    public static float npositions(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)POSITIONS + Checks.check((int)index, (int)4) * 4L);
    }

    public static FloatBuffer ndimensions(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)DIMENSIONS), (int)2);
    }

    public static float ndimensions(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)DIMENSIONS + Checks.check((int)index, (int)2) * 4L);
    }

    public static FloatBuffer nmargin(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)MARGIN), (int)4);
    }

    public static float nmargin(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)MARGIN + Checks.check((int)index, (int)4) * 4L);
    }

    public static FloatBuffer nborder(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)BORDER), (int)4);
    }

    public static float nborder(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)BORDER + Checks.check((int)index, (int)4) * 4L);
    }

    public static FloatBuffer npadding(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)PADDING), (int)4);
    }

    public static float npadding(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)PADDING + Checks.check((int)index, (int)4) * 4L);
    }

    public static byte nflags(long struct) {
        return UNSAFE.getByte(null, struct + (long)FLAGS);
    }

    public static int ndirection(long struct) {
        return YGLayout.nflags(struct) & 3;
    }

    public static boolean ndidUseLegacyFlag(long struct) {
        return (YGLayout.nflags(struct) >>> 2 & 1) != 0;
    }

    public static boolean ndoesLegacyStretchFlagAffectsLayout(long struct) {
        return (YGLayout.nflags(struct) >>> 3 & 1) != 0;
    }

    public static boolean nhadOverflow(long struct) {
        return (YGLayout.nflags(struct) >>> 4 & 1) != 0;
    }

    public static int ncomputedFlexBasisGeneration(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPUTEDFLEXBASISGENERATION);
    }

    public static YGFloatOptional ncomputedFlexBasis(long struct) {
        return YGFloatOptional.create(struct + (long)COMPUTEDFLEXBASIS);
    }

    public static int ngenerationCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)GENERATIONCOUNT);
    }

    public static int nlastOwnerDirection(long struct) {
        return UNSAFE.getInt(null, struct + (long)LASTOWNERDIRECTION);
    }

    public static int nnextCachedMeasurementsIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)NEXTCACHEDMEASUREMENTSINDEX);
    }

    public static YGCachedMeasurement.Buffer ncachedMeasurements(long struct) {
        return YGCachedMeasurement.create(struct + (long)CACHEDMEASUREMENTS, 16);
    }

    public static YGCachedMeasurement ncachedMeasurements(long struct, int index) {
        return YGCachedMeasurement.create(struct + (long)CACHEDMEASUREMENTS + Checks.check((int)index, (int)16) * (long)YGCachedMeasurement.SIZEOF);
    }

    public static FloatBuffer nmeasuredDimensions(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)MEASUREDDIMENSIONS), (int)2);
    }

    public static float nmeasuredDimensions(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)MEASUREDDIMENSIONS + Checks.check((int)index, (int)2) * 4L);
    }

    public static YGCachedMeasurement ncachedLayout(long struct) {
        return YGCachedMeasurement.create(struct + (long)CACHEDLAYOUT);
    }

    static {
        Struct.Layout layout = YGLayout.__struct((Struct.Member[])new Struct.Member[]{YGLayout.__array((int)4, (int)4), YGLayout.__array((int)4, (int)2), YGLayout.__array((int)4, (int)4), YGLayout.__array((int)4, (int)4), YGLayout.__array((int)4, (int)4), YGLayout.__member((int)1), YGLayout.__member((int)4), YGLayout.__member((int)YGFloatOptional.SIZEOF, (int)YGFloatOptional.ALIGNOF), YGLayout.__member((int)4), YGLayout.__member((int)4), YGLayout.__member((int)4), YGLayout.__array((int)YGCachedMeasurement.SIZEOF, (int)YGCachedMeasurement.ALIGNOF, (int)16), YGLayout.__array((int)4, (int)2), YGLayout.__member((int)YGCachedMeasurement.SIZEOF, (int)YGCachedMeasurement.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITIONS = layout.offsetof(0);
        DIMENSIONS = layout.offsetof(1);
        MARGIN = layout.offsetof(2);
        BORDER = layout.offsetof(3);
        PADDING = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
        COMPUTEDFLEXBASISGENERATION = layout.offsetof(6);
        COMPUTEDFLEXBASIS = layout.offsetof(7);
        GENERATIONCOUNT = layout.offsetof(8);
        LASTOWNERDIRECTION = layout.offsetof(9);
        NEXTCACHEDMEASUREMENTSINDEX = layout.offsetof(10);
        CACHEDMEASUREMENTS = layout.offsetof(11);
        MEASUREDDIMENSIONS = layout.offsetof(12);
        CACHEDLAYOUT = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<YGLayout, Buffer> {
        private static final YGLayout ELEMENT_FACTORY = YGLayout.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGLayout getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[4]")
        public FloatBuffer positions() {
            return YGLayout.npositions(this.address());
        }

        public float positions(int index) {
            return YGLayout.npositions(this.address(), index);
        }

        @NativeType(value="float[2]")
        public FloatBuffer dimensions() {
            return YGLayout.ndimensions(this.address());
        }

        public float dimensions(int index) {
            return YGLayout.ndimensions(this.address(), index);
        }

        @NativeType(value="float[4]")
        public FloatBuffer margin() {
            return YGLayout.nmargin(this.address());
        }

        public float margin(int index) {
            return YGLayout.nmargin(this.address(), index);
        }

        @NativeType(value="float[4]")
        public FloatBuffer border() {
            return YGLayout.nborder(this.address());
        }

        public float border(int index) {
            return YGLayout.nborder(this.address(), index);
        }

        @NativeType(value="float[4]")
        public FloatBuffer padding() {
            return YGLayout.npadding(this.address());
        }

        public float padding(int index) {
            return YGLayout.npadding(this.address(), index);
        }

        @NativeType(value="YGDirection")
        public int direction() {
            return YGLayout.ndirection(this.address());
        }

        @NativeType(value="bool")
        public boolean didUseLegacyFlag() {
            return YGLayout.ndidUseLegacyFlag(this.address());
        }

        @NativeType(value="bool")
        public boolean doesLegacyStretchFlagAffectsLayout() {
            return YGLayout.ndoesLegacyStretchFlagAffectsLayout(this.address());
        }

        @NativeType(value="bool")
        public boolean hadOverflow() {
            return YGLayout.nhadOverflow(this.address());
        }

        @NativeType(value="uint32_t")
        public int computedFlexBasisGeneration() {
            return YGLayout.ncomputedFlexBasisGeneration(this.address());
        }

        public YGFloatOptional computedFlexBasis() {
            return YGLayout.ncomputedFlexBasis(this.address());
        }

        @NativeType(value="uint32_t")
        public int generationCount() {
            return YGLayout.ngenerationCount(this.address());
        }

        @NativeType(value="YGDirection")
        public int lastOwnerDirection() {
            return YGLayout.nlastOwnerDirection(this.address());
        }

        @NativeType(value="uint32_t")
        public int nextCachedMeasurementsIndex() {
            return YGLayout.nnextCachedMeasurementsIndex(this.address());
        }

        @NativeType(value="YGCachedMeasurement[16]")
        public YGCachedMeasurement.Buffer cachedMeasurements() {
            return YGLayout.ncachedMeasurements(this.address());
        }

        public YGCachedMeasurement cachedMeasurements(int index) {
            return YGLayout.ncachedMeasurements(this.address(), index);
        }

        @NativeType(value="float[2]")
        public FloatBuffer measuredDimensions() {
            return YGLayout.nmeasuredDimensions(this.address());
        }

        public float measuredDimensions(int index) {
            return YGLayout.nmeasuredDimensions(this.address(), index);
        }

        public YGCachedMeasurement cachedLayout() {
            return YGLayout.ncachedLayout(this.address());
        }
    }
}

