/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.zip;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;
import org.pentaho.reporting.libraries.resourceloader.loader.zip.ZipEntryKey;
import org.pentaho.reporting.libraries.resourceloader.loader.zip.ZipResourceData;

public class ZipResourceLoader
implements ResourceLoader {
    public static final String SCHEMA_NAME = ZipResourceLoader.class.getName();
    private static final Logger logger = Logger.getLogger(ZipResourceLoader.class.getName());

    @Override
    public boolean isSupportedKey(ResourceKey key) {
        return SCHEMA_NAME.equals(key.getSchema());
    }

    @Override
    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        if (!(value instanceof ZipEntryKey)) {
            return null;
        }
        ZipEntryKey entryKey = (ZipEntryKey)value;
        ResourceKey parentKey = entryKey.getZipFile().getKey();
        return new ResourceKey(parentKey, SCHEMA_NAME, entryKey.getEntryName(), factoryKeys);
    }

    @Override
    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        HashMap map;
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        String entry = path != null ? LoaderUtils.mergePaths((String)parent.getIdentifier(), path) : (String)parent.getIdentifier();
        if (factoryKeys != null) {
            map = new HashMap();
            map.putAll(parent.getFactoryParameters());
            map.putAll(factoryKeys);
        } else {
            map = parent.getFactoryParameters();
        }
        return new ResourceKey(parent.getParent(), parent.getSchema(), entry, map);
    }

    @Override
    public URL toURL(ResourceKey key) {
        return null;
    }

    @Override
    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new ZipResourceData(key);
    }

    @Override
    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        throw new ResourceKeyCreationException("Can not deserialize a ZipResourceKey");
    }

    @Override
    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Not supported");
        }
        ZipEntryKey entryKey = (ZipEntryKey)key.getIdentifier();
        String name = entryKey.getEntryName();
        ResourceKey zipKey = entryKey.getZipFile().getKey();
        throw new ResourceException("Can not serialize a ZipResourceKey");
    }

    @Override
    public boolean isSupportedDeserializer(String data) {
        return SCHEMA_NAME.equals(ResourceKeyUtils.readSchemaFromString(data));
    }
}

