/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.queues;

import io.smallrye.mutiny.helpers.Subscriptions;
import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;

public class DrainUtils {
    protected static final long COMPLETED_MASK = Long.MIN_VALUE;
    protected static final long REQUESTED_MASK = Long.MAX_VALUE;

    private DrainUtils() {
    }

    public static <T> boolean postCompleteRequest(long n, Flow.Subscriber<? super T> downstream, Queue<T> queue, AtomicLong requested, BooleanSupplier isCancelled) {
        long r0;
        long u;
        long r;
        while (!requested.compareAndSet(r = requested.get(), u = r & Long.MIN_VALUE | Subscriptions.add(r0 = r & Long.MAX_VALUE, n))) {
        }
        if (r == Long.MIN_VALUE) {
            DrainUtils.postCompleteDrain(n | Long.MIN_VALUE, downstream, queue, requested, isCancelled);
            return true;
        }
        return false;
    }

    private static <T> boolean postCompleteDrain(long n, Flow.Subscriber<? super T> downstream, Queue<T> queue, AtomicLong requested, BooleanSupplier isCancelled) {
        long e = n & Long.MIN_VALUE;
        while (true) {
            if (e != n) {
                if (isCancelled.getAsBoolean()) {
                    return true;
                }
                T t = queue.poll();
                if (t == null) {
                    downstream.onComplete();
                    return true;
                }
                downstream.onNext(t);
                ++e;
                continue;
            }
            if (isCancelled.getAsBoolean()) {
                return true;
            }
            if (queue.isEmpty()) {
                downstream.onComplete();
                return true;
            }
            n = requested.get();
            if (n != e) continue;
            n = requested.addAndGet(-(e & Long.MAX_VALUE));
            if ((n & Long.MAX_VALUE) == 0L) {
                return false;
            }
            e = n & Long.MIN_VALUE;
        }
    }

    public static <T> void postComplete(Flow.Subscriber<? super T> downstream, Queue<T> queue, AtomicLong requested, BooleanSupplier isCancelled) {
        long u;
        long r;
        if (queue.isEmpty()) {
            downstream.onComplete();
            return;
        }
        if (DrainUtils.postCompleteDrain(requested.get(), downstream, queue, requested, isCancelled)) {
            return;
        }
        do {
            if (((r = requested.get()) & Long.MIN_VALUE) == 0L) continue;
            return;
        } while (!requested.compareAndSet(r, u = r | Long.MIN_VALUE));
        if (r != 0L) {
            DrainUtils.postCompleteDrain(u, downstream, queue, requested, isCancelled);
        }
    }
}

