/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.CollapsedDumpParser;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.JVMThread;
import com.intellij.profiler.model.NativeCall;
import com.intellij.profiler.ultimate.async.AsyncProfilerDumpParserProviderKt;
import com.intellij.profiler.ultimate.model.JavaCachingStackElementReader;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u0018\u0010\t\u001a\u00020\n*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0018\u0010\f\u001a\u00020\n*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"createCollapsedParser", "Lcom/intellij/profiler/CollapsedDumpParser;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "project", "Lcom/intellij/openapi/project/Project;", "parseAsyncProfilerThread", "Lcom/intellij/profiler/model/JVMThread;", "string", "", "isJvmMethod", "", "(Ljava/lang/String;)Z", "isLinuxLib", "intellij.profiler.ultimate"})
public final class AsyncProfilerDumpParserProviderKt {
    @NotNull
    public static final CollapsedDumpParser<BaseCallStackElement> createCollapsedParser(@Nullable Project project) {
        JavaCachingStackElementReader reader = JavaCachingStackElementReader.Companion.getOrCreate(project);
        DummyCallTreeBuilder flameChartBuilder = new DummyCallTreeBuilder(null, null, 3, null);
        return new CollapsedDumpParser(flameChartBuilder, (Function1)createCollapsedParser.1.INSTANCE, arg_0 -> AsyncProfilerDumpParserProviderKt.createCollapsedParser$lambda$0(reader, arg_0), AsyncProfilerDumpParserProviderKt::createCollapsedParser$lambda$1);
    }

    private static final JVMThread parseAsyncProfilerThread(String string) {
        String nameNoBrackets = StringsKt.dropLast((String)StringsKt.drop((String)string, (int)1), (int)1);
        if (StringsKt.startsWith$default((String)nameNoBrackets, (String)"tid=", (boolean)false, (int)2, null)) {
            String string2 = nameNoBrackets.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return new JVMThread("id=" + string2);
        }
        String nativeId = StringsKt.substringAfterLast((String)nameNoBrackets, (String)" tid=", (String)"");
        if (Intrinsics.areEqual((Object)nativeId, (Object)"")) {
            return new JVMThread(nameNoBrackets);
        }
        String string3 = nameNoBrackets.substring(0, nameNoBrackets.length() - nativeId.length() - 5);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return new JVMThread(nativeId, string3);
    }

    private static final boolean isJvmMethod(String $this$isJvmMethod) {
        return (StringsKt.contains$default((CharSequence)$this$isJvmMethod, (char)'/', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isJvmMethod, (char)'.', (boolean)false, (int)2, null)) && StringUtil.isJavaIdentifierStart((char)StringsKt.first((CharSequence)$this$isJvmMethod));
    }

    private static final boolean isLinuxLib(String $this$isLinuxLib) {
        return StringsKt.startsWith$default((String)$this$isLinuxLib, (String)"/", (boolean)false, (int)2, null);
    }

    private static final BaseCallStackElement createCollapsedParser$lambda$0(JavaCachingStackElementReader $reader, String frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        String clean = StringsKt.substringBeforeLast$default((String)frame, (String)"_[", null, (int)2, null);
        return NativeCall.Companion.isCPPCall(clean) || NativeCall.Companion.isObjCCall(clean) ? JavaCachingStackElementReader.parseNativeCall$default($reader, clean, null, 2, null) : (!AsyncProfilerDumpParserProviderKt.isLinuxLib(clean) && AsyncProfilerDumpParserProviderKt.isJvmMethod(clean) ? (BaseCallStackElement)$reader.parseJavaCall(clean) : JavaCachingStackElementReader.parseNativeCall$default($reader, clean, null, 2, null));
    }

    private static final boolean createCollapsedParser$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((CharSequence)it, (char)'[', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)it, (char)']', (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)it, (Object)"[unknown]");
    }

    public static final /* synthetic */ JVMThread access$parseAsyncProfilerThread(String string) {
        return AsyncProfilerDumpParserProviderKt.parseAsyncProfilerThread(string);
    }
}

